TucanaProgressBar = function() { };

// Message Processor

/**
 * Namespace for server->client message processor
 */
TucanaProgressBar.MessageProcessor = function() { };

/**
 * Static message processing method.  This method delegates to specific handlers.
 * 
 * @param messagePartElement message element to process
 */
TucanaProgressBar.MessageProcessor.process = function(messagePartElement) {
    for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
        if (messagePartElement.childNodes[i].nodeType == 1) {
            switch (messagePartElement.childNodes[i].tagName) {
            case "init":
                TucanaProgressBar.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                break;
            case "dispose":
                TucanaProgressBar.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                break;
            }
        }
    }
};

/**
 * Processes a <code>dispose</code> message to finalize the state of a
 * selection component that is being removed.
 *
 * @param disposeMessageElement the <code>dispose</code> element to process
 */
TucanaProgressBar.MessageProcessor.processDispose = function(disposeMessageElement) {
    var componentId = disposeMessageElement.getAttribute("eid");
	var selectorComponentId = EchoDomPropertyStore.getPropertyValue(componentId, "selector-eid");
	if (selectorComponentId != null) {
		TucanaFileUploadSelector.ListenerManager.removeListener(selectorComponentId, componentId);
	}
};

/**
 * Processes an <code>init</code> message to initialize the state of a 
 * selection component that is being added.
 *
 * @param initMessageElement the <code>init</code> element to process
 */
TucanaProgressBar.MessageProcessor.processInit = function(initMessageElement) {
    var componentId = initMessageElement.getAttribute("eid");
    var selectorComponentId = initMessageElement.getAttribute("selector-eid");

	var element = document.getElementById(componentId);
	if (element == null) {
		return;
	}
	var progressElement = document.getElementById(componentId + "_progress");

	if (selectorComponentId != null) {
		EchoDomPropertyStore.setPropertyValue(element, "selector-eid", selectorComponentId);
		TucanaFileUploadSelector.ListenerManager.addListener(selectorComponentId, componentId, 
			function(bytes, totalBytes, rate) {
				var val;
				if (totalBytes == 0) {
					val = 0;
				} else {
					val = (bytes / totalBytes) * 100;
					if (val < 0) {
					    val = 0;
					}
					if (val > 100) {
					    val = 100;
					}
				}
				var widthString = val.toString() + "%";
				progressElement.style.width = val.toString() + "%";
			});
	};
};
