/**
 * Component rendering peer: ScrollPanel.
 */
Stream.Sync.ScrollPanel = Core.extend(Echo.Sync.Panel, {
    
    $load: function() {
        Echo.Render.registerPeer("ScrollPanel", this);
    },
    
    /** @see Echo.Render.ComponentSync#renderAdd */
    renderAdd: function(update, parentElement) {
        this._div = document.createElement("div");
        this._div.id = this.component.renderId;
        this.renderStyle(this._div);
        if (this.component.children.length !== 0) {
            Echo.Render.renderComponentAdd(update, this.component.children[0], this._div);
        }
        parentElement.appendChild(this._div);
    },

    /** @see Echo.Sync.Composite#renderStyle */
    renderStyle: function(element) {
        var width = this.component.render("width");
        var height = this.component.render("height");
        var scrollVisible = this.component.render("scrollVisible", true);
        if (scrollVisible) {
	        element.style.overflow = "auto";    
        } else {
        	element.style.overflow = "hidden";
        }
        if (!height || Echo.Sync.Extent.isPercent(height)) {
			height = "100px";
        }
        Echo.Sync.renderComponentDefaults(this.component, element);
        Echo.Sync.Border.render(this.component.render("border"), element);
        Echo.Sync.Insets.render(this.component.render("insets"), element, "padding");
        Echo.Sync.FillImage.render(this.component.render("backgroundImage"), element);
        Echo.Sync.Extent.render(width, element, "width", true, true);
        Echo.Sync.Extent.render(height, element, "height", false, false);
    }
    
});
