/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.tree;

import java.util.EventListener;
import nextapp.echo.app.event.EventListenerList;
import nextapp.echo.extras.app.event.TreeModelEvent;
import nextapp.echo.extras.app.event.TreeModelListener;
import nextapp.echo.extras.app.tree.TreeModel;
import nextapp.echo.extras.app.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.addListener(TreeModelListener.class, (EventListener)l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.removeListener(TreeModelListener.class, (EventListener)l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public String getColumnName(int column) {
        StringBuffer sb = new StringBuffer();
        int value = column;
        do {
            int digit = value % 26;
            sb.insert(0, (char)(65 + digit));
        } while ((value = value / 26 - 1) >= 0);
        return sb.toString();
    }

    public Class getColumnClass(int column) {
        return Object.class;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesAdded(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i]).treeStructureChanged(e);
        }
    }
}

