/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.FillImageBorder;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Pane;
import nextapp.echo.app.PaneContainer;
import nextapp.echo.extras.app.event.TabClosingEvent;
import nextapp.echo.extras.app.event.TabClosingListener;
import nextapp.echo.extras.app.event.TabSelectionEvent;
import nextapp.echo.extras.app.event.TabSelectionListener;

public class TabPane
extends Component
implements Pane,
PaneContainer {
    public static final String INPUT_TAB_CLOSE = "tabClose";
    public static final String INPUT_TAB_SELECT = "tabSelect";
    public static final String ACTIVE_TAB_INDEX_CHANGED_PROPERTY = "activeTabIndex";
    public static final String TAB_CLOSING_LISTENERS_CHANGED_PROPERTY = "tabClosingListeners";
    public static final String TAB_SELECTION_LISTENERS_CHANGED_PROPERTY = "tabSelectionListeners";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_BORDER_TYPE = "borderType";
    public static final String PROPERTY_DEFAULT_CONTENT_INSETS = "defaultContentInsets";
    public static final String PROPERTY_IMAGE_BORDER = "imageBorder";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ROLLOVER_SCROLL_LEFT_ICON = "rolloverScrollLeftIcon";
    public static final String PROPERTY_ROLLOVER_SCROLL_RIGHT_ICON = "rolloverScrollRightIcon";
    public static final String PROPERTY_SCROLL_LEFT_ICON = "scrollLeftIcon";
    public static final String PROPERTY_SCROLL_RIGHT_ICON = "scrollRightIcon";
    public static final String PROPERTY_TAB_ACTIVE_BACKGROUND = "tabActiveBackground";
    public static final String PROPERTY_TAB_ACTIVE_BACKGROUND_IMAGE = "tabActiveBackgroundImage";
    public static final String PROPERTY_TAB_ACTIVE_BACKGROUND_INSETS = "tabActiveBackgroundInsets";
    public static final String PROPERTY_TAB_ACTIVE_BORDER = "tabActiveBorder";
    public static final String PROPERTY_TAB_ACTIVE_FONT = "tabActiveFont";
    public static final String PROPERTY_TAB_ACTIVE_FOREGROUND = "tabActiveForeground";
    public static final String PROPERTY_TAB_ACTIVE_HEIGHT_INCREASE = "tabActiveHeightIncrease";
    public static final String PROPERTY_TAB_ACTIVE_IMAGE_BORDER = "tabActiveImageBorder";
    public static final String PROPERTY_TAB_ACTIVE_INSETS = "tabActiveInsets";
    public static final String PROPERTY_TAB_ACTIVE_LEFT_IMAGE = "tabActiveLeftImage";
    public static final String PROPERTY_TAB_ACTIVE_RIGHT_IMAGE = "tabActiveRightImage";
    public static final String PROPERTY_TAB_ALIGNMENT = "tabAlignment";
    public static final String PROPERTY_TAB_BACKGROUND_IMAGE = "tabBackgroundImage";
    public static final String PROPERTY_TAB_CLOSE_ENABLED = "tabCloseEnabled";
    public static final String PROPERTY_TAB_CLOSE_ICON = "tabCloseIcon";
    public static final String PROPERTY_TAB_CLOSE_ICON_ROLLOVER_ENABLED = "tabCloseIconRolloverEnabled";
    public static final String PROPERTY_TAB_DEFAULT_CLOSE_OPERATION = "tabDefaultCloseOperation";
    public static final String PROPERTY_TAB_DISABLED_CLOSE_ICON = "tabDisabledCloseIcon";
    public static final String PROPERTY_TAB_HEIGHT = "tabHeight";
    public static final String PROPERTY_TAB_ICON_TEXT_MARGIN = "tabIconTextMargin";
    public static final String PROPERTY_TAB_INACTIVE_BACKGROUND = "tabInactiveBackground";
    public static final String PROPERTY_TAB_INACTIVE_BACKGROUND_IMAGE = "tabInactiveBackgroundImage";
    public static final String PROPERTY_TAB_INACTIVE_BACKGROUND_INSETS = "tabInactiveBackgroundInsets";
    public static final String PROPERTY_TAB_INACTIVE_BORDER = "tabInactiveBorder";
    public static final String PROPERTY_TAB_INACTIVE_FONT = "tabInactiveFont";
    public static final String PROPERTY_TAB_INACTIVE_FOREGROUND = "tabInactiveForeground";
    public static final String PROPERTY_TAB_INACTIVE_IMAGE_BORDER = "tabInactiveImageBorder";
    public static final String PROPERTY_TAB_INACTIVE_INSETS = "tabInactiveInsets";
    public static final String PROPERTY_TAB_INACTIVE_LEFT_IMAGE = "tabInactiveLeftImage";
    public static final String PROPERTY_TAB_INACTIVE_RIGHT_IMAGE = "tabInactiveRightImage";
    public static final String PROPERTY_TAB_INSET = "tabInset";
    public static final String PROPERTY_TAB_MAXIMUM_WIDTH = "tabMaximumWidth";
    public static final String PROPERTY_TAB_POSITION = "tabPosition";
    public static final String PROPERTY_TAB_ROLLOVER_CLOSE_ICON = "tabRolloverCloseIcon";
    public static final String PROPERTY_TAB_ROLLOVER_BACKGROUND = "tabRolloverBackground";
    public static final String PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE = "tabRolloverBackgroundImage";
    public static final String PROPERTY_TAB_ROLLOVER_BACKGROUND_INSETS = "tabRolloverBackgroundInsets";
    public static final String PROPERTY_TAB_ROLLOVER_BORDER = "tabRolloverBorder";
    public static final String PROPERTY_TAB_ROLLOVER_ENABLED = "tabRolloverEnabled";
    public static final String PROPERTY_TAB_ROLLOVER_FONT = "tabRolloverFont";
    public static final String PROPERTY_TAB_ROLLOVER_FOREGROUND = "tabRolloverForeground";
    public static final String PROPERTY_TAB_ROLLOVER_IMAGE_BORDER = "tabRolloverImageBorder";
    public static final String PROPERTY_TAB_SPACING = "tabSpacing";
    public static final String PROPERTY_TAB_WIDTH = "tabWidth";
    public static final int BORDER_TYPE_ADJACENT_TO_TABS = 1;
    public static final int BORDER_TYPE_NONE = 0;
    public static final int BORDER_TYPE_PARALLEL_TO_TABS = 2;
    public static final int BORDER_TYPE_SURROUND = 3;
    public static final int TAB_DO_NOTHING_ON_CLOSE = 0;
    public static final int TAB_DISPOSE_ON_CLOSE = 1;
    public static final int TAB_POSITION_TOP = 0;
    public static final int TAB_POSITION_BOTTOM = 1;
    private int activeTabIndex = -1;

    public void addTabClosingListener(TabClosingListener l) {
        this.getEventListenerList().addListener(TabClosingListener.class, (EventListener)l);
        this.firePropertyChange(TAB_CLOSING_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void addTabSelectionListener(TabSelectionListener l) {
        this.getEventListenerList().addListener(TabSelectionListener.class, (EventListener)l);
        this.firePropertyChange(TAB_SELECTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    protected void fireTabClosing(int tabIndex) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(TabClosingListener.class);
        if (listeners.length == 0) {
            return;
        }
        TabClosingEvent e = new TabClosingEvent((Object)this, tabIndex);
        for (int i = 0; i < listeners.length; ++i) {
            ((TabClosingListener)listeners[i]).tabClosing(e);
        }
    }

    protected void fireTabSelected(int tabIndex) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(TabSelectionListener.class);
        if (listeners.length == 0) {
            return;
        }
        TabSelectionEvent e = new TabSelectionEvent((Object)this, tabIndex);
        for (int i = 0; i < listeners.length; ++i) {
            ((TabSelectionListener)listeners[i]).tabSelected(e);
        }
    }

    public int getActiveTabIndex() {
        return this.activeTabIndex;
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public int getBorderType() {
        Integer value = (Integer)this.get(PROPERTY_BORDER_TYPE);
        if (value == null) {
            return 1;
        }
        return value;
    }

    public Insets getDefaultContentInsets() {
        return (Insets)this.get(PROPERTY_DEFAULT_CONTENT_INSETS);
    }

    public FillImageBorder getImageBorder() {
        return (FillImageBorder)this.get(PROPERTY_IMAGE_BORDER);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public ImageReference getRolloverScrollLeftIcon() {
        return (ImageReference)this.get(PROPERTY_ROLLOVER_SCROLL_LEFT_ICON);
    }

    public ImageReference getRolloverScrollRightIcon() {
        return (ImageReference)this.get(PROPERTY_ROLLOVER_SCROLL_RIGHT_ICON);
    }

    public ImageReference getScrollLeftIcon() {
        return (ImageReference)this.get(PROPERTY_SCROLL_LEFT_ICON);
    }

    public ImageReference getScrollRightIcon() {
        return (ImageReference)this.get(PROPERTY_SCROLL_RIGHT_ICON);
    }

    public Color getTabActiveBackground() {
        return (Color)this.get(PROPERTY_TAB_ACTIVE_BACKGROUND);
    }

    public FillImage getTabActiveBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_ACTIVE_BACKGROUND_IMAGE);
    }

    public Insets getTabActiveBackgroundInsets() {
        return (Insets)this.get(PROPERTY_TAB_ACTIVE_BACKGROUND_INSETS);
    }

    public Border getTabActiveBorder() {
        return (Border)this.get(PROPERTY_TAB_ACTIVE_BORDER);
    }

    public Font getTabActiveFont() {
        return (Font)this.get(PROPERTY_TAB_ACTIVE_FONT);
    }

    public Color getTabActiveForeground() {
        return (Color)this.get(PROPERTY_TAB_ACTIVE_FOREGROUND);
    }

    public Extent getTabActiveHeightIncrease() {
        return (Extent)this.get(PROPERTY_TAB_ACTIVE_HEIGHT_INCREASE);
    }

    public Insets getTabActiveInsets() {
        return (Insets)this.get(PROPERTY_TAB_ACTIVE_INSETS);
    }

    public FillImageBorder getTabActiveImageBorder() {
        return (FillImageBorder)this.get(PROPERTY_TAB_ACTIVE_IMAGE_BORDER);
    }

    public ImageReference getTabActiveLeftImage() {
        return (ImageReference)this.get(PROPERTY_TAB_ACTIVE_LEFT_IMAGE);
    }

    public ImageReference getTabActiveRightImage() {
        return (ImageReference)this.get(PROPERTY_TAB_ACTIVE_RIGHT_IMAGE);
    }

    public Alignment getTabAlignment() {
        return (Alignment)this.get(PROPERTY_TAB_ALIGNMENT);
    }

    public FillImage getTabBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_BACKGROUND_IMAGE);
    }

    public ImageReference getTabCloseIcon() {
        return (ImageReference)this.get(PROPERTY_TAB_CLOSE_ICON);
    }

    public int getTabDefaultCloseOperation() {
        Integer defaultCloseOperationValue = (Integer)this.get(PROPERTY_TAB_DEFAULT_CLOSE_OPERATION);
        return defaultCloseOperationValue == null ? 1 : defaultCloseOperationValue;
    }

    public ImageReference getTabDisabledCloseIcon() {
        return (ImageReference)this.get(PROPERTY_TAB_DISABLED_CLOSE_ICON);
    }

    public Extent getTabHeight() {
        return (Extent)this.get(PROPERTY_TAB_HEIGHT);
    }

    public Extent getTabIconTextMargin() {
        return (Extent)this.get(PROPERTY_TAB_ICON_TEXT_MARGIN);
    }

    public Color getTabInactiveBackground() {
        return (Color)this.get(PROPERTY_TAB_INACTIVE_BACKGROUND);
    }

    public FillImage getTabInactiveBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_INACTIVE_BACKGROUND_IMAGE);
    }

    public Insets getTabInactiveBackgroundInsets() {
        return (Insets)this.get(PROPERTY_TAB_INACTIVE_BACKGROUND_INSETS);
    }

    public Border getTabInactiveBorder() {
        return (Border)this.get(PROPERTY_TAB_INACTIVE_BORDER);
    }

    public Font getTabInactiveFont() {
        return (Font)this.get(PROPERTY_TAB_INACTIVE_FONT);
    }

    public Color getTabInactiveForeground() {
        return (Color)this.get(PROPERTY_TAB_INACTIVE_FOREGROUND);
    }

    public FillImageBorder getTabInactiveImageBorder() {
        return (FillImageBorder)this.get(PROPERTY_TAB_INACTIVE_IMAGE_BORDER);
    }

    public Insets getTabInactiveInsets() {
        return (Insets)this.get(PROPERTY_TAB_INACTIVE_INSETS);
    }

    public ImageReference getTabInactiveLeftImage() {
        return (ImageReference)this.get(PROPERTY_TAB_INACTIVE_LEFT_IMAGE);
    }

    public ImageReference getTabInactiveRightImage() {
        return (ImageReference)this.get(PROPERTY_TAB_INACTIVE_RIGHT_IMAGE);
    }

    public Extent getTabInset() {
        return (Extent)this.get(PROPERTY_TAB_INSET);
    }

    public Extent getTabMaximumWidth() {
        return (Extent)this.get(PROPERTY_TAB_MAXIMUM_WIDTH);
    }

    public int getTabPosition() {
        Integer tabPosition = (Integer)this.get(PROPERTY_TAB_POSITION);
        return tabPosition == null ? 0 : tabPosition;
    }

    public Color getTabRolloverBackground() {
        return (Color)this.get(PROPERTY_TAB_ROLLOVER_BACKGROUND);
    }

    public FillImage getTabRolloverBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE);
    }

    public Insets getTabRolloverBackgroundInsets() {
        return (Insets)this.get(PROPERTY_TAB_ROLLOVER_BACKGROUND_INSETS);
    }

    public Border getTabRolloverBorder() {
        return (Border)this.get(PROPERTY_TAB_ROLLOVER_BORDER);
    }

    public ImageReference getTabRolloverCloseIcon() {
        return (ImageReference)this.get(PROPERTY_TAB_ROLLOVER_CLOSE_ICON);
    }

    public Font getTabRolloverFont() {
        return (Font)this.get(PROPERTY_TAB_ROLLOVER_FONT);
    }

    public Color getTabRolloverForeground() {
        return (Color)this.get(PROPERTY_TAB_ROLLOVER_FOREGROUND);
    }

    public FillImageBorder getTabRolloverImageBorder() {
        return (FillImageBorder)this.get(PROPERTY_TAB_ROLLOVER_IMAGE_BORDER);
    }

    public Extent getTabSpacing() {
        return (Extent)this.get(PROPERTY_TAB_SPACING);
    }

    public Extent getTabWidth() {
        return (Extent)this.get(PROPERTY_TAB_WIDTH);
    }

    public boolean hasTabClosingListeners() {
        if (!this.hasEventListenerList()) {
            return false;
        }
        return this.getEventListenerList().getListenerCount(TabClosingListener.class) > 0;
    }

    public boolean hasTabSelectionListeners() {
        if (!this.hasEventListenerList()) {
            return false;
        }
        return this.getEventListenerList().getListenerCount(TabSelectionListener.class) > 0;
    }

    public boolean isTabCloseEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_TAB_CLOSE_ENABLED);
        return value == null ? false : value;
    }

    public boolean isTabCloseIconRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_TAB_CLOSE_ICON_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isTabRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_TAB_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isValidParent(Component c) {
        if (!super.isValidParent(c)) {
            return false;
        }
        return c instanceof PaneContainer;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (inputValue == null) {
            return;
        }
        if (ACTIVE_TAB_INDEX_CHANGED_PROPERTY.equals(inputName)) {
            this.setActiveTabIndex((Integer)inputValue);
        } else if (INPUT_TAB_SELECT.equals(inputName)) {
            this.userTabSelect((Integer)inputValue);
        } else if (INPUT_TAB_CLOSE.equals(inputName)) {
            this.userTabClose((Integer)inputValue);
        }
    }

    public void removeTabClosingListener(TabClosingListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(TabClosingListener.class, (EventListener)l);
        this.firePropertyChange(TAB_CLOSING_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void removeTabSelectionListener(TabSelectionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(TabSelectionListener.class, (EventListener)l);
        this.firePropertyChange(TAB_SELECTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void setActiveTabIndex(int newValue) {
        int oldValue = this.activeTabIndex;
        this.activeTabIndex = newValue;
        this.firePropertyChange(ACTIVE_TAB_INDEX_CHANGED_PROPERTY, new Integer(oldValue), new Integer(newValue));
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setBorderType(int newValue) {
        this.set(PROPERTY_BORDER_TYPE, new Integer(newValue));
    }

    public void setDefaultContentInsets(Insets newValue) {
        this.set(PROPERTY_DEFAULT_CONTENT_INSETS, newValue);
    }

    public void setImageBorder(FillImageBorder newValue) {
        this.set(PROPERTY_IMAGE_BORDER, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setRolloverScrollLeftIcon(ImageReference newValue) {
        this.set(PROPERTY_ROLLOVER_SCROLL_LEFT_ICON, newValue);
    }

    public void setRolloverScrollRightIcon(ImageReference newValue) {
        this.set(PROPERTY_ROLLOVER_SCROLL_RIGHT_ICON, newValue);
    }

    public void setScrollLeftIcon(ImageReference newValue) {
        this.set(PROPERTY_SCROLL_LEFT_ICON, newValue);
    }

    public void setScrollRightIcon(ImageReference newValue) {
        this.set(PROPERTY_SCROLL_RIGHT_ICON, newValue);
    }

    public void setTabActiveBackground(Color newValue) {
        this.set(PROPERTY_TAB_ACTIVE_BACKGROUND, newValue);
    }

    public void setTabActiveBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_ACTIVE_BACKGROUND_IMAGE, newValue);
    }

    public void setTabActiveBackgroundInsets(Insets newValue) {
        this.set(PROPERTY_TAB_ACTIVE_BACKGROUND_INSETS, newValue);
    }

    public void setTabActiveBorder(Border newValue) {
        this.set(PROPERTY_TAB_ACTIVE_BORDER, newValue);
    }

    public void setTabActiveFont(Font newValue) {
        this.set(PROPERTY_TAB_ACTIVE_FONT, newValue);
    }

    public void setTabActiveForeground(Color newValue) {
        this.set(PROPERTY_TAB_ACTIVE_FOREGROUND, newValue);
    }

    public void setTabActiveHeightIncrease(Extent newValue) {
        this.set(PROPERTY_TAB_ACTIVE_HEIGHT_INCREASE, newValue);
    }

    public void setTabActiveImageBorder(FillImageBorder newValue) {
        this.set(PROPERTY_TAB_ACTIVE_IMAGE_BORDER, newValue);
    }

    public void setTabActiveInsets(Insets newValue) {
        this.set(PROPERTY_TAB_ACTIVE_INSETS, newValue);
    }

    public void setTabActiveLeftImage(ImageReference newValue) {
        this.set(PROPERTY_TAB_ACTIVE_LEFT_IMAGE, newValue);
    }

    public void setTabActiveRightImage(ImageReference newValue) {
        this.set(PROPERTY_TAB_ACTIVE_RIGHT_IMAGE, newValue);
    }

    public void setTabAlignment(Alignment newValue) {
        this.set(PROPERTY_TAB_ALIGNMENT, newValue);
    }

    public void setTabBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_BACKGROUND_IMAGE, newValue);
    }

    public void setTabCloseEnabled(boolean newValue) {
        this.set(PROPERTY_TAB_CLOSE_ENABLED, new Boolean(newValue));
    }

    public void setTabCloseIcon(ImageReference newValue) {
        this.set(PROPERTY_TAB_CLOSE_ICON, newValue);
    }

    public void setTabCloseIconRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_TAB_CLOSE_ICON_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setTabDefaultCloseOperation(int newValue) {
        this.set(PROPERTY_TAB_DEFAULT_CLOSE_OPERATION, new Integer(newValue));
    }

    public void setTabDisabledCloseIcon(ImageReference newValue) {
        this.set(PROPERTY_TAB_DISABLED_CLOSE_ICON, newValue);
    }

    public void setTabHeight(Extent newValue) {
        this.set(PROPERTY_TAB_HEIGHT, newValue);
    }

    public void setTabIconTextMargin(Extent newValue) {
        this.set(PROPERTY_TAB_ICON_TEXT_MARGIN, newValue);
    }

    public void setTabInactiveBackground(Color newValue) {
        this.set(PROPERTY_TAB_INACTIVE_BACKGROUND, newValue);
    }

    public void setTabInactiveBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_INACTIVE_BACKGROUND_IMAGE, newValue);
    }

    public void setTabInactiveBackgroundInsets(Insets newValue) {
        this.set(PROPERTY_TAB_INACTIVE_BACKGROUND_INSETS, newValue);
    }

    public void setTabInactiveBorder(Border newValue) {
        this.set(PROPERTY_TAB_INACTIVE_BORDER, newValue);
    }

    public void setTabInactiveFont(Font newValue) {
        this.set(PROPERTY_TAB_INACTIVE_FONT, newValue);
    }

    public void setTabInactiveForeground(Color newValue) {
        this.set(PROPERTY_TAB_INACTIVE_FOREGROUND, newValue);
    }

    public void setTabInactiveImageBorder(FillImageBorder newValue) {
        this.set(PROPERTY_TAB_INACTIVE_IMAGE_BORDER, newValue);
    }

    public void setTabInactiveInsets(Insets newValue) {
        this.set(PROPERTY_TAB_INACTIVE_INSETS, newValue);
    }

    public void setTabInactiveLeftImage(ImageReference newValue) {
        this.set(PROPERTY_TAB_INACTIVE_LEFT_IMAGE, newValue);
    }

    public void setTabInactiveRightImage(ImageReference newValue) {
        this.set(PROPERTY_TAB_INACTIVE_RIGHT_IMAGE, newValue);
    }

    public void setTabInset(Extent newValue) {
        this.set(PROPERTY_TAB_INSET, newValue);
    }

    public void setTabMaximumWidth(Extent newValue) {
        this.set(PROPERTY_TAB_MAXIMUM_WIDTH, newValue);
    }

    public void setTabPosition(int newValue) {
        this.set(PROPERTY_TAB_POSITION, new Integer(newValue));
    }

    public void setTabRolloverBackground(Color newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BACKGROUND, newValue);
    }

    public void setTabRolloverBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE, newValue);
    }

    public void setTabRolloverBackgroundInsets(Insets newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BACKGROUND_INSETS, newValue);
    }

    public void setTabRolloverBorder(Border newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BORDER, newValue);
    }

    public void setTabRolloverCloseIcon(ImageReference newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_CLOSE_ICON, newValue);
    }

    public void setTabRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setTabRolloverFont(Font newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_FONT, newValue);
    }

    public void setTabRolloverForeground(Color newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_FOREGROUND, newValue);
    }

    public void setTabRolloverImageBorder(FillImageBorder newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_IMAGE_BORDER, newValue);
    }

    public void setTabSpacing(Extent newValue) {
        this.set(PROPERTY_TAB_SPACING, newValue);
    }

    public void setTabWidth(Extent newValue) {
        this.set(PROPERTY_TAB_WIDTH, newValue);
    }

    public void userTabClose(int tabIndex) {
        int defaultCloseOperation;
        this.fireTabClosing(tabIndex);
        Integer defaultCloseOperationValue = (Integer)this.getRenderProperty(PROPERTY_TAB_DEFAULT_CLOSE_OPERATION);
        int n = defaultCloseOperation = defaultCloseOperationValue == null ? 1 : defaultCloseOperationValue;
        if (defaultCloseOperation == 1) {
            this.remove(this.getVisibleComponent(tabIndex));
        }
    }

    public void userTabSelect(int tabIndex) {
        this.fireTabSelected(tabIndex);
        this.setActiveTabIndex(tabIndex);
    }
}

