/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.extras.app.menu.AbstractMenuComponent;
import nextapp.echo.extras.app.menu.MenuModel;
import nextapp.echo.extras.app.menu.MenuSelectionModel;
import nextapp.echo.extras.app.menu.MenuStateModel;
import nextapp.echo.extras.app.menu.OptionModel;

public class DropDownMenu
extends AbstractMenuComponent {
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BACKGROUND_IMAGE = "disabledBackgroundImage";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_DISABLED_EXPAND_ICON = "disabledExpandIcon";
    public static final String PROPERTY_EXPAND_ICON = "expandIcon";
    public static final String PROPERTY_EXPAND_ICON_WIDTH = "expandIconWidth";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_LINE_WRAP = "lineWrap";
    public static final String PROPERTY_MENU_HEIGHT = "menuHeight";
    public static final String PROPERTY_MENU_BACKGROUND = "menuBackground";
    public static final String PROPERTY_MENU_BACKGROUND_IMAGE = "menuBackgroundImage";
    public static final String PROPERTY_MENU_BORDER = "menuBorder";
    public static final String PROPERTY_MENU_EXPAND_ICON = "menuExpandIcon";
    public static final String PROPERTY_MENU_FOREGROUND = "menuForeground";
    public static final String PROPERTY_MENU_FONT = "menuFont";
    public static final String PROPERTY_MENU_WIDTH = "menuWidth";
    public static final String PROPERTY_SELECTION_BACKGROUND = "selectionBackground";
    public static final String PROPERTY_SELECTION_BACKGROUND_IMAGE = "selectionBackgroundImage";
    public static final String PROPERTY_SELECTION_FOREGROUND = "selectionForeground";
    public static final String PROPERTY_SELECTION_TEXT = "selectionText";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_INSETS = "insets";
    public static final String SELECTION_CHANGED_PROPERTY = "selection";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "selectionModel";
    private MenuSelectionModel selectionModel;
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            DropDownMenu.this.firePropertyChange(DropDownMenu.SELECTION_CHANGED_PROPERTY, null, null);
        }
    };

    public DropDownMenu() {
        this(null);
    }

    public DropDownMenu(MenuModel model) {
        this(model, (MenuStateModel)null);
    }

    public DropDownMenu(MenuModel model, MenuStateModel stateModel) {
        super(model, stateModel);
    }

    public DropDownMenu(MenuModel model, MenuSelectionModel selectionModel) {
        super(model, null);
        this.setSelectionModel(selectionModel);
    }

    public void processInput(String name, Object value) {
        if (SELECTION_CHANGED_PROPERTY.equals(name) && this.selectionModel != null) {
            this.selectionModel.setSelectedId(((OptionModel)value).getId());
        } else {
            super.processInput(name, value);
        }
    }

    public void doAction(OptionModel optionModel) {
        if (this.selectionModel == null) {
            super.doAction(optionModel);
        } else {
            this.selectionModel.setSelectedId(optionModel.getId());
            this.fireActionPerformed(optionModel);
        }
    }

    public MenuSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getSelectionText() {
        return (String)this.get(PROPERTY_SELECTION_TEXT);
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public Color getDisabledBackground() {
        return (Color)this.get(PROPERTY_DISABLED_BACKGROUND);
    }

    public FillImage getDisabledBackgroundImage() {
        return (FillImage)this.get(PROPERTY_DISABLED_BACKGROUND_IMAGE);
    }

    public ImageReference getDisabledExpandIcon() {
        return (ImageReference)this.get(PROPERTY_DISABLED_EXPAND_ICON);
    }

    public Color getDisabledForeground() {
        return (Color)this.get(PROPERTY_DISABLED_FOREGROUND);
    }

    public ImageReference getExpandIcon() {
        return (ImageReference)this.get(PROPERTY_EXPAND_ICON);
    }

    public Extent getExpandIconWidth() {
        return (Extent)this.get(PROPERTY_EXPAND_ICON_WIDTH);
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Extent getMenuHeight() {
        return (Extent)this.get(PROPERTY_MENU_HEIGHT);
    }

    public Extent getMenuWidth() {
        return (Extent)this.get(PROPERTY_MENU_WIDTH);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public Color getMenuBackground() {
        return (Color)this.get(PROPERTY_MENU_BACKGROUND);
    }

    public FillImage getMenuBackgroundImage() {
        return (FillImage)this.get(PROPERTY_MENU_BACKGROUND_IMAGE);
    }

    public Border getMenuBorder() {
        return (Border)this.get(PROPERTY_MENU_BORDER);
    }

    public ImageReference getMenuExpandIcon() {
        return (ImageReference)this.get(PROPERTY_MENU_EXPAND_ICON);
    }

    public Color getMenuForeground() {
        return (Color)this.get(PROPERTY_MENU_FOREGROUND);
    }

    public Font getMenuFont() {
        return (Font)this.get(PROPERTY_MENU_FONT);
    }

    public Color getSelectionBackground() {
        return (Color)this.get(PROPERTY_SELECTION_BACKGROUND);
    }

    public FillImage getSelectionBackgroundImage() {
        return (FillImage)this.get(PROPERTY_SELECTION_BACKGROUND_IMAGE);
    }

    public Color getSelectionForeground() {
        return (Color)this.get(PROPERTY_SELECTION_FOREGROUND);
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public boolean isLineWrap() {
        Boolean value = (Boolean)this.get(PROPERTY_LINE_WRAP);
        return value == null ? true : value;
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND_IMAGE, newValue);
    }

    public void setDisabledExpandIcon(ImageReference newValue) {
        this.set(PROPERTY_DISABLED_EXPAND_ICON, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.set(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setExpandIcon(ImageReference newValue) {
        this.set(PROPERTY_EXPAND_ICON, newValue);
    }

    public void setExpandIconWidth(Extent newValue) {
        Extent.validate((Extent)newValue, (int)1);
        if (newValue != null && newValue.getValue() < 0) {
            throw new IllegalArgumentException("Extent value may not be negative.");
        }
        this.set(PROPERTY_EXPAND_ICON_WIDTH, newValue);
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setLineWrap(boolean newValue) {
        this.set(PROPERTY_LINE_WRAP, new Boolean(newValue));
    }

    public void setMenuHeight(Extent newValue) {
        this.set(PROPERTY_MENU_HEIGHT, newValue);
    }

    public void setMenuWidth(Extent newValue) {
        this.set(PROPERTY_MENU_WIDTH, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setMenuBackground(Color newValue) {
        this.set(PROPERTY_MENU_BACKGROUND, newValue);
    }

    public void setMenuBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_MENU_BACKGROUND_IMAGE, newValue);
    }

    public void setMenuBorder(Border newValue) {
        this.set(PROPERTY_MENU_BORDER, newValue);
    }

    public void setMenuExpandIcon(ImageReference newValue) {
        this.set(PROPERTY_MENU_EXPAND_ICON, newValue);
    }

    public void setMenuForeground(Color newValue) {
        this.set(PROPERTY_MENU_FOREGROUND, newValue);
    }

    public void setMenuFont(Font newValue) {
        this.set(PROPERTY_MENU_FONT, newValue);
    }

    public void setSelectionBackground(Color newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND, newValue);
    }

    public void setSelectionBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND_IMAGE, newValue);
    }

    public void setSelectionForeground(Color newValue) {
        this.set(PROPERTY_SELECTION_FOREGROUND, newValue);
    }

    public void setSelectionModel(MenuSelectionModel newValue) {
        MenuSelectionModel oldValue = this.selectionModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeListener);
        }
        this.selectionModel = newValue;
        if (newValue != null) {
            newValue.addChangeListener(this.changeListener);
        }
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setSelectionText(String newValue) {
        this.set(PROPERTY_SELECTION_TEXT, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }
}

