/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import java.util.EventListener;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Pane;
import nextapp.echo.app.PaneContainer;
import nextapp.echo.extras.app.event.TabSelectionEvent;
import nextapp.echo.extras.app.event.TabSelectionListener;

public class AccordionPane
extends Component
implements Pane,
PaneContainer {
    public static final String ACTIVE_TAB_INDEX_CHANGED_PROPERTY = "activeTabIndex";
    public static final String TAB_SELECTION_LISTENERS_CHANGED_PROPERTY = "tabSelectionListeners";
    public static final int DEFAULT_ANIMATION_TIME = 350;
    public static final String INPUT_TAB_SELECT = "tabSelect";
    public static final String PROPERTY_ANIMATION_TIME = "animationTime";
    public static final String PROPERTY_DEFAULT_CONTENT_INSETS = "defaultContentInsets";
    public static final String PROPERTY_TAB_BACKGROUND = "tabBackground";
    public static final String PROPERTY_TAB_BACKGROUND_IMAGE = "tabBackgroundImage";
    public static final String PROPERTY_TAB_BORDER = "tabBorder";
    public static final String PROPERTY_TAB_FOREGROUND = "tabForeground";
    public static final String PROPERTY_TAB_INSETS = "tabInsets";
    public static final String PROPERTY_TAB_ROLLOVER_BACKGROUND = "tabRolloverBackground";
    public static final String PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE = "tabRolloverBackgroundImage";
    public static final String PROPERTY_TAB_ROLLOVER_BORDER = "tabRolloverBorder";
    public static final String PROPERTY_TAB_ROLLOVER_ENABLED = "tabRolloverEnabled";
    public static final String PROPERTY_TAB_ROLLOVER_FOREGROUND = "tabRolloverForeground";
    private int activeTabIndex = -1;

    public void addTabSelectionListener(TabSelectionListener l) {
        this.getEventListenerList().addListener(TabSelectionListener.class, (EventListener)l);
        this.firePropertyChange(TAB_SELECTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    protected void fireTabSelected(int tabIndex) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(TabSelectionListener.class);
        if (listeners.length == 0) {
            return;
        }
        TabSelectionEvent e = new TabSelectionEvent((Object)this, tabIndex);
        for (int i = 0; i < listeners.length; ++i) {
            ((TabSelectionListener)listeners[i]).tabSelected(e);
        }
    }

    public int getActiveTabIndex() {
        return this.activeTabIndex;
    }

    public int getAnimationTime() {
        Integer animationTime = (Integer)this.get(PROPERTY_ANIMATION_TIME);
        return animationTime == null ? 350 : animationTime;
    }

    public Insets getDefaultContentInsets() {
        return (Insets)this.get(PROPERTY_DEFAULT_CONTENT_INSETS);
    }

    public Color getTabBackground() {
        return (Color)this.get(PROPERTY_TAB_BACKGROUND);
    }

    public FillImage getTabBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_BACKGROUND_IMAGE);
    }

    public Border getTabBorder() {
        return (Border)this.get(PROPERTY_TAB_BORDER);
    }

    public Color getTabForeground() {
        return (Color)this.get(PROPERTY_TAB_FOREGROUND);
    }

    public Insets getTabInsets() {
        return (Insets)this.get(PROPERTY_TAB_INSETS);
    }

    public Color getTabRolloverBackground() {
        return (Color)this.get(PROPERTY_TAB_ROLLOVER_BACKGROUND);
    }

    public FillImage getTabRolloverBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE);
    }

    public Border getTabRolloverBorder() {
        return (Border)this.get(PROPERTY_TAB_ROLLOVER_BORDER);
    }

    public Color getTabRolloverForeground() {
        return (Color)this.get(PROPERTY_TAB_ROLLOVER_FOREGROUND);
    }

    public boolean hasTabSelectionListeners() {
        if (!this.hasEventListenerList()) {
            return false;
        }
        return this.getEventListenerList().getListenerCount(TabSelectionListener.class) > 0;
    }

    public boolean isTabRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_TAB_ROLLOVER_ENABLED);
        return value == null ? true : value;
    }

    public boolean isValidParent(Component c) {
        if (!super.isValidParent(c)) {
            return false;
        }
        return c instanceof PaneContainer;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (inputValue == null) {
            return;
        }
        if (ACTIVE_TAB_INDEX_CHANGED_PROPERTY.equals(inputName)) {
            this.setActiveTabIndex((Integer)inputValue);
        } else if (INPUT_TAB_SELECT.equals(inputName)) {
            this.userTabSelect((Integer)inputValue);
        }
    }

    public void removeTabSelectionListener(TabSelectionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(TabSelectionListener.class, (EventListener)l);
        this.firePropertyChange(TAB_SELECTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void setActiveTabIndex(int newValue) {
        int oldValue = this.activeTabIndex;
        this.activeTabIndex = newValue;
        this.firePropertyChange(ACTIVE_TAB_INDEX_CHANGED_PROPERTY, new Integer(oldValue), new Integer(newValue));
    }

    public void setAnimationTime(int newValue) {
        this.set(PROPERTY_ANIMATION_TIME, new Integer(newValue));
    }

    public void setDefaultContentInsets(Insets newValue) {
        this.set(PROPERTY_DEFAULT_CONTENT_INSETS, newValue);
    }

    public void setTabBackground(Color newValue) {
        this.set(PROPERTY_TAB_BACKGROUND, newValue);
    }

    public void setTabBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_BACKGROUND_IMAGE, newValue);
    }

    public void setTabBorder(Border newValue) {
        this.set(PROPERTY_TAB_BORDER, newValue);
    }

    public void setTabForeground(Color newValue) {
        this.set(PROPERTY_TAB_FOREGROUND, newValue);
    }

    public void setTabInsets(Insets newValue) {
        this.set(PROPERTY_TAB_INSETS, newValue);
    }

    public void setTabRolloverBackground(Color newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BACKGROUND, newValue);
    }

    public void setTabRolloverBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BACKGROUND_IMAGE, newValue);
    }

    public void setTabRolloverBorder(Border newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_BORDER, newValue);
    }

    public void setTabRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setTabRolloverForeground(Color newValue) {
        this.set(PROPERTY_TAB_ROLLOVER_FOREGROUND, newValue);
    }

    public void userTabSelect(int tabIndex) {
        this.fireTabSelected(tabIndex);
        this.setActiveTabIndex(tabIndex);
    }
}

