/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser.compiler141;

import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Options;
import com.tombrus.javaParser.CancelCompile;
import com.tombrus.javaParser.CompilerCallerCreator;
import com.tombrus.javaParser.CompilerCallerInterface;
import com.tombrus.javaParser.Examiner;
import com.tombrus.javaParser.ParserException;
import com.tombrus.javaParser.ProgressKeeper;
import com.tombrus.javaParser.compiler141.Dumpy;
import com.tombrus.javaParser.compiler141.ExaminerHolder;
import com.tombrus.javaParser.compiler141.ProgressKeeperHolder;
import com.tombrus.javaParser.compiler141.TwistedCompiler;
import com.tombrus.javaParser.compiler141.TwistedEnter;
import com.tombrus.javaParser.compiler141.TwistedLog;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class CompilerCaller
implements CompilerCallerInterface {
    private static final int NUM_PROGRESS_PHASES = 6;
    public boolean dumpTree;
    public boolean showCompilerOutput;
    private Context context;
    private ProgressKeeper progressKeeper;
    private Log log;
    private TwistedCompiler compiler;
    private TwistedEnter enter;
    private Options options;

    public void setDebugFlags(boolean bl, boolean bl2) {
        this.showCompilerOutput = bl2;
        this.dumpTree = bl;
    }

    public void compile(String string, File[] fileArray, Examiner examiner) {
        this.compile(string, fileArray, examiner, null);
    }

    public void compile(String string, File[] fileArray, Examiner examiner, HashMap hashMap) {
        Object object;
        this.context = new Context();
        this.options = Options.instance((Context)this.context);
        if (hashMap != null) {
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                this.options.put((Object)string2, hashMap.get(string2));
            }
        }
        this.options.put((Object)"-classpath", (Object)string);
        this.options.put((Object)"-nowarn", (Object)"true");
        object = new ArrayList();
        int n = 0;
        while (n < fileArray.length) {
            ((ArrayList)object).add(fileArray[n].getPath());
            ++n;
        }
        Object[] objectArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        StringWriter stringWriter = new StringWriter();
        examiner = ExaminerHolder.ExaminerInstance(this.context, examiner);
        this.progressKeeper = ProgressKeeperHolder.ProgressKeeperInstance(this.context, 6 * (objectArray.length - 1));
        this.log = TwistedLog.TwistedLogInstance(this.context, new PrintWriter(stringWriter));
        this.enter = TwistedEnter.TwistedEnterInstance(this.context);
        this.compiler = TwistedCompiler.TwistedCompilerInstance(this.context);
        try {
            CancelCompile.checkCancel(examiner);
            this.compiler.compile(List.make((Object[])objectArray));
            List list = this.enter.getTrees();
            CancelCompile.checkCancel(examiner);
            if (this.dumpTree) {
                new Dumpy("Tree after compile:").dump(list);
            }
            this.visitAllVisitors(examiner, list);
        }
        catch (CancelCompile cancelCompile) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            examiner.outOfMemoryError(outOfMemoryError);
        }
        catch (Throwable throwable) {
            System.err.println("Throwable during compile: " + throwable);
            throwable.printStackTrace();
            if (throwable instanceof ParserException) {
                throw (ParserException)throwable;
            }
            throw new ParserException("Compiler says: " + throwable.getMessage());
        }
        if (this.showCompilerOutput) {
            System.err.println("COMPILER OUTPUT:");
            System.err.println(stringWriter.toString());
        }
    }

    private void visitAllVisitors(Examiner examiner, List list) {
        Runnable[] runnableArray = examiner.getVisitors(CompilerCallerCreator.getAvailableCompilerMarker(), this.context, list);
        int n = 0;
        while (n < runnableArray.length) {
            if (runnableArray[n] == null) {
                throw new ParserException("Could not find a proper listener for this version of tools.jar");
            }
            runnableArray[n].run();
            ++n;
        }
    }
}

