/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheKey;
import org.hibernate.stat.CategorizedStatistics;

public class SecondLevelCacheStatistics
extends CategorizedStatistics {
    private transient Cache cache;
    long hitCount;
    long missCount;
    long putCount;

    SecondLevelCacheStatistics(Cache cache) {
        super(cache.getRegionName());
        this.cache = cache;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getPutCount() {
        return this.putCount;
    }

    public long getElementCountInMemory() {
        return this.cache.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this.cache.getElementCountOnDisk();
    }

    public long getSizeInMemory() {
        return this.cache.getSizeInMemory();
    }

    public Map getEntries() {
        HashMap map = new HashMap();
        Iterator iter = this.cache.toMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            map.put(((CacheKey)me.getKey()).getKey(), me.getValue());
        }
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("SecondLevelCacheStatistics").append("[hitCount=").append(this.hitCount).append(",missCount=").append(this.missCount).append(",putCount=").append(this.putCount);
        if (this.cache != null) {
            buf.append(",elementCountInMemory=").append(this.getElementCountInMemory()).append(",elementCountOnDisk=").append(this.getElementCountOnDisk()).append(",sizeInMemory=").append(this.getSizeInMemory());
        }
        buf.append(']');
        return buf.toString();
    }
}

