/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class FunctionsManager
implements Serializable {
    private static final long IP_10_0_0_1 = new Long("167772161");
    private static final long IP_10_255_255_254 = new Long("184549374");
    private static final long IP_172_16_0_1 = new Long("2886729729");
    private static final long IP_172_31_255_254 = new Long("2887778302");
    private static final long IP_192_168_0_1 = new Long("3232235521");
    private static final long IP_192_168_255_254 = new Long("3232301054");
    private static Pattern ipv4Patt = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");
    private static Pattern ipv6Patt = Pattern.compile("[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}:[0-9a-f]{1,4}");
    private static final long LOCAL_IP = new Long("2130706433");
    private static final long serialVersionUID = 9054236843015748640L;

    public static BigDecimal convertStringToBigDecimal(String string) {
        if (string == null) {
            return null;
        }
        BigDecimal bigDecimal = null;
        String string2 = string.trim().replace(',', '.');
        try {
            bigDecimal = new BigDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            char[] cArray;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = 0;
            for (char c : cArray = string2.toCharArray()) {
                if ((c < '0' || c > '9') && c != '.') continue;
                if (c == '.') {
                    if (++n > 1) continue;
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
                bl = true;
            }
            bigDecimal = bl ? new BigDecimal(stringBuffer.toString()) : new BigDecimal(1);
        }
        return bigDecimal;
    }

    public static String generateNewPassForCurrentDay() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(":yy-MM-dd");
        String string = simpleDateFormat.format(calendar.getTime()).toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("STR");
        stringBuffer.append(string);
        return SimpleCoder.encode((String)stringBuffer.toString());
    }

    public static String getAmountAsString(BigDecimal bigDecimal, String string) {
        return FunctionsManager.getAmountAsString(bigDecimal, string, true);
    }

    public static String getAmountAsString(BigDecimal bigDecimal, String string, boolean bl) {
        if (bigDecimal == null) {
            return "";
        }
        if (bl && bigDecimal.setScale(4, RoundingMode.HALF_UP).equals(new BigDecimal(0).setScale(4))) {
            return Res.phone;
        }
        if (string == null) {
            string = "";
        }
        DecimalFormat decimalFormat = FunctionsManager.getDecimalFormat(2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimalFormat.format(bigDecimal));
        if (!string.equals("")) {
            stringBuffer.append(" ").append(string.toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static DateFormat getDateFormat(int n) {
        return DateFormat.getDateInstance(n, ClientLocale.getCurrent());
    }

    public static DateFormat getDateTimeFormat(int n) {
        return DateFormat.getDateTimeInstance(n, n, ClientLocale.getCurrent());
    }

    public static DecimalFormat getDecimalEditFormat(Integer n) {
        if (n.equals(0)) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getIntegerInstance(ClientLocale.getCurrent());
            decimalFormat.setGroupingUsed(false);
            return decimalFormat;
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(ClientLocale.getCurrent());
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setGroupingUsed(false);
        return decimalFormat;
    }

    public static DecimalFormat getDecimalFormat(Integer n) {
        if (n.equals(0)) {
            return (DecimalFormat)NumberFormat.getIntegerInstance(ClientLocale.getCurrent());
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(ClientLocale.getCurrent());
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setMinimumFractionDigits(n);
        return decimalFormat;
    }

    public static String getFilteredStan(BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl, int n) {
        if (bigDecimal == null) {
            return Res.lack;
        }
        DecimalFormat decimalFormat = FunctionsManager.getDecimalFormat(n);
        int n2 = bigDecimal.setScale(4, RoundingMode.HALF_UP).compareTo(new BigDecimal(0).setScale(4, RoundingMode.HALF_UP));
        switch (n2) {
            case 1: {
                int n3 = bigDecimal.compareTo(bigDecimal2.setScale(4, RoundingMode.HALF_UP));
                if (bl && n3 == 1) {
                    return "> " + decimalFormat.format(bigDecimal2);
                }
                return decimalFormat.format(bigDecimal);
            }
        }
        return Res.lack;
    }

    public static IPVersion getIPVersion(String string) {
        Matcher matcher = ipv4Patt.matcher(string);
        if (matcher.find()) {
            return IPVersion.IPv4;
        }
        Matcher matcher2 = ipv6Patt.matcher(string);
        if (matcher2.find()) {
            return IPVersion.IPv6;
        }
        return IPVersion.unknown;
    }

    public static boolean isClientLocal(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        switch (FunctionsManager.getIPVersion(string)) {
            case IPv4: {
                try {
                    String[] stringArray = string.split("\\.");
                    long l = 0x1000000L * Long.parseLong(stringArray[0]) + 65536L * Long.parseLong(stringArray[1]) + 256L * Long.parseLong(stringArray[2]) + 1L * Long.parseLong(stringArray[3]);
                    if (l == LOCAL_IP || l >= IP_10_0_0_1 && l <= IP_10_255_255_254 || l >= IP_172_16_0_1 && l <= IP_172_31_255_254 || l >= IP_192_168_0_1 && l <= IP_192_168_255_254) {
                        bl = true;
                        break;
                    }
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case IPv6: {
                String[] stringArray = string.split("\\:");
                if (!"0".equals(stringArray[0]) || !"0".equals(stringArray[1]) || !"0".equals(stringArray[2]) || !"0".equals(stringArray[3]) || !"0".equals(stringArray[4]) || !"0".equals(stringArray[5]) || !"0".equals(stringArray[6]) || !"1".equals(stringArray[7])) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static Integer[] splitStringToIntegerArray(String string, String string2) {
        String[] stringArray = string.split(string2);
        Integer[] integerArray = new Integer[stringArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            try {
                integerArray[i] = Integer.valueOf(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                integerArray[i] = 0;
            }
        }
        return integerArray;
    }

    private FunctionsManager() {
    }

    static {
        ResourceManager.bind(FunctionsManager.class);
    }

    @ResourceContainer
    private static class Res {
        private static String lack;
        private static String phone;

        private Res() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IPVersion {
        IPv4,
        IPv6,
        unknown;

    }
}

