/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.beans.ConfigBean;
import pl.com.stream.pcbiznes.echo.lib.config.ConfigFactory;
import pl.com.stream.pcbiznes.echo.lib.event.KontrahWithNipNotFoundEvent;
import pl.com.stream.pcbiznes.echo.lib.event.RegistrationProcessEvent;
import pl.com.stream.pcbiznes.echo.lib.event.RegistrationProcessListener;
import pl.com.stream.pcbiznes.echo.lib.mail.DefaultMailManager;
import pl.com.stream.pcbiznes.echo.lib.mail.MailManager;
import pl.com.stream.pcbiznes.echo.lib.util.FunctionsManager;
import pl.com.stream.pcbiznes.hibernate.database.dao.EmailOsobaKtrDAO;
import pl.com.stream.pcbiznes.hibernate.database.dao.KontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.dao.OddzialKontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.dao.OsobaKontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.dao.TypeMailDAO;
import pl.com.stream.pcbiznes.hibernate.database.mappings.EmailOsobaKtr;
import pl.com.stream.pcbiznes.hibernate.database.mappings.GrupaKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OddzialKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.TypeMail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersManager
implements Serializable {
    private static final long serialVersionUID = -4283919576628681119L;
    private ConfigBean configBean;
    private EmailOsobaKtrDAO emailOsobaKtrDAO;
    private KontrahDAO kontrahDAO;
    private EventListenerList listenerList;
    private final MailManager mailManager;
    private OddzialKontrahDAO oddzialKontrahDAO;
    private OsobaKontrahDAO osobaKontrahDAO;
    @ResourceContainer
    private Res res;
    private TypeMailDAO typeMailDAO;

    public UsersManager() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.mailManager = new DefaultMailManager();
    }

    public void addRegistrationProcessListener(RegistrationProcessListener registrationProcessListener) {
        this.getEventListenerList().add(RegistrationProcessListener.class, registrationProcessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(OsobaKontrah osobaKontrah, String string) throws DAOException {
        String string2 = SimpleCoder.encode((String)string.toUpperCase());
        try {
            osobaKontrah.setLogZewHaslo(string2);
            this.getOsobaKontrahDAO().save((Object)osobaKontrah);
        }
        finally {
            this.getOsobaKontrahDAO().closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsobaKontrah getUser(String string, String string2) throws DAOException {
        OsobaKontrah osobaKontrah = null;
        try {
            osobaKontrah = this.getOsobaKontrahDAO().getByEmail(string, string2);
        }
        finally {
            this.getOsobaKontrahDAO().closeSession();
        }
        return osobaKontrah;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsobaKontrah loginUser(String string, String string2, String string3) throws DAOException, MessageException {
        ConfigBean configBean = this.getConfigBean();
        if (!configBean.isCorrectVersionOfPcBiznes(configBean.getRequiredDbVersion())) {
            String string4 = MessageFormat.format(this.res.wrongWersion, configBean.getRequiredDbVersion().toString());
            throw new MessageException(this.res.informationTitle, string4);
        }
        if (!configBean.continueProcess()) {
            throw new MessageException(this.res.informationTitle, this.res.noLicense);
        }
        boolean bl = false;
        try {
            OsobaKontrah osobaKontrah = this.getOsobaKontrahDAO().search(string);
            if (osobaKontrah == null) {
                throw new MessageException(this.res.informationTitle, this.res.wrongLoginOrPass);
            }
            if (!osobaKontrah.getAktywny().equals(1) || !osobaKontrah.getLogZewAktywne().equals(1)) {
                throw new MessageException(this.res.informationTitle, this.res.noRights);
            }
            if (FunctionsManager.isClientLocal(string3) && FunctionsManager.generateNewPassForCurrentDay().equals(SimpleCoder.encode((String)string2))) {
                bl = true;
            } else {
                if (osobaKontrah.getEmailOsobaKtr() == null) {
                    String string5 = MessageFormat.format(this.res.noEmail, string.toLowerCase());
                    throw new MessageException(this.res.informationTitle, string5);
                }
                if (osobaKontrah.getLogZewHaslo() == null) {
                    bl = true;
                } else if (SimpleCoder.decode((String)osobaKontrah.getLogZewHaslo()).toLowerCase().equals(string2.toLowerCase())) {
                    bl = true;
                } else {
                    throw new MessageException(this.res.informationTitle, this.res.wrongLoginOrPass);
                }
            }
            if (bl) {
                OsobaKontrah osobaKontrah2 = osobaKontrah;
                return osobaKontrah2;
            }
        }
        finally {
            this.getOsobaKontrahDAO().closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws DAOException, MessageException {
        ConfigBean configBean = this.getConfigBean();
        Integer[] integerArray = configBean.getIdRodzGrupKtr();
        Integer n = configBean.getIdTypEmail();
        String string10 = configBean.getKodZlozonyGrupaKtr();
        String string11 = configBean.getMailFrom();
        if (!this.validEmail(string11)) {
            throw new MessageException(this.res.informationTitle, this.res.invalidAdminEmailAdress);
        }
        if (n == null) {
            throw new MessageException(this.res.informationTitle, this.res.idTypEmailNotDefined);
        }
        try {
            OddzialKontrah oddzialKontrah;
            if (this.getOsobaKontrahDAO().isLoginUsed(string)) {
                String string12 = MessageFormat.format(this.res.loginUsed, string);
                throw new MessageException(this.res.informationTitle, string12);
            }
            List list = this.getKontrahDAO().getList(string6, string7, string8, string9);
            if (list.size() == 0) {
                this.fireKontrahWithGivenNipNotFound(string6);
                return;
            }
            List<Kontrah> list2 = this.filterKontrahListByGrupaKontrah(list, integerArray, string10);
            Kontrah kontrah = null;
            switch (list2.size()) {
                case 0: {
                    throw new MessageException(this.res.informationTitle, this.res.kontrahWithGivenNipHasNoRights);
                }
                case 1: {
                    kontrah = list2.get(0);
                    break;
                }
                default: {
                    this.fireManyKontrahWithTheSameNIP();
                    return;
                }
            }
            if (kontrah.getOddzialKontrah().size() == 0) {
                oddzialKontrah = this.getOddzialKontrahDAO().create(kontrah, "Firma", true, true);
                kontrah.getOddzialKontrah().add(oddzialKontrah);
                this.getKontrahDAO().save((Object)kontrah);
            }
            if ((oddzialKontrah = kontrah.getOddzialGlowny()) == null) {
                throw new MessageException(this.res.informationTitle, this.res.mainDepartmentNotFound);
            }
            OsobaKontrah osobaKontrah = this.getOsobaKontrahDAO().get(string3, string4, oddzialKontrah);
            if (osobaKontrah == null) {
                osobaKontrah = this.getOsobaKontrahDAO().create(string3, string4, string, string2 == null ? null : SimpleCoder.encode((String)string2.toUpperCase()), oddzialKontrah, false);
            } else {
                if (osobaKontrah.getLogZewLogin() != null && !"".equals(osobaKontrah.getLogZewLogin())) {
                    this.fireAccountExist(osobaKontrah);
                    return;
                }
                osobaKontrah.setLogZewAktywne(Integer.valueOf(1));
                osobaKontrah.setLogZewLogin(string);
                osobaKontrah.setLogZewHaslo(string2 == null ? null : SimpleCoder.encode((String)string2.toUpperCase()));
                osobaKontrah.setImie(string3);
                osobaKontrah.setNazwisko(string4);
            }
            try {
                TypeMail typeMail = (TypeMail)this.getTypeMailDAO().get(n);
                if (typeMail == null && (typeMail = this.getTypeMailDAO().get(this.res.defaultTypEmailName)) == null) {
                    typeMail = this.getTypeMailDAO().create(this.res.defaultTypEmailName, true, false);
                }
                EmailOsobaKtr emailOsobaKtr = null;
                emailOsobaKtr = this.getEmailOsobaKtrDAO().get(typeMail, osobaKontrah);
                if (emailOsobaKtr == null) {
                    emailOsobaKtr = this.getEmailOsobaKtrDAO().create(string5, typeMail, osobaKontrah);
                } else {
                    emailOsobaKtr.setEmail(string5);
                    this.getEmailOsobaKtrDAO().save((Object)emailOsobaKtr);
                }
                osobaKontrah.setEmailOsobaKtr(emailOsobaKtr);
                this.getOsobaKontrahDAO().save((Object)osobaKontrah);
                this.mailManager.sendNewOsobaKontrahRegistred(osobaKontrah);
                this.fireRegistrationComplited(osobaKontrah);
            }
            catch (DAOException dAOException) {
                this.getOsobaKontrahDAO().delete((Object)osobaKontrah);
                osobaKontrah = null;
                throw dAOException;
            }
        }
        finally {
            this.getOsobaKontrahDAO().closeSession();
            this.getKontrahDAO().closeSession();
            this.getOddzialKontrahDAO().closeSession();
            this.getEmailOsobaKtrDAO().closeSession();
            this.getTypeMailDAO().closeSession();
        }
    }

    public void removeRegistrationProcessListener(RegistrationProcessListener registrationProcessListener) {
        this.getEventListenerList().remove(RegistrationProcessListener.class, registrationProcessListener);
    }

    private List<Kontrah> filterKontrahListByGrupaKontrah(List<Kontrah> list, Integer[] integerArray, String string) {
        ArrayList<Kontrah> arrayList = new ArrayList<Kontrah>();
        for (Kontrah kontrah : list) {
            if (!this.isKontrahCanRegisterUsers(kontrah, integerArray, string)) continue;
            arrayList.add(kontrah);
        }
        return arrayList;
    }

    private EmailOsobaKtrDAO getEmailOsobaKtrDAO() {
        if (this.emailOsobaKtrDAO == null) {
            this.emailOsobaKtrDAO = new EmailOsobaKtrDAO();
        }
        return this.emailOsobaKtrDAO;
    }

    private KontrahDAO getKontrahDAO() {
        if (this.kontrahDAO == null) {
            this.kontrahDAO = new KontrahDAO();
        }
        return this.kontrahDAO;
    }

    private OddzialKontrahDAO getOddzialKontrahDAO() {
        if (this.oddzialKontrahDAO == null) {
            this.oddzialKontrahDAO = new OddzialKontrahDAO();
        }
        return this.oddzialKontrahDAO;
    }

    private OsobaKontrahDAO getOsobaKontrahDAO() {
        if (this.osobaKontrahDAO == null) {
            this.osobaKontrahDAO = new OsobaKontrahDAO();
        }
        return this.osobaKontrahDAO;
    }

    private TypeMailDAO getTypeMailDAO() {
        if (this.typeMailDAO == null) {
            this.typeMailDAO = new TypeMailDAO();
        }
        return this.typeMailDAO;
    }

    private boolean isKontrahCanRegisterUsers(Kontrah kontrah, Integer[] integerArray, String string) {
        if (integerArray == null || integerArray.length == 0 || string == null || "".equals(string.trim())) {
            return true;
        }
        for (GrupaKontrah grupaKontrah : kontrah.getGrupyKontrah()) {
            for (Integer n : integerArray) {
                if (!grupaKontrah.getIdRodzGrupKtr().equals(n) || !grupaKontrah.getKodZlozony().toLowerCase().startsWith(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validEmail(String string) {
        Pattern pattern = Pattern.compile("(^[a-zA-Z0-9.\\-_]+@[a-zA-Z0-9\\-.]+\\.[a-zA-Z]{2,4}$)|(^[\\w\\s\\-\u0105\u0107\u0119\u0142\u015b\u017a\u017c\u00f3\u0144\u0104\u0106\u0118\u0141\u015a\u0179\u017b\u00d3\u0143]+<[a-zA-Z0-9.\\-_]+@[a-zA-Z0-9\\-.]+\\.[a-zA-Z]{2,4}>$)");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    protected void fireAccountExist(OsobaKontrah osobaKontrah) {
        RegistrationProcessListener[] registrationProcessListenerArray = (RegistrationProcessListener[])this.getEventListenerList().getListeners(RegistrationProcessListener.class);
        RegistrationProcessEvent registrationProcessEvent = new RegistrationProcessEvent(this, osobaKontrah);
        for (RegistrationProcessListener registrationProcessListener : registrationProcessListenerArray) {
            registrationProcessListener.accountExist(registrationProcessEvent);
        }
    }

    protected void fireKontrahWithGivenNipNotFound(String string) {
        RegistrationProcessListener[] registrationProcessListenerArray = (RegistrationProcessListener[])this.getEventListenerList().getListeners(RegistrationProcessListener.class);
        KontrahWithNipNotFoundEvent kontrahWithNipNotFoundEvent = new KontrahWithNipNotFoundEvent(this, string);
        for (RegistrationProcessListener registrationProcessListener : registrationProcessListenerArray) {
            registrationProcessListener.kontrahWithGivenNipNotFound(kontrahWithNipNotFoundEvent);
        }
    }

    protected void fireManyKontrahWithTheSameNIP() {
        RegistrationProcessListener[] registrationProcessListenerArray = (RegistrationProcessListener[])this.getEventListenerList().getListeners(RegistrationProcessListener.class);
        RegistrationProcessEvent registrationProcessEvent = new RegistrationProcessEvent(this, null);
        for (RegistrationProcessListener registrationProcessListener : registrationProcessListenerArray) {
            registrationProcessListener.manyKontrahWithNip(registrationProcessEvent);
        }
    }

    protected void fireRegistrationComplited(OsobaKontrah osobaKontrah) {
        RegistrationProcessListener[] registrationProcessListenerArray = (RegistrationProcessListener[])this.getEventListenerList().getListeners(RegistrationProcessListener.class);
        RegistrationProcessEvent registrationProcessEvent = new RegistrationProcessEvent(this, osobaKontrah);
        for (RegistrationProcessListener registrationProcessListener : registrationProcessListenerArray) {
            registrationProcessListener.registrationComplited(registrationProcessEvent);
        }
    }

    protected void fireRegistrationFailed(OsobaKontrah osobaKontrah) {
        RegistrationProcessListener[] registrationProcessListenerArray = (RegistrationProcessListener[])this.getEventListenerList().getListeners(RegistrationProcessListener.class);
        RegistrationProcessEvent registrationProcessEvent = new RegistrationProcessEvent(this, osobaKontrah);
        for (RegistrationProcessListener registrationProcessListener : registrationProcessListenerArray) {
            registrationProcessListener.registrationFailed(registrationProcessEvent);
        }
    }

    protected ConfigBean getConfigBean() {
        if (this.configBean == null) {
            this.configBean = ConfigFactory.getDefault();
        }
        return this.configBean;
    }

    protected EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    @ResourceContainer
    private class Res {
        private String defaultTypEmailName;
        private String idTypEmailNotDefined;
        private String informationTitle;
        private String invalidAdminEmailAdress;
        private String kontrahWithGivenNipHasNoRights;
        private String loginUsed;
        private String mainDepartmentNotFound;
        private String noEmail;
        private String noLicense;
        private String noRights;
        private String wrongLoginOrPass;
        private String wrongWersion;

        private Res() {
        }
    }
}

