/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.service;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.mail.EmailException;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.service.AbstractService;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.mail.DefaultMailManager;
import pl.com.stream.pcbiznes.hibernate.database.dao.OsobaKontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

public class OsobaKontrahStrService
extends AbstractService {
    public static final String ACTIVATION_NO_VALUE = "0";
    public static final String ACTIVATION_PARAM = "activate";
    public static final String ACTIVATION_YES_VALUE = "1";
    public static final String ID = "activOsKtr";
    public static OsobaKontrahStrService INSTANCE = new OsobaKontrahStrService();
    public static final String USER_ID_PARAM = "uid";
    private static Logger log = Logger.getLogger(OsobaKontrahStrService.class);

    protected OsobaKontrahStrService() {
    }

    public String getId() {
        return ID;
    }

    public boolean process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpServlet httpServlet) throws IOException {
        String string = httpServletRequest.getParameter(ACTIVATION_PARAM);
        String string2 = httpServletRequest.getParameter(USER_ID_PARAM);
        if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
            this.sendMessage(httpServletResponse, Res.wrongParameters);
        } else {
            this.processActivateUser(httpServletRequest, httpServletResponse, string, string2);
        }
        return false;
    }

    private void sendPotwierdzenieAktywacji(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OsobaKontrah osobaKontrah) throws EmailException, DAOException, IOException {
        DefaultMailManager defaultMailManager = new DefaultMailManager();
        String string = httpServletRequest.getRequestURL().toString();
        defaultMailManager.setCurrentUrl(string);
        try {
            defaultMailManager.sendAccountActivated(osobaKontrah);
        }
        catch (MessageException messageException) {
            this.sendMessage(httpServletResponse, messageException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processActivateUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        Integer n = null;
        Integer n2 = null;
        try {
            n2 = Integer.valueOf(string);
            n = Integer.valueOf(SimpleCoder.decode((String)string2));
        }
        catch (NumberFormatException numberFormatException) {
            this.sendMessage(httpServletResponse, Res.wrongParameters);
            return;
        }
        OsobaKontrahDAO osobaKontrahDAO = new OsobaKontrahDAO();
        OsobaKontrah osobaKontrah = null;
        try {
            osobaKontrah = (OsobaKontrah)osobaKontrahDAO.get(n);
            if (osobaKontrah == null) {
                this.sendMessage(httpServletResponse, Res.wrongParameters);
                return;
            }
            String string3 = osobaKontrah.getLogZewLogin();
            if (n2.equals(1)) {
                if (!osobaKontrah.getAktywny().equals(1)) {
                    osobaKontrah.setAktywny(Integer.valueOf(1));
                    osobaKontrahDAO.save((Object)osobaKontrah);
                    this.sendPotwierdzenieAktywacji(httpServletRequest, httpServletResponse, osobaKontrah);
                    osobaKontrahDAO.deleteFromSession((Object)osobaKontrah);
                    this.sendMessage(httpServletResponse, MessageFormat.format(Res.userActivated, string3));
                } else {
                    this.sendMessage(httpServletResponse, MessageFormat.format(Res.userAlreadyActive, string3));
                }
            } else if (n2.equals(0)) {
                if (!osobaKontrah.getAktywny().equals(0)) {
                    osobaKontrah.setAktywny(Integer.valueOf(0));
                    osobaKontrahDAO.save((Object)osobaKontrah);
                    osobaKontrahDAO.deleteFromSession((Object)osobaKontrah);
                    this.sendMessage(httpServletResponse, MessageFormat.format(Res.userDeactivated, string3));
                } else {
                    this.sendMessage(httpServletResponse, MessageFormat.format(Res.userAlreadyInactive, string3));
                }
            }
        }
        catch (EmailException emailException) {
            this.sendMessage(httpServletResponse, emailException.getMessage());
            log.error((Object)emailException);
        }
        catch (DAOException dAOException) {
            this.sendMessage(httpServletResponse, dAOException.getMessage());
            log.error((Object)dAOException.getMessage(), (Throwable)dAOException);
        }
        finally {
            osobaKontrahDAO.closeSession();
        }
    }

    static {
        ResourceManager.bind(OsobaKontrahStrService.class);
    }

    @ResourceContainer
    private static class Res {
        private static String userActivated;
        private static String userAlreadyActive;
        private static String wrongParameters;
        private static String userDeactivated;
        private static String userAlreadyInactive;

        private Res() {
        }
    }
}

