/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.mail;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class MailSender
implements Serializable {
    private static final long serialVersionUID = 8811379750248484865L;
    private static final Properties sysProps = System.getProperties();
    private boolean configured = false;
    private String host;
    private final Logger log = Logger.getLogger(MailSender.class);
    private String mailFrom;
    @ResourceContainer
    private Res res;
    private String smtpConnectionTimeout;
    private String smtpTimeout;
    private String userName;
    private String userPass;
    private Integer smtpPort;

    public MailSender() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
    }

    public void configure(String string, Integer n, String string2, String string3, String string4, String string5, String string6) {
        this.host = string;
        this.smtpPort = n;
        this.userName = string2;
        this.userPass = string3;
        this.mailFrom = string4;
        this.smtpConnectionTimeout = string5;
        this.smtpTimeout = string6;
        this.configured = string != null && !"".equals(string) && string2 != null && !"".equals(string2) && string3 != null && !"".equals(string3) && string4 != null && !"".equals(string4) && string5 != null && !"".equals(string5) && string6 != null && !"".equals(string6);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void sendHtmlMail(String string, String string2, String string3) throws EmailException {
        if (string2 == null) {
            return;
        }
        long l = System.currentTimeMillis();
        String[] stringArray = string3.split("[|]");
        HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setHostName(this.host);
        htmlEmail.setCharset("iso-8859-2");
        if (this.smtpPort != null) {
            htmlEmail.setSmtpPort(this.smtpPort.intValue());
        }
        for (String string4 : stringArray) {
            htmlEmail.addTo(string4.trim(), string4.trim());
        }
        if (this.mailFrom.indexOf("<") != -1) {
            String string5 = this.mailFrom.substring(0, this.mailFrom.indexOf("<"));
            String string6 = this.mailFrom.substring(this.mailFrom.indexOf("<") + 1, this.mailFrom.length() - 1);
            htmlEmail.setFrom(string6, string5);
        } else {
            htmlEmail.setFrom(this.mailFrom, "");
        }
        htmlEmail.setSubject(string);
        htmlEmail.setAuthentication(this.userName, SimpleCoder.decodeIfStartsWith((String)"@", (String)this.userPass));
        htmlEmail.setHtmlMsg(string2);
        htmlEmail.send();
        this.log.debug((Object)("E-mail sended to: " + string3 + " in " + (System.currentTimeMillis() - l) + " ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMail(String string, String string2, String string3) throws AddressException, MessagingException, UnsupportedEncodingException {
        long l = System.currentTimeMillis();
        if (!this.configured) {
            return false;
        }
        if (!this.userName.equals("") && !this.userPass.equals("")) {
            sysProps.put("mail.smtp.auth", "true");
        }
        sysProps.put("mail.smtp.connectiontimeout", this.smtpConnectionTimeout);
        sysProps.put("mail.smtp.timeout", this.smtpTimeout);
        Session session = Session.getInstance((Properties)sysProps, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string3));
        if (!this.mailFrom.equals("")) {
            mimeMessage.setFrom((Address)new InternetAddress(this.mailFrom));
        }
        String string4 = MimeUtility.encodeText((String)string, (String)"ISO-8859-2", null);
        mimeMessage.setSubject(string4);
        mimeBodyPart.setText(string2, "ISO-8859-2");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.setSentDate(new Date());
        mimeMessage.saveChanges();
        Transport transport = session.getTransport("smtp");
        try {
            transport.connect(this.host, this.userName, SimpleCoder.decodeIfStartsWith((String)"@", (String)this.userPass));
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        }
        finally {
            transport.close();
        }
        this.log.debug((Object)("E-mail sended to: " + string3 + " in: " + (System.currentTimeMillis() - l) + " ms"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String string, Integer n, String string2, String string3, Integer n2, Integer n3) throws MessageException {
        Properties properties = System.getProperties();
        if (!"".equals(string2) && !"".equals(string3)) {
            properties.put("mail.smtp.auth", "true");
        }
        properties.put("mail.smtp.connectiontimeout", n3);
        properties.put("mail.smtp.timeout", n2);
        Session session = Session.getInstance((Properties)properties, null);
        try {
            Transport transport = session.getTransport("smtp");
            try {
                if (n != null) {
                    transport.connect(string, n.intValue(), string2, string3);
                } else {
                    transport.connect(string, string2, string3);
                }
            }
            finally {
                transport.close();
            }
            throw new MessageException(this.res.information, this.res.connectedToMailHost);
        }
        catch (MessagingException messagingException) {
            this.log.error((Object)messagingException.getMessage(), (Throwable)messagingException);
            String string4 = this.res.errorWhileConnectingToMailHost;
            String string5 = messagingException.getMessage();
            if (messagingException.getNextException() instanceof UnknownHostException) {
                string5 = MessageFormat.format(this.res.cannotConnectToMailHost, string);
            }
            if (messagingException instanceof AuthenticationFailedException) {
                string5 = this.res.wrongLoginOrPass;
            }
            throw new MessageException(string4, string5);
        }
    }

    private class Res {
        private String cannotConnectToMailHost;
        private String connectedToMailHost;
        private String errorWhileConnectingToMailHost;
        private String information;
        private String wrongLoginOrPass;

        private Res() {
        }
    }
}

