/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.pcbiznes.echo.lib.util.FunctionsManager;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.KontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailFactory {
    private static Logger log = Logger.getLogger(MailFactory.class);
    protected static final String PARAM_ADRESS = "@adress@";
    protected static final String PARAM_ADRESS_LABEL = "@adress_label@";
    protected static final String PARAM_CITY = "@city@";
    protected static final String PARAM_CITY_LABEL = "@city_label@";
    protected static final String PARAM_COMPANY_NAME = "@company_name@";
    protected static final String PARAM_COUNTRY = "@country@";
    protected static final String PARAM_COUNTRY_LABEL = "@country_label@";
    protected static final String PARAM_DATE_TIME = "@date_time@";
    protected static final String PARAM_FAX = "@fax@";
    protected static final String PARAM_FAX_LABEL = "@fax_label@";
    protected static final String PARAM_IDENTIFIER = "@identifier@";
    protected static final String PARAM_IDENTIFIER_LABEL = "@identifier_label@";
    protected static final String PARAM_INFO = "@info@";
    protected static final String PARAM_KONTRAH_DATA = "@kontrah_data@";
    protected static final String PARAM_NAME = "@name@";
    protected static final String PARAM_NAME_LABEL = "@name_label@";
    protected static final String PARAM_NIP = "@nip@";
    protected static final String PARAM_NIP_LABEL = "@nip_label@";
    protected static final String PARAM_NOTE = "@note@";
    protected static final String PARAM_NUMBER = "@number@";
    protected static final String PARAM_NUMBER_LABEL = "@number_label@";
    protected static final String PARAM_OSOBAKONTRAH_DATA = "@user_data@";
    protected static final String PARAM_OSOBAKONTRAH_EMAIL = "@osobakontrah_email@";
    protected static final String PARAM_OSOBAKONTRAH_EMAIL_LABEL = "@osobakontrah_email_label@";
    protected static final String PARAM_OSOBAKONTRAH_LOGIN = "@login@";
    protected static final String PARAM_OSOBAKONTRAH_LOGIN_LABEL = "@login_label@";
    protected static final String PARAM_OSOBAKONTRAH_NAME = "@osobakontrah_name@";
    protected static final String PARAM_OSOBAKONTRAH_NAME_LABEL = "@osobakontrah_name_label@";
    protected static final String PARAM_OSOBAKONTRAH_PASSWORD = "@password@";
    protected static final String PARAM_OSOBAKONTRAH_PASSWORD_LABEL = "@password_label@";
    protected static final String PARAM_OSOBAKONTRAH_SURNAME = "@osobakontrah_surname@";
    protected static final String PARAM_OSOBAKONTRAH_SURNAME_LABEL = "@osobakontrah_surname_label@";
    protected static final String PARAM_PHONE = "@phone@";
    protected static final String PARAM_PHONE_LABEL = "@phone_label@";
    protected static final String PARAM_POST = "@post@";
    protected static final String PARAM_POST_LABEL = "@post_label@";
    protected static final String PARAM_TITLE = "@title@";
    protected static final String PARAM_WWW_ADRESS = "@www_adress@";
    @ResourceContainer
    protected Res res;

    public MailFactory() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
    }

    public String createNewKontrahBody(KontrahForRegister kontrahForRegister, DaneKontrahForRegister daneKontrahForRegister, String string, String string2, String string3, String string4, String string5, String string6) throws MessageException {
        long l = System.currentTimeMillis();
        DateFormat dateFormat = FunctionsManager.getDateTimeFormat(2);
        String string7 = dateFormat.format(daneKontrahForRegister.getDataZmiany());
        String string8 = Integer.toString(kontrahForRegister.getNrKontrah());
        String string9 = kontrahForRegister.getNazwaSkr();
        String string10 = daneKontrahForRegister.getNazwaDl();
        String string11 = daneKontrahForRegister.getUlicaDomLokal();
        String string12 = daneKontrahForRegister.getNip();
        String string13 = daneKontrahForRegister.getMiejscowosc() != null ? daneKontrahForRegister.getMiejscowosc() : "";
        String string14 = kontrahForRegister.getTelefon() != null ? kontrahForRegister.getTelefon() : "";
        String string15 = kontrahForRegister.getFax() != null ? kontrahForRegister.getFax() : "";
        String string16 = daneKontrahForRegister.getKodPoczta();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_TITLE, string2);
        hashMap.put(PARAM_COMPANY_NAME, string4);
        hashMap.put(PARAM_WWW_ADRESS, this.getUrlArdessTag(string5));
        hashMap.put(PARAM_DATE_TIME, string7);
        hashMap.put(PARAM_NUMBER, string8);
        hashMap.put(PARAM_IDENTIFIER, string9);
        hashMap.put(PARAM_NAME, string10);
        hashMap.put(PARAM_ADRESS, string11);
        hashMap.put(PARAM_NIP, string12);
        hashMap.put(PARAM_CITY, string13);
        hashMap.put(PARAM_PHONE, string14);
        hashMap.put(PARAM_POST, string16);
        hashMap.put(PARAM_FAX, string15);
        hashMap.put(PARAM_COUNTRY, string);
        hashMap.put(PARAM_KONTRAH_DATA, this.res.kontrahData);
        hashMap.put(PARAM_NUMBER_LABEL, this.res.kontrahNumber);
        hashMap.put(PARAM_IDENTIFIER_LABEL, this.res.kontrahIdentifier);
        hashMap.put(PARAM_NAME_LABEL, this.res.kontrahCompanyName);
        hashMap.put(PARAM_ADRESS_LABEL, this.res.kontrahAdress);
        hashMap.put(PARAM_NIP_LABEL, this.res.kontrahNip);
        hashMap.put(PARAM_CITY_LABEL, this.res.kontrahCity);
        hashMap.put(PARAM_PHONE_LABEL, this.res.kontrahPhone);
        hashMap.put(PARAM_POST_LABEL, this.res.kontrahPost);
        hashMap.put(PARAM_FAX_LABEL, this.res.kontrahFax);
        hashMap.put(PARAM_COUNTRY_LABEL, this.res.kontrahCountry);
        hashMap.put(PARAM_INFO, string3);
        hashMap.put(PARAM_NOTE, this.res.note);
        String string17 = this.generateBody(string6, hashMap);
        long l2 = System.currentTimeMillis() - l;
        log.debug((Object)("E-mail (registring Third party) created in: " + l2 + " ms"));
        return string17;
    }

    public String createNewOsobaKontrahBody(OsobaKontrah osobaKontrah, String string, String string2, String string3, String string4, String string5) throws MessageException {
        long l = System.currentTimeMillis();
        Kontrah kontrah = osobaKontrah.getOddzialKontrah().getKontrah();
        DaneKontrah daneKontrah = kontrah.getAktualneDane();
        DateFormat dateFormat = FunctionsManager.getDateTimeFormat(2);
        String string6 = dateFormat.format(new Date());
        String string7 = Integer.toString(kontrah.getNrKontrah());
        String string8 = kontrah.getNazwa();
        String string9 = daneKontrah.getNazwaDl();
        String string10 = daneKontrah.getUlicaDomLokal();
        String string11 = daneKontrah.getNip();
        String string12 = daneKontrah.getMiejscowosc() != null ? daneKontrah.getMiejscowosc() : "";
        String string13 = kontrah.getTelefon() != null ? kontrah.getTelefon() : "";
        String string14 = kontrah.getFax() != null ? kontrah.getFax() : "";
        String string15 = daneKontrah.getKodPoczta();
        String string16 = daneKontrah.getKraj().getNazwaKraju();
        String string17 = osobaKontrah.getNazwisko();
        String string18 = osobaKontrah.getImie();
        String string19 = osobaKontrah.getEmailOsobaKtr().getEmail();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_TITLE, string);
        hashMap.put(PARAM_COMPANY_NAME, string3);
        hashMap.put(PARAM_WWW_ADRESS, this.getUrlArdessTag(string4));
        hashMap.put(PARAM_DATE_TIME, string6);
        hashMap.put(PARAM_NUMBER, string7);
        hashMap.put(PARAM_IDENTIFIER, string8);
        hashMap.put(PARAM_NAME, string9);
        hashMap.put(PARAM_ADRESS, string10);
        hashMap.put(PARAM_NIP, string11);
        hashMap.put(PARAM_CITY, string12);
        hashMap.put(PARAM_PHONE, string13);
        hashMap.put(PARAM_POST, string15);
        hashMap.put(PARAM_FAX, string14);
        hashMap.put(PARAM_COUNTRY, string16);
        hashMap.put(PARAM_OSOBAKONTRAH_SURNAME, string17);
        hashMap.put(PARAM_OSOBAKONTRAH_NAME, string18);
        hashMap.put(PARAM_OSOBAKONTRAH_EMAIL, string19);
        hashMap.put(PARAM_KONTRAH_DATA, this.res.kontrahData);
        hashMap.put(PARAM_NUMBER_LABEL, this.res.kontrahNumber);
        hashMap.put(PARAM_IDENTIFIER_LABEL, this.res.kontrahIdentifier);
        hashMap.put(PARAM_NAME_LABEL, this.res.kontrahCompanyName);
        hashMap.put(PARAM_ADRESS_LABEL, this.res.kontrahAdress);
        hashMap.put(PARAM_NIP_LABEL, this.res.kontrahNip);
        hashMap.put(PARAM_CITY_LABEL, this.res.kontrahCity);
        hashMap.put(PARAM_PHONE_LABEL, this.res.kontrahPhone);
        hashMap.put(PARAM_POST_LABEL, this.res.kontrahPost);
        hashMap.put(PARAM_FAX_LABEL, this.res.kontrahFax);
        hashMap.put(PARAM_COUNTRY_LABEL, this.res.kontrahCountry);
        hashMap.put(PARAM_INFO, string2);
        hashMap.put(PARAM_NOTE, this.res.note);
        hashMap.put(PARAM_OSOBAKONTRAH_DATA, this.res.osobaKontrahData);
        hashMap.put(PARAM_OSOBAKONTRAH_SURNAME_LABEL, this.res.osobaKontrahSurname);
        hashMap.put(PARAM_OSOBAKONTRAH_NAME_LABEL, this.res.osobaKontrahName);
        hashMap.put(PARAM_OSOBAKONTRAH_EMAIL_LABEL, this.res.osobaKontrahEmail);
        String string20 = this.generateBody(string5, hashMap);
        long l2 = System.currentTimeMillis() - l;
        log.debug((Object)("E-mail (registring User) created in: " + l2 + " ms"));
        return string20;
    }

    public String createOsobaKontrahPassBody(OsobaKontrah osobaKontrah, String string, String string2, String string3, String string4, String string5) throws MessageException {
        long l = System.currentTimeMillis();
        DateFormat dateFormat = FunctionsManager.getDateTimeFormat(2);
        String string6 = dateFormat.format(new Date());
        String string7 = osobaKontrah.getLogZewLogin();
        String string8 = SimpleCoder.decode((String)osobaKontrah.getLogZewHaslo());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_TITLE, string);
        hashMap.put(PARAM_COMPANY_NAME, string3);
        hashMap.put(PARAM_WWW_ADRESS, this.getUrlArdessTag(string4));
        hashMap.put(PARAM_DATE_TIME, string6);
        hashMap.put(PARAM_OSOBAKONTRAH_LOGIN_LABEL, this.res.osobaKontrahLogin);
        hashMap.put(PARAM_OSOBAKONTRAH_PASSWORD_LABEL, this.res.osobaKontrahPassword);
        hashMap.put(PARAM_OSOBAKONTRAH_LOGIN, string7);
        hashMap.put(PARAM_OSOBAKONTRAH_PASSWORD, string8);
        hashMap.put(PARAM_INFO, string2);
        hashMap.put(PARAM_NOTE, this.res.note);
        String string9 = this.generateBody(string5, hashMap);
        long l2 = System.currentTimeMillis() - l;
        log.debug((Object)("E-mail (changing / reminding password) created in: " + l2 + " ms"));
        return string9;
    }

    protected String generateBody(String string, Map<String, String> map) throws MessageException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new MessageException(this.res.informationTitle, MessageFormat.format(this.res.htmlTemplateNotFound, string));
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(this.replaceParams(string2, map));
            }
        }
        catch (IOException iOException) {
            String string3 = MessageFormat.format(this.res.readingHtmlTemplateFailed, iOException.getMessage());
            log.error((Object)string3, (Throwable)iOException);
            throw new MessageException(string3, (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuffer.toString();
    }

    protected String getUrlArdessTag(String string) {
        if (string == null) {
            return "";
        }
        String string2 = null;
        String string3 = null;
        if (string.toLowerCase().startsWith("http://")) {
            string2 = string;
            string3 = string.substring(7);
        } else {
            string2 = "http://" + string;
            string3 = string;
        }
        return "<a class=\"moz-txt-link-abbreviated\" href=\"" + string2 + "\">" + string3 + "</a>";
    }

    protected String replaceParams(String string, Map<String, String> map) {
        Set<String> set = map.keySet();
        String string2 = string;
        for (String string3 : set) {
            if (string2.indexOf(string3) == -1) continue;
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                string2 = matcher.replaceAll(map.get(string3));
            }
        }
        return string2 + "\n";
    }

    protected class Res {
        public String htmlTemplateNotFound;
        public String informationTitle;
        public String kontrahAdress;
        public String kontrahCity;
        public String kontrahCompanyName;
        public String kontrahCountry;
        public String kontrahData;
        public String kontrahFax;
        public String kontrahIdentifier;
        public String kontrahNip;
        public String kontrahNumber;
        public String kontrahPhone;
        public String kontrahPost;
        public String note;
        public String osobaKontrahData;
        public String osobaKontrahEmail;
        public String osobaKontrahLogin;
        public String osobaKontrahName;
        public String osobaKontrahPassword;
        public String osobaKontrahSurname;
        public String readingHtmlTemplateFailed;

        protected Res() {
        }
    }
}

