/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.mail;

import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.pcbiznes.echo.lib.beans.ConfigBean;
import pl.com.stream.pcbiznes.echo.lib.config.ConfigFactory;
import pl.com.stream.pcbiznes.echo.lib.mail.MailFactory;
import pl.com.stream.pcbiznes.echo.lib.mail.MailManager;
import pl.com.stream.pcbiznes.echo.lib.mail.MailSender;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneFirmy;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.KontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

public class DefaultMailManager
implements MailManager {
    private static final Logger log = Logger.getLogger(DefaultMailManager.class);
    private static final long serialVersionUID = -3015010198541997726L;
    private ConfigBean configBean;
    private String currentUrl;
    private MailFactory mailFactory;
    private MailSender mailSender;
    @ResourceContainer
    private Res res;

    public DefaultMailManager() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.init();
    }

    public void sendAccountActivated(OsobaKontrah osobaKontrah) throws MessageException {
        String string = MessageFormat.format(this.res.activationForUserTitle, this.getConfigBean().getMailTitlePrefixForUsers());
        String string2 = this.res.activationForUserHeader;
        String string3 = MessageFormat.format(this.res.thanks, this.getThanksSignature());
        String string4 = this.res.activationForUserInfo;
        string4 = string4 + "<br><br>" + string3;
        String string5 = this.getNewOsobaKontrahRegistredBody(osobaKontrah, string2, string4);
        this.sendEmail(osobaKontrah, string, string5);
    }

    public void sendChangePassMail(OsobaKontrah osobaKontrah) throws MessageException {
        String string = MessageFormat.format(this.res.notifyChangePasswordTitle, this.getConfigBean().getMailTitlePrefixForUsers());
        String string2 = this.res.notifyChangePasswordHeader;
        String string3 = this.getOsobaKontrahPass(osobaKontrah, string2);
        this.sendEmail(osobaKontrah, string, string3);
    }

    public void sendNewKontrahRegistred(KontrahForRegister kontrahForRegister, DaneKontrahForRegister daneKontrahForRegister, String string) throws MessageException {
        String string2 = MessageFormat.format(this.res.registerKontrahForCompanyTitle, this.getConfigBean().getTytulStronyWWW(), kontrahForRegister.getNazwaSkr());
        String string3 = this.res.registerKontrahForCompanyHeader;
        String string4 = this.getConfigBean().getMailRegisterKontrahForCompanyMessage();
        if (string4 == null) {
            string4 = this.res.registerKontrahForCompanyInfo;
        }
        String string5 = this.getNewKontrahRegistredBody(kontrahForRegister, daneKontrahForRegister, string, string3, string4);
        this.sendEmail(this.getConfigBean().getMailFrom(), string2, string5);
    }

    public void sendNewOsobaKontrahRegistred(OsobaKontrah osobaKontrah) throws MessageException {
        String string;
        String string2 = MessageFormat.format(this.res.thanks, this.getThanksSignature());
        Kontrah kontrah = osobaKontrah.getOddzialKontrah().getKontrah();
        ConfigBean configBean = this.getConfigBean();
        String string3 = this.res.registerOsobaKontrahForUserHeader;
        String string4 = MessageFormat.format(this.res.registerOsobaKontrahForUserTitle, configBean.getMailTitlePrefixForUsers());
        String string5 = MessageFormat.format(this.res.registerOsobaKontrahForUserInfo, configBean.getTytulStronyWWW());
        string5 = string5 + "<br><br>" + string2;
        String string6 = this.getNewOsobaKontrahRegistredBody(osobaKontrah, string3, string5);
        String string7 = this.res.registerOsobaKontrahForCompanyHeader;
        String string8 = MessageFormat.format(this.res.registerOsobaKontrahForCompanyTitle, configBean.getTytulStronyWWW(), kontrah.getNazwa(), osobaKontrah.getLogZewLogin());
        String string9 = this.createUrl(this.getCurrentUrlAdress(), true, osobaKontrah.getId(), this.res.activateAccound);
        String string10 = this.createUrl(this.getCurrentUrlAdress(), false, osobaKontrah.getId(), this.res.deactivateAccound);
        String string11 = MessageFormat.format(this.res.registerOsobaKontrahForCompanyInfo, string9, string10);
        if (configBean.getLokalnyAdresSerwera() != null && !"".equals(configBean.getLokalnyAdresSerwera().trim())) {
            string = this.createUrl(configBean.getLokalnyAdresSerwera(), true, osobaKontrah.getId(), this.res.activateAccoundLocal);
            String string12 = this.createUrl(configBean.getLokalnyAdresSerwera(), false, osobaKontrah.getId(), this.res.deactivateAccoundLocal);
            StringBuffer stringBuffer = new StringBuffer(string11);
            stringBuffer.append("<br>");
            stringBuffer.append(MessageFormat.format(this.res.activationForCompanyLocalUrls, string, string12));
            string11 = stringBuffer.toString();
        }
        string = this.getNewOsobaKontrahRegistredBody(osobaKontrah, string7, string11);
        this.sendEmail(osobaKontrah, string4, string6);
        this.sendEmail(configBean.getMailFrom(), string8, string);
    }

    public void sendRemindPassMail(OsobaKontrah osobaKontrah) throws MessageException {
        String string = MessageFormat.format(this.res.notifyRemindPasswordTitle, this.getConfigBean().getMailTitlePrefixForUsers());
        String string2 = this.res.notifyRemindPasswordHeader;
        String string3 = this.getOsobaKontrahPass(osobaKontrah, string2);
        this.sendEmail(osobaKontrah, string, string3);
    }

    public void setCurrentUrl(String string) {
        this.currentUrl = string;
    }

    private String createUrl(String string, boolean bl, Integer n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href='").append(string);
        stringBuffer.append("?").append("strServiceId").append("=").append("activOsKtr");
        stringBuffer.append("&").append("activate").append("=").append(bl ? 1 : 0);
        stringBuffer.append("&").append("uid").append("=").append(SimpleCoder.encode((String)Integer.toString(n)));
        stringBuffer.append("'>" + string2 + "</a>");
        return stringBuffer.toString();
    }

    private String getNewKontrahRegistredBody(KontrahForRegister kontrahForRegister, DaneKontrahForRegister daneKontrahForRegister, String string, String string2, String string3) throws MessageException {
        String string4 = "/resource/html/rejestracja_kontrah.html";
        String string5 = this.getCompanyName();
        String string6 = this.getWwwAdress();
        return this.mailFactory.createNewKontrahBody(kontrahForRegister, daneKontrahForRegister, string, string2, string3, string5, string6, string4);
    }

    private String getNewOsobaKontrahRegistredBody(OsobaKontrah osobaKontrah, String string, String string2) throws MessageException {
        String string3 = "/resource/html/rejestracja_osobakontrah.html";
        String string4 = this.getCompanyName();
        String string5 = this.getWwwAdress();
        return this.mailFactory.createNewOsobaKontrahBody(osobaKontrah, string, string2, string4, string5, string3);
    }

    private String getOsobaKontrahPass(OsobaKontrah osobaKontrah, String string) throws MessageException {
        String string2 = "/resource/html/osobakontrah_pass.html";
        String string3 = this.getCompanyName();
        String string4 = this.getWwwAdress();
        String string5 = MessageFormat.format(this.res.thanks, this.getThanksSignature());
        return this.mailFactory.createOsobaKontrahPassBody(osobaKontrah, string, string5, string3, string4, string2);
    }

    private void init() {
        this.mailFactory = new MailFactory();
        this.mailSender = new MailSender();
        ConfigBean configBean = this.getConfigBean();
        String string = configBean.getMailHost();
        String string2 = configBean.getMailUserName();
        String string3 = configBean.getMailPassword();
        String string4 = configBean.getMailFrom();
        String string5 = configBean.getMailSmtpConnectionTimeout();
        String string6 = configBean.getMailSmtpTimeout();
        Integer n = configBean.getMailSmtpPort();
        this.mailSender.configure(string, n, string2, string3, string4, string5, string6);
    }

    protected String getCompanyName() {
        return this.getConfigBean().getDaneFirmy().getNazwaSkrocona();
    }

    protected ConfigBean getConfigBean() {
        if (this.configBean == null) {
            this.configBean = ConfigFactory.getDefault();
        }
        return this.configBean;
    }

    protected String getCurrentUrlAdress() {
        if (WebContainerServlet.getActiveConnection() != null) {
            HttpServletRequest httpServletRequest = WebContainerServlet.getActiveConnection().getRequest();
            String string = httpServletRequest.getRequestURL().toString();
            return string;
        }
        return null;
    }

    protected String getThanksSignature() {
        String string = this.getConfigBean().getMailThanksSignature();
        if (string == null) {
            string = this.getCompanyName();
        }
        return string;
    }

    protected String getWwwAdress() {
        String string = null;
        DaneFirmy daneFirmy = this.getConfigBean().getDaneFirmy();
        string = daneFirmy.getWww() != null && !"".equals(daneFirmy.getWww()) ? daneFirmy.getWww() : this.getCurrentUrlAdress();
        if (string == null) {
            string = this.currentUrl;
        }
        return string;
    }

    protected void sendEmail(OsobaKontrah osobaKontrah, String string, String string2) throws MessageException {
        if (osobaKontrah.getEmailOsobaKtr() == null) {
            String string3 = osobaKontrah.getNazwisko() + " " + osobaKontrah.getImie();
            String string4 = MessageFormat.format(this.res.personHasNoEmail, string3);
            throw new MessageException(this.res.informationTitle, string4);
        }
        this.sendEmail(osobaKontrah.getEmailOsobaKtr().getEmail(), string, string2);
    }

    protected void sendEmail(final String string, final String string2, final String string3) throws MessageException {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    DefaultMailManager.this.mailSender.sendHtmlMail(string2, string3, string);
                }
                catch (Exception exception) {
                    String string4 = MessageFormat.format(DefaultMailManager.this.res.errorWhileSendingEmail, exception.getMessage());
                    log.error((Object)string4, (Throwable)exception);
                }
            }
        });
        thread.start();
    }

    @ResourceContainer
    private class Res {
        private String activateAccound;
        private String activateAccoundLocal;
        private String activationForCompanyLocalUrls;
        private String activationForUserHeader;
        private String activationForUserInfo;
        private String activationForUserTitle;
        private String deactivateAccound;
        private String deactivateAccoundLocal;
        private String errorWhileSendingEmail;
        private String informationTitle;
        private String notifyChangePasswordHeader;
        private String notifyChangePasswordTitle;
        private String notifyRemindPasswordHeader;
        private String notifyRemindPasswordTitle;
        private String personHasNoEmail;
        private String registerKontrahForCompanyHeader;
        private String registerKontrahForCompanyInfo;
        private String registerKontrahForCompanyTitle;
        private String registerOsobaKontrahForCompanyHeader;
        private String registerOsobaKontrahForCompanyInfo;
        private String registerOsobaKontrahForCompanyTitle;
        private String registerOsobaKontrahForUserHeader;
        private String registerOsobaKontrahForUserInfo;
        private String registerOsobaKontrahForUserTitle;
        private String thanks;

        private Res() {
        }
    }
}

