/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.pcbiznes.echo.lib.beans.ConfigBean;

public class ConfigFactory {
    private static final String CONFIG_BEAN_CLASS = "config_bean_class";
    private static final String CONFIG_BEAN_FILE = "configbean.properties";
    private static ConfigBean configBean;
    private static Logger log;

    public static void dispose() {
        configBean = null;
    }

    public static synchronized ConfigBean getDefault() {
        if (configBean == null) {
            configBean = ConfigFactory.loadConfig();
        }
        return configBean;
    }

    private static File getConfigFile() throws MessageException {
        File file = null;
        try {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource("");
            URL uRL2 = new URL(uRL, CONFIG_BEAN_FILE);
            file = new File(new URI(uRL2.toString()));
            log.debug((Object)("Reading config bean from file: " + file.getAbsolutePath()));
            return file;
        }
        catch (Exception exception) {
            throw new MessageException("Reading config file failed: " + exception.getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigBean loadConfig() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            File file = ConfigFactory.getConfigFile();
            if (file != null && file.exists()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                String string = properties.getProperty(CONFIG_BEAN_CLASS);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                ConfigBean configBean = clazz.asSubclass(ConfigBean.class).newInstance();
                return configBean;
            }
            try {
                throw new IllegalArgumentException("Cannot find config bean file: " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                log.error((Object)instantiationException.getMessage(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
            }
            catch (MessageException messageException) {
                log.error((Object)messageException.getMessage(), (Throwable)messageException);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    static {
        log = Logger.getLogger(ConfigFactory.class);
    }
}

