/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.components.panels.UserDataPane;
import pl.com.stream.pcbiznes.hibernate.database.dao.EmailOsobaKtrDAO;
import pl.com.stream.pcbiznes.hibernate.database.dao.OsobaKontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.EmailOsobaKtr;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

public class UserDataWindow
extends DialogWindow {
    private static final Logger log = Logger.getLogger(UserDataWindow.class);
    private static final long serialVersionUID = -6684267625449469293L;
    private EmailOsobaKtrDAO emailOsobaKtrDAO;
    private final ActionListener internalActionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (DialogWindow.ButtonCommand.ZAPISZ.getActionCommand().equals(actionEvent.getActionCommand())) {
                if (UserDataWindow.this.osobaKontrah == null) {
                    return;
                }
                try {
                    UserDataWindow.this.userInfoWindowPane.checkForCorrectValues();
                    UserDataWindow.this.osobaKontrah.setImie(UserDataWindow.this.userInfoWindowPane.getName());
                    UserDataWindow.this.osobaKontrah.setNazwisko(UserDataWindow.this.userInfoWindowPane.getSurname());
                    EmailOsobaKtr emailOsobaKtr = UserDataWindow.this.osobaKontrah.getEmailOsobaKtr();
                    if (emailOsobaKtr != null) {
                        emailOsobaKtr.setEmail(UserDataWindow.this.userInfoWindowPane.getEmail());
                        UserDataWindow.this.emailOsobaKtrDAO.save((Object)emailOsobaKtr);
                    }
                    UserDataWindow.this.osobaKontrahDAO.save((Object)UserDataWindow.this.osobaKontrah);
                    UserDataWindow.this.close();
                }
                catch (MessageException messageException) {
                    MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
                    messageWindow.open();
                }
                catch (DAOException dAOException) {
                    log.error((Object)dAOException.getMessage(), (Throwable)dAOException);
                    MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
                    messageWindow.open();
                }
                finally {
                    UserDataWindow.this.emailOsobaKtrDAO.closeSession();
                    UserDataWindow.this.osobaKontrahDAO.closeSession();
                }
            }
            if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                UserDataWindow.this.close();
            }
        }
    };
    private OsobaKontrah osobaKontrah;
    private OsobaKontrahDAO osobaKontrahDAO;
    @ResourceContainer
    private Res res;
    private UserDataPane userInfoWindowPane;

    public UserDataWindow() {
        super(DialogWindow.ButtonMask.Zapisz_Anuluj);
        this.initComponents();
        this.initListeners();
        this.initResources();
    }

    public Extent getDefaultHeight() {
        return new Extent(391);
    }

    public Extent getDefaultMaximumHeight() {
        return this.getDefaultHeight();
    }

    public Extent getDefaultMaximumWidth() {
        return this.getDefaultWidth();
    }

    public Extent getDefaultMinimumHeight() {
        return this.getDefaultHeight();
    }

    public Extent getDefaultMinimumWidth() {
        return this.getDefaultWidth();
    }

    public Extent getDefaultWidth() {
        return new Extent(440);
    }

    public void setOsobaKontrah(OsobaKontrah osobaKontrah) {
        this.osobaKontrah = osobaKontrah;
        if (osobaKontrah != null) {
            DaneKontrah daneKontrah;
            this.userInfoWindowPane.setLogin(osobaKontrah.getLogZewLogin());
            this.userInfoWindowPane.setName(osobaKontrah.getImie());
            this.userInfoWindowPane.setSurname(osobaKontrah.getNazwisko());
            this.userInfoWindowPane.setEmail(osobaKontrah.getEmailOsobaKtr() == null ? (String)null : osobaKontrah.getEmailOsobaKtr().getEmail());
            if (osobaKontrah.getOddzialKontrah().getKontrah() != null && (daneKontrah = osobaKontrah.getOddzialKontrah().getKontrah().getAktualneDane()) != null) {
                this.userInfoWindowPane.setCompanyName(daneKontrah.getNazwaDl());
                this.userInfoWindowPane.setNip(daneKontrah.getNip());
                this.userInfoWindowPane.setCity(daneKontrah.getMiejscowosc());
                this.userInfoWindowPane.setStreet(daneKontrah.getUlica());
                this.userInfoWindowPane.setHomeNumber(daneKontrah.getNrDomu());
            }
        }
    }

    private void initComponents() {
        this.setResizable(false);
        this.userInfoWindowPane = new UserDataPane();
        this.add((Component)this.userInfoWindowPane);
    }

    private void initListeners() {
        this.addActionListener(this.internalActionProcessor);
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    protected void initSessionObjects() {
        super.initSessionObjects();
        this.osobaKontrahDAO = new OsobaKontrahDAO();
        this.emailOsobaKtrDAO = new EmailOsobaKtrDAO();
    }

    private class Res {
        private String windowTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }
}

