/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.beans.KontrahBean;
import pl.com.stream.pcbiznes.echo.lib.components.panels.RegisterKontrahPane;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kraj;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterKontrahWindow
extends DialogWindow {
    private static final long serialVersionUID = 5460168025380515857L;
    private final KontrahBean bean;
    private List<Kraj> countryList;
    private RegisterKontrahPane kontrahPane;
    @ResourceContainer
    private Res res;

    public RegisterKontrahWindow() {
        this.initComponents();
        this.initListeners();
        this.initResources();
        this.bean = new KontrahBean();
    }

    public void addRegisterKontrahListener(RegisterKontrahListener registerKontrahListener) {
        this.getEventListenerList().addListener(RegisterKontrahListener.class, (EventListener)registerKontrahListener);
    }

    public Extent getDefaultHeight() {
        return new Extent(475);
    }

    public Extent getDefaultMaximumHeight() {
        return new Extent(475);
    }

    public Extent getDefaultMinimumHeight() {
        return new Extent(475);
    }

    public Extent getDefaultMinimumWidth() {
        return new Extent(480);
    }

    public Extent getDefaultWidth() {
        return new Extent(480);
    }

    public void open(Component component) {
        super.open(component);
        try {
            this.countryList = this.bean.getCountryList();
            this.setCountryList(this.countryList);
        }
        catch (DAOException dAOException) {
            MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
            messageWindow.open();
        }
    }

    public void removeRegisterKontrahListener(RegisterKontrahListener registerKontrahListener) {
        this.getEventListenerList().removeListener(RegisterKontrahListener.class, (EventListener)registerKontrahListener);
    }

    public void setCountryList(List<Kraj> list) {
        this.kontrahPane.setCountryList(list);
    }

    public void setNip(String string) {
        this.kontrahPane.setNip(string);
    }

    private void initComponents() {
        this.kontrahPane = new RegisterKontrahPane();
        this.add((Component)this.kontrahPane);
    }

    private void initListeners() {
        ActionListener actionListener = new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.ZAPISZ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    try {
                        RegisterKontrahWindow.this.kontrahPane.checkForCorrectValues();
                        RegisterKontrahWindow.this.fireRegisterKontrah(RegisterKontrahWindow.this.kontrahPane.getName(), RegisterKontrahWindow.this.kontrahPane.getNip(), RegisterKontrahWindow.this.kontrahPane.getPhone(), RegisterKontrahWindow.this.kontrahPane.getFax(), RegisterKontrahWindow.this.kontrahPane.getCity(), RegisterKontrahWindow.this.kontrahPane.getStreet(), RegisterKontrahWindow.this.kontrahPane.getPostCode(), RegisterKontrahWindow.this.kontrahPane.getPostOffice(), RegisterKontrahWindow.this.kontrahPane.getHomeNo(), RegisterKontrahWindow.this.kontrahPane.getFlatNo(), RegisterKontrahWindow.this.kontrahPane.getCountry());
                    }
                    catch (MessageException messageException) {
                        MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
                        messageWindow.open();
                    }
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand()) || DialogWindow.ButtonCommand.ZAMKNIJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    RegisterKontrahWindow.this.close();
                }
            }
        };
        this.addActionListener(actionListener);
        this.addRegisterKontrahListener(new RegisterKontrahListener(){

            public void registerKontrah(RegisterKontrahEvent registerKontrahEvent) {
                try {
                    RegisterKontrahWindow.this.bean.registerKontrah(registerKontrahEvent.getName(), registerKontrahEvent.getNip(), registerKontrahEvent.getPhone(), registerKontrahEvent.getFax(), registerKontrahEvent.getCity(), registerKontrahEvent.getStreet(), registerKontrahEvent.getPostCode(), registerKontrahEvent.getPostOffice(), registerKontrahEvent.getHomeNo(), registerKontrahEvent.getFlatNo(), registerKontrahEvent.getCountry());
                    RegisterKontrahWindow.this.close();
                    MessageWindow messageWindow = new MessageWindow(RegisterKontrahWindow.this.res.kontrahRegistrationSuccess);
                    messageWindow.open();
                }
                catch (DAOException dAOException) {
                    MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
                    messageWindow.open();
                }
                catch (MessageException messageException) {
                    MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
                    messageWindow.open();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    protected void fireRegisterKontrah(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Kraj kraj) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(RegisterKontrahListener.class);
        RegisterKontrahEvent registerKontrahEvent = new RegisterKontrahEvent((Object)this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, kraj);
        for (EventListener eventListener : eventListenerArray) {
            ((RegisterKontrahListener)eventListener).registerKontrah(registerKontrahEvent);
        }
    }

    private class Res {
        private String kontrahRegistrationSuccess;
        private String windowTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }

    public static interface RegisterKontrahListener
    extends EventListener {
        public void registerKontrah(RegisterKontrahEvent var1);
    }

    public static class RegisterKontrahEvent
    extends EventObject {
        private static final long serialVersionUID = 8325393640252555705L;
        private final String city;
        private final Kraj country;
        private final String fax;
        private final String flatNo;
        private final String homeNo;
        private final String name;
        private final String nip;
        private final String phone;
        private final String postCode;
        private final String postOffice;
        private final String street;

        public RegisterKontrahEvent(Object object, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Kraj kraj) {
            super(object);
            this.name = string;
            this.nip = string2;
            this.phone = string3;
            this.fax = string4;
            this.city = string5;
            this.street = string6;
            this.postCode = string7;
            this.postOffice = string8;
            this.homeNo = string9;
            this.flatNo = string10;
            this.country = kraj;
        }

        public String getCity() {
            return this.city;
        }

        public Kraj getCountry() {
            return this.country;
        }

        public String getFax() {
            return this.fax;
        }

        public String getFlatNo() {
            return this.flatNo;
        }

        public String getHomeNo() {
            return this.homeNo;
        }

        public String getName() {
            return this.name;
        }

        public String getNip() {
            return this.nip;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public String getPostOffice() {
            return this.postOffice;
        }

        public String getStreet() {
            return this.street;
        }
    }
}

