/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.util.List;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.event.MouseEvent;
import pl.com.stream.echo.lib.event.MouseListener;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.TFieldDef;
import pl.com.stream.echo.lib.type.TTableColumnList;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.TTableRowObjectEx;
import pl.com.stream.echo.lib.type.column.TableColumnAdapter;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.pcbiznes.echo.lib.components.panels.OsobaKontrahListPane;
import pl.com.stream.pcbiznes.echo.lib.mail.DefaultMailManager;
import pl.com.stream.pcbiznes.echo.lib.mail.MailManager;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsobaKontrahListWindow
extends DialogWindow {
    private static final long serialVersionUID = 4676768645621678694L;
    private OsobaKontrahListPane osobaKontrahListPane;
    private final MailManager mailManager = new DefaultMailManager();
    @ResourceContainer
    private Res res;

    public OsobaKontrahListWindow() {
        super(DialogWindow.ButtonMask.Przypomnij_haslo_Anuluj, false);
        this.initComponents();
        this.initListeners();
        this.initResources();
        this.initOsobaKontrahListTable();
    }

    public Extent getDefaultHeight() {
        return new Extent(350);
    }

    public Extent getDefaultMinimumHeight() {
        return new Extent(350);
    }

    public Extent getDefaultMinimumWidth() {
        return new Extent(450);
    }

    public Extent getDefaultWidth() {
        return new Extent(450);
    }

    public void setOsobyKontrahList(List<OsobaKontrah> list) {
        TTableObject tTableObject = new TTableObject();
        for (OsobaKontrah osobaKontrah : list) {
            TTableRowObjectEx tTableRowObjectEx = new TTableRowObjectEx(osobaKontrah.getId(), (Object)osobaKontrah);
            tTableRowObjectEx.add((Object)osobaKontrah.getImie());
            tTableRowObjectEx.add((Object)osobaKontrah.getNazwisko());
            tTableRowObjectEx.add((Object)osobaKontrah.getOddzialKontrah().getNazwa());
            tTableObject.add((Object)tTableRowObjectEx);
        }
        this.osobaKontrahListPane.getSortTable().setTableObject(tTableObject);
    }

    private void initComponents() {
        this.osobaKontrahListPane = new OsobaKontrahListPane();
        this.add((Component)this.osobaKontrahListPane);
    }

    private void initListeners() {
        this.osobaKontrahListPane.getSortTable().addSortListener(new SortListener(){

            public void sortPerformed(SortEvent sortEvent) {
            }
        });
        this.osobaKontrahListPane.getSortTable().addMouseListener(new MouseListener(){
            private static final long serialVersionUID = 1L;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getEventType().equals((Object)MouseEvent.MouseEventType.doubleClick)) {
                    OsobaKontrahListWindow.this.remindPass();
                }
            }
        });
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.PRZYPOMNIJ_HASLO.getActionCommand().equals(actionEvent.getActionCommand())) {
                    OsobaKontrahListWindow.this.remindPass();
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    OsobaKontrahListWindow.this.close();
                }
            }
        });
    }

    private void initOsobaKontrahListTable() {
        TTableColumnList tTableColumnList = new TTableColumnList();
        tTableColumnList.add(new TableColumnAdapter(){

            public String getLabel() {
                return OsobaKontrahListWindow.this.res.nameColumn;
            }

            public Integer getNumber() {
                return 0;
            }

            public TFieldDef.RodzajWysw getRodzajWysw() {
                return TFieldDef.RodzajWysw.rwInne;
            }

            public Integer getSize() {
                return 35;
            }

            public Integer getSizeUnit() {
                return 2;
            }
        });
        tTableColumnList.add(new TableColumnAdapter(){

            public String getLabel() {
                return OsobaKontrahListWindow.this.res.surnameColumn;
            }

            public Integer getNumber() {
                return 1;
            }

            public TFieldDef.RodzajWysw getRodzajWysw() {
                return TFieldDef.RodzajWysw.rwInne;
            }

            public Integer getSize() {
                return 45;
            }

            public Integer getSizeUnit() {
                return 2;
            }
        });
        tTableColumnList.add(new TableColumnAdapter(){

            public String getLabel() {
                return OsobaKontrahListWindow.this.res.departmentColumn;
            }

            public Integer getNumber() {
                return 2;
            }

            public TFieldDef.RodzajWysw getRodzajWysw() {
                return TFieldDef.RodzajWysw.rwInne;
            }

            public Integer getSize() {
                return 20;
            }

            public Integer getSizeUnit() {
                return 2;
            }
        });
        this.osobaKontrahListPane.getSortTable().setColumnModelFromTVisibleColumns((List)tTableColumnList);
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    private void remindPass() {
        try {
            OsobaKontrah osobaKontrah = this.osobaKontrahListPane.getSelectedOsobaKontrah();
            if (osobaKontrah == null) {
                return;
            }
            this.mailManager.sendRemindPassMail(osobaKontrah);
            MessageWindow messageWindow = new MessageWindow(this.res.remindPassMessage);
            messageWindow.open();
            this.close();
        }
        catch (MessageException messageException) {
            MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
            messageWindow.open();
        }
    }

    private class Res {
        private String windowTitle;
        private String nameColumn;
        private String surnameColumn;
        private String departmentColumn;
        private String remindPassMessage;
        public ImageReference windowIcon;

        private Res() {
        }
    }
}

