/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.util.List;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.components.panels.NipPane;
import pl.com.stream.pcbiznes.echo.lib.components.windows.CompanyWindow;
import pl.com.stream.pcbiznes.hibernate.database.dao.KontrahDAO;

public class NipWindow
extends DialogWindow {
    private static final long serialVersionUID = 2398800158606610452L;
    private static Logger log = Logger.getLogger(NipWindow.class);
    private NipPane nipPane;
    private final KontrahDAO kontrahDAO;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            NipWindow.this.showCompanyWindow();
        }
    };
    @ResourceContainer
    private Res res;

    public NipWindow() {
        super(DialogWindow.ButtonMask.OK_Anuluj, false);
        this.kontrahDAO = new KontrahDAO();
        this.initComponents();
        this.initListeners();
        this.initResources();
    }

    public Extent getDefaultHeight() {
        return new Extent(120);
    }

    public Extent getDefaultWidth() {
        return new Extent(265);
    }

    private void initComponents() {
        this.setResizable(false);
        this.nipPane = new NipPane();
        this.add((Component)this.nipPane);
    }

    private void initListeners() {
        this.nipPane.getNipTextField().addActionListener(this.actionProcessor);
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
                    NipWindow.this.showCompanyWindow();
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    NipWindow.this.close();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCompanyWindow() {
        try {
            String string = this.nipPane.getNipTextField().getText();
            List list = this.kontrahDAO.getList(string);
            if (list != null && list.iterator().hasNext()) {
                CompanyWindow companyWindow = new CompanyWindow();
                companyWindow.setCompanys(list);
                companyWindow.open();
                this.close();
            } else {
                String string2 = this.res.informationTitle;
                String string3 = this.res.wrongNipMessage;
                MessageWindow messageWindow = new MessageWindow(string2, string3);
                messageWindow.open();
            }
        }
        catch (DAOException dAOException) {
            log.error((Object)dAOException.getMessage(), (Throwable)dAOException);
            MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
            messageWindow.open();
        }
        finally {
            this.kontrahDAO.closeSession();
        }
    }

    private class Res {
        private String informationTitle;
        private String wrongNipMessage;
        private String windowTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }
}

