/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.util.EventListener;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.event.LoginEvent;
import pl.com.stream.echo.lib.event.LoginListener;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.pcbiznes.echo.lib.beans.ConfigBean;
import pl.com.stream.pcbiznes.echo.lib.components.panels.LoginPane;
import pl.com.stream.pcbiznes.echo.lib.config.ConfigFactory;

public class LoginWindow
extends DialogWindow {
    private static final long serialVersionUID = 4860338494337411688L;
    private LoginPane loginPane;
    private final ConfigBean configBean = ConfigFactory.getDefault();
    @ResourceContainer
    private Res res;

    public LoginWindow() {
        this(true);
    }

    public LoginWindow(boolean bl) {
        super(DialogWindow.ButtonMask.Zaloguj, bl);
        this.initComponents();
        this.initListeners();
        this.initResources();
        this.setRegisterButtonVisible(this.configBean.isRegisterNewOsobaKontrah());
    }

    public void addLoginListener(LoginListener loginListener) {
        this.getEventListenerList().addListener(LoginListener.class, (EventListener)loginListener);
    }

    public Extent getDefaultHeight() {
        return new Extent(220);
    }

    public Extent getDefaultWidth() {
        return new Extent(330);
    }

    public void removeLoginListener(LoginListener loginListener) {
        this.getEventListenerList().removeListener(LoginListener.class, (EventListener)loginListener);
    }

    public void setForgotButtonVisible(boolean bl) {
        this.loginPane.setForgotButtonVisible(bl);
    }

    public void setLogin(String string) {
        this.loginPane.setLogin(string == null ? (String)null : string);
    }

    public void setPassword(String string) {
        this.loginPane.setPassword(string == null ? (String)null : string);
    }

    public void setRegisterButtonVisible(boolean bl) {
        this.loginPane.setRegisterButtonVisible(bl);
    }

    public void setSavePassword(boolean bl) {
        this.loginPane.setSavePassword(bl);
    }

    public void setSavePasswordButtonVisible(boolean bl) {
        this.loginPane.setSavePasswordButtonVisible(bl);
    }

    private void fireLoginPerformed(String string, String string2, boolean bl) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(LoginListener.class);
        LoginEvent loginEvent = new LoginEvent((Object)this, string, string2, bl);
        for (EventListener eventListener : eventListenerArray) {
            ((LoginListener)eventListener).loginPerformed(loginEvent);
        }
    }

    private void initComponents() {
        this.setResizable(false);
        this.loginPane = new LoginPane();
        this.add((Component)this.loginPane);
    }

    private void initListeners() {
        this.loginPane.addLoginListener(new LoginListener(){
            private static final long serialVersionUID = 1L;

            public void loginPerformed(LoginEvent loginEvent) {
                LoginWindow.this.processLogin();
            }
        });
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.ZALOGUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    LoginWindow.this.processLogin();
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    LoginWindow.this.close();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    private void processLogin() {
        this.fireLoginPerformed(this.loginPane.getLogin(), this.loginPane.getPassword(), this.loginPane.isSavePasswd());
    }

    private class Res {
        private String windowTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }
}

