/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Order;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.event.MouseEvent;
import pl.com.stream.echo.lib.event.MouseListener;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.TFieldDef;
import pl.com.stream.echo.lib.type.TTableColumnList;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.TTableRowObjectEx;
import pl.com.stream.echo.lib.type.column.TableColumnAdapter;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.components.panels.CompanyPane;
import pl.com.stream.pcbiznes.echo.lib.components.windows.OsobaKontrahListWindow;
import pl.com.stream.pcbiznes.hibernate.database.dao.OsobaKontrahDAO;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyWindow
extends DialogWindow {
    private static final Logger log = Logger.getLogger(CompanyWindow.class);
    private static final long serialVersionUID = 5424020506291802883L;
    private CompanyPane companyPane;
    private final OsobaKontrahDAO osobaKontrahDAO = new OsobaKontrahDAO();
    @ResourceContainer
    private Res res;

    public CompanyWindow() {
        super(DialogWindow.ButtonMask.OK_Anuluj, false);
        this.initComponents();
        this.initListeners();
        this.initCompanysTable();
        this.initResources();
    }

    public Extent getDefaultHeight() {
        return new Extent(350);
    }

    public Extent getDefaultMinimumHeight() {
        return new Extent(350);
    }

    public Extent getDefaultMinimumWidth() {
        return new Extent(450);
    }

    public Extent getDefaultWidth() {
        return new Extent(450);
    }

    public void setCompanys(List<Kontrah> list) {
        TTableObject tTableObject = new TTableObject();
        for (Kontrah kontrah : list) {
            DaneKontrah daneKontrah = kontrah.getAktualneDane();
            if (daneKontrah == null) continue;
            TTableRowObjectEx tTableRowObjectEx = new TTableRowObjectEx(daneKontrah.getId(), (Object)daneKontrah);
            tTableRowObjectEx.add((Object)daneKontrah.getNazwaDl().replace('>', ']').replace('<', '['));
            tTableRowObjectEx.add((Object)daneKontrah.getAdres());
            tTableObject.add((Object)tTableRowObjectEx);
        }
        this.companyPane.getSortTable().setTableObject(tTableObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chooseCompany() {
        block10: {
            try {
                DaneKontrah daneKontrah = this.companyPane.getSelectedDaneKontrah();
                if (daneKontrah == null) {
                    return;
                }
                ArrayList<Order> arrayList = new ArrayList<Order>();
                arrayList.add(Order.asc((String)"nazwisko"));
                arrayList.add(Order.asc((String)"imie"));
                List list = this.osobaKontrahDAO.getList(daneKontrah.getKontrah(), arrayList);
                if (list != null && list.iterator().hasNext()) {
                    OsobaKontrahListWindow osobaKontrahListWindow = new OsobaKontrahListWindow();
                    osobaKontrahListWindow.setOsobyKontrahList(list);
                    osobaKontrahListWindow.open();
                    this.close();
                    break block10;
                }
                String string = MessageFormat.format(this.res.noRightsMessage, daneKontrah.getKontrah().getNazwa());
                throw new MessageException(this.res.informationTitle, string);
            }
            catch (DAOException dAOException) {
                log.error((Object)dAOException.getMessage(), (Throwable)dAOException);
                MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
                messageWindow.open();
            }
            catch (MessageException messageException) {
                MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
                messageWindow.open();
            }
            finally {
                this.osobaKontrahDAO.closeSession();
            }
        }
    }

    private void initCompanysTable() {
        TTableColumnList tTableColumnList = new TTableColumnList();
        tTableColumnList.add(new TableColumnAdapter(){

            public String getLabel() {
                return CompanyWindow.this.res.companyNameColumn;
            }

            public Integer getNumber() {
                return 0;
            }

            public TFieldDef.RodzajWysw getRodzajWysw() {
                return TFieldDef.RodzajWysw.rwInne;
            }

            public Integer getSize() {
                return 50;
            }

            public Integer getSizeUnit() {
                return 2;
            }
        });
        tTableColumnList.add(new TableColumnAdapter(){

            public String getLabel() {
                return CompanyWindow.this.res.adressColumn;
            }

            public Integer getNumber() {
                return 0;
            }

            public TFieldDef.RodzajWysw getRodzajWysw() {
                return TFieldDef.RodzajWysw.rwInne;
            }

            public Integer getSize() {
                return 50;
            }

            public Integer getSizeUnit() {
                return 2;
            }
        });
        this.companyPane.getSortTable().setColumnModelFromTVisibleColumns((List)tTableColumnList);
    }

    private void initComponents() {
        this.companyPane = new CompanyPane();
        this.add((Component)this.companyPane);
    }

    private void initListeners() {
        this.companyPane.getSortTable().addSortListener(new SortListener(){

            public void sortPerformed(SortEvent sortEvent) {
            }
        });
        this.companyPane.getSortTable().addMouseListener(new MouseListener(){
            private static final long serialVersionUID = 1L;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getEventType().equals((Object)MouseEvent.MouseEventType.doubleClick)) {
                    CompanyWindow.this.chooseCompany();
                }
            }
        });
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
                    CompanyWindow.this.chooseCompany();
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    CompanyWindow.this.close();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    private class Res {
        private String adressColumn;
        private String companyNameColumn;
        private String informationTitle;
        private String noRightsMessage;
        private String windowTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }
}

