/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.windows;

import java.text.MessageFormat;
import java.util.EventListener;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.event.ChangePasswordEvent;
import pl.com.stream.echo.lib.event.ChangePasswordListener;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.lib.code.SimpleCoder;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.components.panels.ChangePasswordPane;
import pl.com.stream.pcbiznes.echo.lib.mail.DefaultMailManager;
import pl.com.stream.pcbiznes.echo.lib.mail.MailManager;
import pl.com.stream.pcbiznes.echo.lib.users.UsersManager;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

public class ChangePasswordWindow
extends DialogWindow {
    private static final long serialVersionUID = 4110665652007880781L;
    private static Logger log = Logger.getLogger(ChangePasswordWindow.class);
    private ChangePasswordPane changePassPane;
    private OsobaKontrah osobaKontrah;
    private final MailManager mailManager;
    private final UsersManager usersManager;
    @ResourceContainer
    private Res res;

    public ChangePasswordWindow() {
        super(DialogWindow.ButtonMask.Zapisz_Anuluj);
        this.initComponents();
        this.initListeners();
        this.initResources();
        this.mailManager = new DefaultMailManager();
        this.usersManager = new UsersManager();
    }

    public void addChangePasswordListener(ChangePasswordListener changePasswordListener) {
        this.getEventListenerList().addListener(ChangePasswordListener.class, (EventListener)changePasswordListener);
    }

    public Extent getDefaultHeight() {
        return new Extent(180);
    }

    public Extent getDefaultMinimumHeight() {
        return this.getDefaultHeight();
    }

    public Extent getDefaultMinimumWidth() {
        return this.getDefaultWidth();
    }

    public Extent getDefaultWidth() {
        return new Extent(328);
    }

    public void removeChangePasswordListener(ChangePasswordListener changePasswordListener) {
        this.getEventListenerList().removeListener(ChangePasswordListener.class, (EventListener)changePasswordListener);
    }

    public void setOsobaKontrah(OsobaKontrah osobaKontrah) {
        this.osobaKontrah = osobaKontrah;
        this.setCurrentOrginalPassword(osobaKontrah.getLogZewHaslo() != null ? SimpleCoder.decode((String)osobaKontrah.getLogZewHaslo()) : "");
    }

    private void fireChangePasswordPerformed(String string, String string2, String string3) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ChangePasswordListener.class);
        ChangePasswordEvent changePasswordEvent = new ChangePasswordEvent((Object)this, string, string2, string3);
        for (EventListener eventListener : eventListenerArray) {
            ((ChangePasswordListener)eventListener).changePasswordPerformed(changePasswordEvent);
        }
    }

    private void initComponents() {
        this.setResizable(false);
        this.changePassPane = new ChangePasswordPane();
        this.add((Component)this.changePassPane);
    }

    private void initListeners() {
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.ZAPISZ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    ChangePasswordWindow.this.processSavingPassword();
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    ChangePasswordWindow.this.close();
                }
            }
        });
        this.addChangePasswordListener(new ChangePasswordListener(){
            private static final long serialVersionUID = 1L;

            public void changePasswordPerformed(final ChangePasswordEvent changePasswordEvent) {
                if (ChangePasswordWindow.this.osobaKontrah == null) {
                    return;
                }
                if (ChangePasswordWindow.this.osobaKontrah.getEmailOsobaKtr() != null) {
                    final MessageWindow messageWindow = new MessageWindow(ChangePasswordWindow.this.res.questionTitle, ChangePasswordWindow.this.res.sendEmailWithNewPassword, DialogWindow.ButtonMask.Tak_Nie);
                    messageWindow.open();
                    messageWindow.addActionListener(new ActionListener(){
                        private static final long serialVersionUID = 1L;

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                ChangePasswordWindow.this.usersManager.changePassword(ChangePasswordWindow.this.osobaKontrah, changePasswordEvent.getNewPassword());
                                if (DialogWindow.ButtonCommand.Tak.getActionCommand().equals(actionEvent.getActionCommand())) {
                                    messageWindow.close();
                                    ChangePasswordWindow.this.mailManager.sendChangePassMail(ChangePasswordWindow.this.osobaKontrah);
                                    String string = MessageFormat.format(ChangePasswordWindow.this.res.passwordChangedEmailHasBeenSent, ChangePasswordWindow.this.osobaKontrah.getEmailOsobaKtr().getEmail());
                                    MessageWindow messageWindow2 = new MessageWindow(string);
                                    messageWindow2.open();
                                } else if (DialogWindow.ButtonCommand.Nie.getActionCommand().equals(actionEvent.getActionCommand())) {
                                    messageWindow.close();
                                    MessageWindow messageWindow3 = new MessageWindow(ChangePasswordWindow.this.res.passwordChanged);
                                    messageWindow3.open();
                                }
                                ChangePasswordWindow.this.close();
                            }
                            catch (Exception exception) {
                                MessageException messageException = new MessageException((Throwable)exception);
                                log.error((Object)messageException.getMessage(), (Throwable)messageException);
                                MessageWindow messageWindow4 = new MessageWindow(messageException.getTitle(), messageException.getMessage());
                                messageWindow4.open();
                            }
                        }
                    });
                } else {
                    try {
                        ChangePasswordWindow.this.usersManager.changePassword(ChangePasswordWindow.this.osobaKontrah, changePasswordEvent.getNewPassword());
                    }
                    catch (DAOException dAOException) {
                        MessageWindow messageWindow = new MessageWindow(dAOException.getTitle(), dAOException.getMessage());
                        messageWindow.open();
                    }
                    ChangePasswordWindow.this.close();
                    MessageWindow messageWindow = new MessageWindow(ChangePasswordWindow.this.res.passwordChanged);
                    messageWindow.open();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.windowTitle);
        this.setIcon(this.res.windowIcon);
    }

    private void processSavingPassword() {
        try {
            this.changePassPane.checkForCorrectValues();
            this.fireChangePasswordPerformed(this.changePassPane.getCurrentPassword(), this.changePassPane.getNewPassword(), this.changePassPane.getConfirmedPassword());
        }
        catch (MessageException messageException) {
            MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
            messageWindow.open();
        }
    }

    private void setCurrentOrginalPassword(String string) {
        this.changePassPane.setCurrentOrginalPassword(string);
    }

    private class Res {
        private String sendEmailWithNewPassword;
        private String passwordChanged;
        private String passwordChangedEmailHasBeenSent;
        private String windowTitle;
        private String questionTitle;
        private ImageReference windowIcon;

        private Res() {
        }
    }
}

