/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.panels;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Label;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.GridLayoutData;
import nextapp.echo.app.layout.SplitPaneLayoutData;
import pl.com.stream.echo.lib.component.Panel;
import pl.com.stream.echo.lib.component.StrButton;
import pl.com.stream.echo.lib.component.StrCheckBox;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.StrPasswordField;
import pl.com.stream.echo.lib.component.StrTextField;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.event.LoginEvent;
import pl.com.stream.echo.lib.event.LoginListener;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.pcbiznes.echo.lib.components.windows.NipWindow;
import pl.com.stream.pcbiznes.echo.lib.components.windows.RegisterOsobaKontrahWindow;

public class LoginPane
extends Panel {
    private static final long serialVersionUID = 8293477537546074793L;
    @ResourceContainer
    private Res res;
    private StrLabelMedium loginLabel;
    private StrTextField loginTextField;
    private StrLabelMedium passwordLabel;
    private StrPasswordField passwordField;
    private StrCheckBox savePasswordCheckBox;
    private StrButton forgotPasswdButton;
    private StrButton registerButton;
    private Label userIcon;
    private Label keysIcon;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            DialogWindow dialogWindow;
            if (actionEvent.getSource().equals(LoginPane.this.passwordField) || actionEvent.getSource().equals(LoginPane.this.loginTextField)) {
                LoginPane.this.processLogin();
            }
            if ("forgotPassword".equals(actionEvent.getActionCommand())) {
                dialogWindow = new NipWindow();
                dialogWindow.open();
            }
            if ("register".equals(actionEvent.getActionCommand())) {
                dialogWindow = new RegisterOsobaKontrahWindow();
                dialogWindow.open();
            }
        }
    };

    public LoginPane() {
        this.initComponents();
        this.initResources();
        this.initListeners();
        this.forceFocusOnFirstComponent();
    }

    public void addLoginListener(LoginListener loginListener) {
        this.getEventListenerList().addListener(LoginListener.class, (EventListener)loginListener);
    }

    public String getLogin() {
        return this.loginTextField.getText();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    public boolean isSavePasswd() {
        return this.savePasswordCheckBox.isSelected();
    }

    public void removeLoginListener(LoginListener loginListener) {
        this.getEventListenerList().removeListener(LoginListener.class, (EventListener)loginListener);
    }

    public void setForgotButtonVisible(boolean bl) {
        this.forgotPasswdButton.setVisible(bl);
    }

    public void setLogin(String string) {
        this.loginTextField.setText(string == null ? (String)null : string);
    }

    public void setPassword(String string) {
        this.passwordField.setText(string == null ? (String)null : string);
    }

    public void setRegisterButtonVisible(boolean bl) {
        this.registerButton.setVisible(bl);
    }

    public void setSavePassword(boolean bl) {
        this.savePasswordCheckBox.setSelected(bl);
    }

    public void setSavePasswordButtonVisible(boolean bl) {
        this.savePasswordCheckBox.setVisible(bl);
    }

    private void fireLoginPerformed(String string, String string2, boolean bl) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(LoginListener.class);
        LoginEvent loginEvent = new LoginEvent((Object)this, string, string2, bl);
        for (EventListener eventListener : eventListenerArray) {
            ((LoginListener)eventListener).loginPerformed(loginEvent);
        }
    }

    private void initComponents() {
        Column column = new Column();
        this.add((Component)column);
        Grid grid = new Grid();
        grid.setInsets(new Insets(new Extent(2, 1)));
        grid.setSize(3);
        SplitPaneLayoutData splitPaneLayoutData = new SplitPaneLayoutData();
        splitPaneLayoutData.setInsets(new Insets(new Extent(10, 1)));
        grid.setLayoutData((LayoutData)splitPaneLayoutData);
        column.add((Component)grid);
        Column column2 = new Column();
        column2.setCellSpacing(new Extent(30, 1));
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(0, 6));
        gridLayoutData.setInsets(new Insets(new Extent(10, 1), new Extent(2, 1), new Extent(15, 1), new Extent(0, 1)));
        gridLayoutData.setRowSpan(5);
        column2.setLayoutData((LayoutData)gridLayoutData);
        grid.add((Component)column2);
        this.userIcon = new Label();
        this.userIcon.setVisible(false);
        column2.add((Component)this.userIcon);
        this.keysIcon = new Label();
        column2.add((Component)this.keysIcon);
        this.loginLabel = new StrLabelMedium();
        this.loginLabel.setText("login");
        GridLayoutData gridLayoutData2 = new GridLayoutData();
        gridLayoutData2.setAlignment(new Alignment(5, 0));
        this.loginLabel.setLayoutData((LayoutData)gridLayoutData2);
        grid.add((Component)this.loginLabel);
        this.loginTextField = new StrTextField();
        this.loginTextField.setWidth(new Extent(155, 1));
        grid.add((Component)this.loginTextField);
        this.passwordLabel = new StrLabelMedium();
        this.passwordLabel.setText("password");
        GridLayoutData gridLayoutData3 = new GridLayoutData();
        gridLayoutData3.setAlignment(new Alignment(5, 0));
        this.passwordLabel.setLayoutData((LayoutData)gridLayoutData3);
        grid.add((Component)this.passwordLabel);
        this.passwordField = new StrPasswordField();
        this.passwordField.setWidth(new Extent(155, 1));
        grid.add((Component)this.passwordField);
        this.savePasswordCheckBox = new StrCheckBox();
        this.savePasswordCheckBox.setText("savePassword");
        GridLayoutData gridLayoutData4 = new GridLayoutData();
        gridLayoutData4.setAlignment(new Alignment(5, 0));
        gridLayoutData4.setColumnSpan(2);
        this.savePasswordCheckBox.setLayoutData((LayoutData)gridLayoutData4);
        grid.add((Component)this.savePasswordCheckBox);
        this.forgotPasswdButton = new StrButton();
        this.forgotPasswdButton.setStyleName("LinkButtonStyle");
        this.forgotPasswdButton.setText("forgotPassword");
        this.forgotPasswdButton.setActionCommand("forgotPassword");
        GridLayoutData gridLayoutData5 = new GridLayoutData();
        gridLayoutData5.setAlignment(new Alignment(5, 0));
        gridLayoutData5.setColumnSpan(2);
        this.forgotPasswdButton.setLayoutData((LayoutData)gridLayoutData5);
        grid.add((Component)this.forgotPasswdButton);
        this.registerButton = new StrButton();
        this.registerButton.setStyleName("LinkButtonStyle");
        this.registerButton.setText("register");
        this.registerButton.setActionCommand("register");
        GridLayoutData gridLayoutData6 = new GridLayoutData();
        gridLayoutData6.setAlignment(new Alignment(5, 0));
        gridLayoutData6.setColumnSpan(2);
        this.registerButton.setLayoutData((LayoutData)gridLayoutData6);
        grid.add((Component)this.registerButton);
    }

    private void initListeners() {
        this.loginTextField.addActionListener(this.actionProcessor);
        this.passwordField.addActionListener(this.actionProcessor);
        this.forgotPasswdButton.addActionListener(this.actionProcessor);
        this.registerButton.addActionListener(this.actionProcessor);
    }

    private void initResources() {
        this.loginLabel.setText(this.res.loginLabelText);
        this.userIcon.setIcon(this.res.loginLabelIcon);
        this.passwordLabel.setText(this.res.passwordLabelText);
        this.keysIcon.setIcon(this.res.passwordLabelIcon);
        this.savePasswordCheckBox.setText(this.res.savePasswordCheckBoxText);
        this.forgotPasswdButton.setText(this.res.forgotPasswordButtonText);
        this.registerButton.setText(this.res.registerPasswordButtonText);
    }

    private void processLogin() {
        this.fireLoginPerformed(this.getLogin(), this.getPassword(), this.isSavePasswd());
    }

    private class Res {
        private String forgotPasswordButtonText;
        private String loginLabelText;
        private String passwordLabelText;
        private String registerPasswordButtonText;
        private String savePasswordCheckBoxText;
        private ImageReference loginLabelIcon;
        private ImageReference passwordLabelIcon;

        private Res() {
        }
    }
}

