/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.components.panels;

import java.text.MessageFormat;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.layout.GridLayoutData;
import pl.com.stream.echo.lib.component.Panel;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.StrPasswordField;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class ChangePasswordPane
extends Panel {
    private static final long serialVersionUID = -5761339576805237836L;
    private String currentOrginalPassword;
    @ResourceContainer
    private Res res;
    private StrLabelMedium currentPasswordLabel;
    private StrPasswordField currentPasswordField;
    private StrLabelMedium newPasswordLabel;
    private StrPasswordField newPasswordField;
    private StrLabelMedium confirmedPasswordLabel;
    private StrPasswordField confirmedNewPasswordField;

    public ChangePasswordPane() {
        this.initComponents();
        this.initResources();
        this.forceFocusOnFirstComponent();
    }

    public void checkForCorrectValues() throws MessageException {
        String string = this.res.informationTitle;
        if ("".equals(this.getCurrentPassword())) {
            String string2 = MessageFormat.format(this.res.fieldNeedValueMessage, this.currentPasswordLabel.getText());
            throw new MessageException(string, string2);
        }
        if (this.currentOrginalPassword != null && !this.currentOrginalPassword.toUpperCase().equals(this.getCurrentPassword().toUpperCase())) {
            String string3 = MessageFormat.format(this.res.fieldHasWrongValueMessage, this.currentPasswordLabel.getText());
            throw new MessageException(string, string3);
        }
        if ("".equals(this.getNewPassword())) {
            String string4 = MessageFormat.format(this.res.fieldNeedValueMessage, this.newPasswordLabel.getText());
            throw new MessageException(string, string4);
        }
        if ("".equals(this.getConfirmedPassword())) {
            String string5 = MessageFormat.format(this.res.fieldNeedValueMessage, this.confirmedPasswordLabel.getText());
            throw new MessageException(string, string5);
        }
        if (!this.getNewPassword().toUpperCase().equals(this.getConfirmedPassword().toUpperCase())) {
            throw new MessageException(string, this.res.bothPasswordsAreDifferent);
        }
    }

    public String getConfirmedPassword() {
        return this.confirmedNewPasswordField.getText();
    }

    public String getCurrentPassword() {
        return this.currentPasswordField.getText();
    }

    public String getNewPassword() {
        return this.newPasswordField.getText();
    }

    public void setCurrentOrginalPassword(String string) {
        this.currentOrginalPassword = string;
    }

    private void initComponents() {
        Column column = new Column();
        column.setInsets(new Insets(new Extent(8, 1), new Extent(8, 1), new Extent(3, 1), new Extent(3, 1)));
        this.add((Component)column);
        Grid grid = new Grid();
        grid.setInsets(new Insets(new Extent(2, 1)));
        column.add((Component)grid);
        this.currentPasswordLabel = new StrLabelMedium();
        this.currentPasswordLabel.setText("currentPass");
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(5, 0));
        this.currentPasswordLabel.setLayoutData((LayoutData)gridLayoutData);
        grid.add((Component)this.currentPasswordLabel);
        this.currentPasswordField = new StrPasswordField();
        this.currentPasswordField.setMaximumLength(80);
        grid.add((Component)this.currentPasswordField);
        this.newPasswordLabel = new StrLabelMedium();
        this.newPasswordLabel.setText("newPass");
        GridLayoutData gridLayoutData2 = new GridLayoutData();
        gridLayoutData2.setAlignment(new Alignment(5, 0));
        this.newPasswordLabel.setLayoutData((LayoutData)gridLayoutData2);
        grid.add((Component)this.newPasswordLabel);
        this.newPasswordField = new StrPasswordField();
        this.newPasswordField.setMaximumLength(20);
        grid.add((Component)this.newPasswordField);
        this.confirmedPasswordLabel = new StrLabelMedium();
        this.confirmedPasswordLabel.setText("confirmPass");
        GridLayoutData gridLayoutData3 = new GridLayoutData();
        gridLayoutData3.setAlignment(new Alignment(5, 0));
        this.confirmedPasswordLabel.setLayoutData((LayoutData)gridLayoutData3);
        grid.add((Component)this.confirmedPasswordLabel);
        this.confirmedNewPasswordField = new StrPasswordField();
        this.confirmedNewPasswordField.setMaximumLength(20);
        grid.add((Component)this.confirmedNewPasswordField);
    }

    private void initResources() {
        this.currentPasswordLabel.setText(this.res.currentPasswordLabelText);
        this.newPasswordLabel.setText(this.res.newPasswordLabelText);
        this.confirmedPasswordLabel.setText(this.res.confirmedPasswordLabelText);
    }

    private class Res {
        private String bothPasswordsAreDifferent;
        private String fieldHasWrongValueMessage;
        private String fieldNeedValueMessage;
        private String informationTitle;
        private String confirmedPasswordLabelText;
        private String currentPasswordLabelText;
        private String newPasswordLabelText;

        private Res() {
        }
    }
}

