/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.echo.lib.beans;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.exception.GenericJDBCException;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.echo.lib.beans.ConfigBean;
import pl.com.stream.pcbiznes.echo.lib.config.ConfigFactory;
import pl.com.stream.pcbiznes.echo.lib.mail.DefaultMailManager;
import pl.com.stream.pcbiznes.echo.lib.mail.MailManager;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.GrupaKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.KontrahForRegister;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kraj;
import pl.com.stream.pcbiznes.hibernate.database.mappings.WystGrKtrForRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KontrahBean
extends HibernateSessionProvider {
    private static final Logger log = Logger.getLogger(KontrahBean.class);
    private static final long serialVersionUID = 6455509831472146123L;
    private final ConfigBean configBean = ConfigFactory.getDefault();
    private final MailManager mailManager;
    @ResourceContainer
    private Res res;

    public KontrahBean() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.mailManager = new DefaultMailManager();
    }

    public List<Kraj> getCountryList() throws DAOException {
        try {
            log.debug((Object)this.res.gettingCountryList);
            this.beginTransaction();
            List list = this.getSession().createCriteria(Kraj.class).list();
            this.commitTransaction();
            List list2 = list;
            return list2;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(this.res.cannotGetCountryList, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
        finally {
            this.closeSession();
        }
    }

    public void registerKontrah(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Kraj kraj) throws DAOException, MessageException {
        boolean bl = false;
        int n = 1;
        String string11 = string2.replaceAll("-", "");
        KontrahForRegister kontrahForRegister = null;
        DaneKontrahForRegister daneKontrahForRegister = null;
        block11: while (n <= 10) {
            Object object;
            Object object2;
            log.debug((Object)MessageFormat.format(this.res.attemptToRegisterKontrah, Integer.toString(n)));
            try {
                List list;
                this.beginTransaction();
                List list2 = this.getSession().createCriteria(DaneKontrahForRegister.class).add((Criterion)Property.forName((String)"nipW").eq((Object)string11)).setProjection((Projection)Projections.property((String)"nipW")).list();
                if (list2.size() > 0) {
                    throw new MessageException(this.res.informationTitle, this.res.kontrahWithNipExists);
                }
                object2 = (Integer)this.getSession().createCriteria(KontrahForRegister.class).setProjection((Projection)Projections.max((String)"nrKontrah")).uniqueResult() + 1;
                kontrahForRegister = new KontrahForRegister(string2, (Integer)object2, string3, string4, 0, 1, 0, 0, 1, 0, 1);
                this.getSession().saveOrUpdate((Object)kontrahForRegister);
                kontrahForRegister.setNieHandlowyW(kontrahForRegister.getId());
                this.getSession().saveOrUpdate((Object)kontrahForRegister);
                daneKontrahForRegister = new DaneKontrahForRegister(kontrahForRegister.getId(), kraj.getId(), 2, string, string11, string2, string5, string7, string8, string6, string9, string10, new Date(), "nowy", 1, 1);
                this.getSession().saveOrUpdate((Object)daneKontrahForRegister);
                object = this.configBean.getKodZlozonyGrupaKtr();
                if (object != null && !"".equals(((String)object).trim()) && (list = this.getSession().createCriteria(GrupaKontrah.class).add((Criterion)Property.forName((String)"kodZlozony").eq(object)).list()).size() > 0) {
                    GrupaKontrah grupaKontrah = (GrupaKontrah)list.get(0);
                    Integer n2 = grupaKontrah.getId();
                    Integer n3 = grupaKontrah.getIdRodzGrupKtr();
                    WystGrKtrForRegister wystGrKtrForRegister = new WystGrKtrForRegister(n2, kontrahForRegister.getId(), n3);
                    this.getSession().saveOrUpdate((Object)wystGrKtrForRegister);
                }
                this.commitTransaction();
                bl = true;
                break;
            }
            catch (HibernateException hibernateException) {
                object2 = MessageFormat.format(this.res.errorWhileRegisterKontrah, hibernateException.getMessage());
                log.error(object2, (Throwable)hibernateException);
                this.rollbackTransaction();
                if (hibernateException instanceof GenericJDBCException) {
                    object = (GenericJDBCException)hibernateException;
                    switch (object.getErrorCode()) {
                        case 335544349: {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++n;
                            continue block11;
                        }
                    }
                    throw new DAOException((String)object2, (Throwable)hibernateException);
                }
                throw new DAOException((String)object2, (Throwable)hibernateException);
            }
            finally {
                this.closeSession();
            }
        }
        if (!bl) {
            throw new MessageException(this.res.informationTitle, this.res.attemptToRegisterKontrahFailed);
        }
        if (kontrahForRegister == null || daneKontrahForRegister == null) {
            return;
        }
        log.debug((Object)MessageFormat.format(this.res.newKontrahCreated, daneKontrahForRegister.getNazwaDl()));
        this.mailManager.sendNewKontrahRegistred(kontrahForRegister, daneKontrahForRegister, kraj.getNazwaKraju());
    }

    @ResourceContainer
    private class Res {
        private String attemptToRegisterKontrah;
        private String attemptToRegisterKontrahFailed;
        private String cannotGetCountryList;
        private String errorWhileRegisterKontrah;
        private String gettingCountryList;
        private String informationTitle;
        private String kontrahWithNipExists;
        private String newKontrahCreated;

        private Res() {
        }
    }
}

