/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import java.text.DecimalFormat;
import java.text.ParseException;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class NumberPeer
implements SerialPropertyPeer {
    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        String valueText = propertyElement.hasAttribute("v") ? propertyElement.getAttribute("v") : DomUtil.getElementText(propertyElement);
        try {
            return DecimalFormat.getInstance().parseObject(valueText);
        }
        catch (ParseException ex) {
            throw new SerialException("Cannot parse as number: " + valueText, ex);
        }
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", "n");
        propertyElement.appendChild(serialContext.getDocument().createTextNode(propertyValue.toString()));
    }
}

