/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.app.MutableStyle;
import nextapp.echo.app.Style;
import nextapp.echo.app.reflect.IntrospectorFactory;
import nextapp.echo.app.reflect.ObjectIntrospector;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPeerFactory;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class Serializer {
    private static final Map classLoaderToPropertyLoaderMap = new HashMap();
    private static final Map javaLangTypeMap;
    private SerialPeerFactory factory;
    private Map typeMap;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$nextapp$echo$app$serial$SerialContext;
    static /* synthetic */ Class class$nextapp$echo$app$serial$PropertyPeerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializer forClassLoader(ClassLoader classLoader) {
        Map map = classLoaderToPropertyLoaderMap;
        synchronized (map) {
            Serializer serializer = (Serializer)classLoaderToPropertyLoaderMap.get(classLoader);
            if (serializer == null) {
                serializer = new Serializer(classLoader);
                classLoaderToPropertyLoaderMap.put(classLoader, serializer);
            }
            return serializer;
        }
    }

    private Serializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.factory = SerialPeerFactory.forClassLoader(classLoader);
        this.typeMap = new HashMap();
    }

    public Class getClass(String type) throws ClassNotFoundException {
        Class clazz = (Class)javaLangTypeMap.get(type);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)this.typeMap.get(type);
        if (clazz != null) {
            return clazz;
        }
        if (type.indexOf(".") == -1) {
            String echoType = "nextapp.echo.app." + type;
            try {
                clazz = Class.forName(echoType, true, this.classLoader);
                this.typeMap.put(type, clazz);
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        clazz = Class.forName(type, true, this.classLoader);
        this.typeMap.put(type, clazz);
        return clazz;
    }

    public Style loadStyle(final SerialContext serialContext, String componentType, Element containerElement) throws SerialException {
        try {
            ObjectIntrospector introspector = IntrospectorFactory.get(componentType, this.classLoader);
            MutableStyle style = new MutableStyle();
            Context context = new Context(){

                public Object get(Class specificContextClass) {
                    if (specificContextClass == (class$nextapp$echo$app$serial$SerialContext == null ? (class$nextapp$echo$app$serial$SerialContext = Serializer.class$("nextapp.echo.app.serial.SerialContext")) : class$nextapp$echo$app$serial$SerialContext)) {
                        return serialContext;
                    }
                    if (specificContextClass == (class$nextapp$echo$app$serial$PropertyPeerFactory == null ? (class$nextapp$echo$app$serial$PropertyPeerFactory = Serializer.class$("nextapp.echo.app.serial.PropertyPeerFactory")) : class$nextapp$echo$app$serial$PropertyPeerFactory)) {
                        return Serializer.this.factory;
                    }
                    return null;
                }
            };
            Element[] pElements = DomUtil.getChildElementsByTagName(containerElement, "p");
            for (int i = 0; i < pElements.length; ++i) {
                if (!pElements[i].hasAttribute("n")) {
                    throw new SerialException("Found property without name in component \"" + componentType + "\".", null);
                }
                String name = pElements[i].getAttribute("n");
                SerialPropertyPeer peer = null;
                Class propertyClass = null;
                if (pElements[i].hasAttribute("t")) {
                    String type = pElements[i].getAttribute("t");
                    propertyClass = this.getClass(type);
                    peer = this.factory.getPeerForProperty(propertyClass);
                }
                int index = -1;
                if (pElements[i].hasAttribute("x")) {
                    index = Integer.parseInt(pElements[i].getAttribute("x"));
                }
                if (peer == null) {
                    propertyClass = introspector.getPropertyClass(name);
                    peer = this.factory.getPeerForProperty(propertyClass);
                }
                if (propertyClass == null) {
                    throw new SerialException("Cannot find class for property: " + componentType + "." + name, null);
                }
                if (peer == null) continue;
                Object value = peer.toProperty(context, introspector.getObjectClass(), pElements[i]);
                if (index == -1) {
                    style.set(name, value);
                    continue;
                }
                style.setIndex(name, index, value);
            }
            return style;
        }
        catch (ClassNotFoundException ex) {
            throw new SerialException("Error loading class.", ex);
        }
    }

    static {
        HashMap<String, Class> m = new HashMap<String, Class>();
        m.put("b", Boolean.class);
        m.put("i", Integer.class);
        m.put("s", String.class);
        javaLangTypeMap = Collections.unmodifiableMap(m);
    }
}

