/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.reflect;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ObjectIntrospector {
    public static final int PUBLIC_CONSTANT_MODIFERS = 25;
    private BeanInfo beanInfo;
    private Map eventSetDescriptorMap = new HashMap();
    private Class objectClass;
    private Map constants;
    private SortedMap propertyDescriptorMap = new TreeMap();

    protected ObjectIntrospector(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        this.objectClass = Class.forName(typeName, true, classLoader);
        try {
            this.beanInfo = Introspector.getBeanInfo(this.objectClass, 3);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("Introspection Error", ex);
        }
        this.loadBeanPropertyData();
        this.loadEventData();
        this.loadConstants();
    }

    public Set getConstantNames() {
        return Collections.unmodifiableSet(this.constants.keySet());
    }

    public Object getConstantValue(String constantName) {
        return this.constants.get(constantName);
    }

    public Set getEventHandlerNames(String eventSetName) {
        EventSetDescriptor eventSetDescriptor = this.getEventSetDescriptor(eventSetName);
        if (eventSetDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        MethodDescriptor[] methodDescriptors = eventSetDescriptor.getListenerMethodDescriptors();
        TreeSet<String> eventHandlerNames = new TreeSet<String>();
        for (int index = 0; index < methodDescriptors.length; ++index) {
            eventHandlerNames.add(methodDescriptors[index].getName());
        }
        return Collections.unmodifiableSet(eventHandlerNames);
    }

    public EventSetDescriptor getEventSetDescriptor(String eventSetName) {
        return (EventSetDescriptor)this.eventSetDescriptorMap.get(eventSetName);
    }

    public Set getEventSetNames() {
        return Collections.unmodifiableSet(this.eventSetDescriptorMap.keySet());
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public Class getPropertyClass(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("Invalid property name: " + propertyName);
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    public int getPropertyCount() {
        return this.propertyDescriptorMap.size();
    }

    public String getPropertyDefinitionConcreteType(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        Method readMethod = propertyDescriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() : propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        Class<?> definitionClass = readMethod.getDeclaringClass();
        while ((definitionClass.getModifiers() & 0x400) != 0) {
            definitionClass = definitionClass.getSuperclass();
        }
        return definitionClass.getName();
    }

    public String getPropertyDefinitionType(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        Method readMethod = propertyDescriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() : propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        return readMethod.getDeclaringClass().getName();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
    }

    public Iterator getPropertyNames() {
        return this.propertyDescriptorMap.keySet().iterator();
    }

    public Method getWriteMethod(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
        }
        return propertyDescriptor.getWriteMethod();
    }

    public boolean isIndexedProperty(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName) instanceof IndexedPropertyDescriptor;
    }

    private void loadConstants() {
        this.constants = new HashMap();
        Field[] fields = this.objectClass.getFields();
        for (int index = 0; index < fields.length; ++index) {
            if ((fields[index].getModifiers() & 0x19) == 0) continue;
            String constantName = fields[index].getName();
            try {
                Object constantValue = fields[index].get(null);
                this.constants.put(constantName, constantValue);
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
    }

    private void loadBeanPropertyData() {
        PropertyDescriptor[] propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        for (int index = 0; index < propertyDescriptors.length; ++index) {
            String name;
            if (propertyDescriptors[index] instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)propertyDescriptors[index]).getIndexedWriteMethod() == null) continue;
                name = propertyDescriptors[index].getName();
                this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
                continue;
            }
            if (propertyDescriptors[index].getWriteMethod() == null) continue;
            name = propertyDescriptors[index].getName();
            this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
        }
    }

    private void loadEventData() {
        EventSetDescriptor[] eventSetDescriptors = this.beanInfo.getEventSetDescriptors();
        for (int index = 0; index < eventSetDescriptors.length; ++index) {
            this.eventSetDescriptorMap.put(eventSetDescriptors[index].getName(), eventSetDescriptors[index]);
        }
    }

    public void setProperty(Object object, String propertyName, int index, Object propertyValue) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
            writeMethod.invoke(object, new Integer(index), propertyValue);
        } else {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            writeMethod.invoke(object, propertyValue);
        }
    }
}

