/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.button;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.button.ButtonModel;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;

public abstract class AbstractButton
extends Component {
    private static final long serialVersionUID = 20070101L;
    public static final String INPUT_ACTION = "action";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BACKGROUND_IMAGE = "disabledBackgroundImage";
    public static final String PROPERTY_DISABLED_BORDER = "disabledBorder";
    public static final String PROPERTY_DISABLED_FONT = "disabledFont";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_DISABLED_ICON = "disabledIcon";
    public static final String PROPERTY_FOCUSED_BACKGROUND = "focusedBackground";
    public static final String PROPERTY_FOCUSED_BACKGROUND_IMAGE = "focusedBackgroundImage";
    public static final String PROPERTY_FOCUSED_BORDER = "focusedBorder";
    public static final String PROPERTY_FOCUSED_ENABLED = "focusedEnabled";
    public static final String PROPERTY_FOCUSED_FONT = "focusedFont";
    public static final String PROPERTY_FOCUSED_FOREGROUND = "focusedForeground";
    public static final String PROPERTY_FOCUSED_ICON = "focusedIcon";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ALIGNMENT = "alignment";
    public static final String PROPERTY_ICON_TEXT_MARGIN = "iconTextMargin";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_LINE_WRAP = "lineWrap";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_PRESSED_BACKGROUND = "pressedBackground";
    public static final String PROPERTY_PRESSED_BACKGROUND_IMAGE = "pressedBackgroundImage";
    public static final String PROPERTY_PRESSED_BORDER = "pressedBorder";
    public static final String PROPERTY_PRESSED_ENABLED = "pressedEnabled";
    public static final String PROPERTY_PRESSED_FONT = "pressedFont";
    public static final String PROPERTY_PRESSED_FOREGROUND = "pressedForeground";
    public static final String PROPERTY_PRESSED_ICON = "pressedIcon";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_BACKGROUND_IMAGE = "rolloverBackgroundImage";
    public static final String PROPERTY_ROLLOVER_BORDER = "rolloverBorder";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_FONT = "rolloverFont";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_ROLLOVER_ICON = "rolloverIcon";
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_TEXT_ALIGNMENT = "textAlignment";
    public static final String PROPERTY_TEXT_POSITION = "textPosition";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_WIDTH = "width";
    private ActionListener actionForwarder = new ActionListener(){
        private static final long serialVersionUID = 20070101L;

        public void actionPerformed(ActionEvent modelEvent) {
            ActionEvent buttonEvent = new ActionEvent(AbstractButton.this, modelEvent.getActionCommand());
            AbstractButton.this.fireActionPerformed(buttonEvent);
        }
    };

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void doAction() {
        this.getModel().doAction();
    }

    public void fireActionPerformed(ActionEvent e) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ActionListener)listeners[index]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return this.getModel().getActionCommand();
    }

    public Alignment getAlignment() {
        return (Alignment)this.get(PROPERTY_ALIGNMENT);
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public Color getDisabledBackground() {
        return (Color)this.get(PROPERTY_DISABLED_BACKGROUND);
    }

    public FillImage getDisabledBackgroundImage() {
        return (FillImage)this.get(PROPERTY_DISABLED_BACKGROUND_IMAGE);
    }

    public Border getDisabledBorder() {
        return (Border)this.get(PROPERTY_DISABLED_BORDER);
    }

    public Font getDisabledFont() {
        return (Font)this.get(PROPERTY_DISABLED_FONT);
    }

    public Color getDisabledForeground() {
        return (Color)this.get(PROPERTY_DISABLED_FOREGROUND);
    }

    public ImageReference getDisabledIcon() {
        return (ImageReference)this.get(PROPERTY_DISABLED_ICON);
    }

    public Color getFocusedBackground() {
        return (Color)this.get(PROPERTY_FOCUSED_BACKGROUND);
    }

    public FillImage getFocusedBackgroundImage() {
        return (FillImage)this.get(PROPERTY_FOCUSED_BACKGROUND_IMAGE);
    }

    public Border getFocusedBorder() {
        return (Border)this.get(PROPERTY_FOCUSED_BORDER);
    }

    public Font getFocusedFont() {
        return (Font)this.get(PROPERTY_FOCUSED_FONT);
    }

    public Color getFocusedForeground() {
        return (Color)this.get(PROPERTY_FOCUSED_FOREGROUND);
    }

    public ImageReference getFocusedIcon() {
        return (ImageReference)this.get(PROPERTY_FOCUSED_ICON);
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public ImageReference getIcon() {
        return (ImageReference)this.get(PROPERTY_ICON);
    }

    public Extent getIconTextMargin() {
        return (Extent)this.get(PROPERTY_ICON_TEXT_MARGIN);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public ButtonModel getModel() {
        return (ButtonModel)this.get(PROPERTY_MODEL);
    }

    public Color getPressedBackground() {
        return (Color)this.get(PROPERTY_PRESSED_BACKGROUND);
    }

    public FillImage getPressedBackgroundImage() {
        return (FillImage)this.get(PROPERTY_PRESSED_BACKGROUND_IMAGE);
    }

    public Border getPressedBorder() {
        return (Border)this.get(PROPERTY_PRESSED_BORDER);
    }

    public Font getPressedFont() {
        return (Font)this.get(PROPERTY_PRESSED_FONT);
    }

    public Color getPressedForeground() {
        return (Color)this.get(PROPERTY_PRESSED_FOREGROUND);
    }

    public ImageReference getPressedIcon() {
        return (ImageReference)this.get(PROPERTY_PRESSED_ICON);
    }

    public Color getRolloverBackground() {
        return (Color)this.get(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public FillImage getRolloverBackgroundImage() {
        return (FillImage)this.get(PROPERTY_ROLLOVER_BACKGROUND_IMAGE);
    }

    public Border getRolloverBorder() {
        return (Border)this.get(PROPERTY_ROLLOVER_BORDER);
    }

    public Font getRolloverFont() {
        return (Font)this.get(PROPERTY_ROLLOVER_FONT);
    }

    public Color getRolloverForeground() {
        return (Color)this.get(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public ImageReference getRolloverIcon() {
        return (ImageReference)this.get(PROPERTY_ROLLOVER_ICON);
    }

    public String getText() {
        return (String)this.get(PROPERTY_TEXT);
    }

    public Alignment getTextAlignment() {
        return (Alignment)this.get(PROPERTY_TEXT_ALIGNMENT);
    }

    public Alignment getTextPosition() {
        return (Alignment)this.get(PROPERTY_TEXT_POSITION);
    }

    public String getToolTipText() {
        return (String)this.get(PROPERTY_TOOL_TIP_TEXT);
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean isFocusedEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_PRESSED_ENABLED);
        return value == null ? false : value;
    }

    public boolean isLineWrap() {
        Boolean value = (Boolean)this.get(PROPERTY_LINE_WRAP);
        return value == null ? true : value;
    }

    public boolean isPressedEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_PRESSED_ENABLED);
        return value == null ? false : value;
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isValidChild(Component component) {
        return false;
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (INPUT_ACTION.equals(name)) {
            this.doAction();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.getModel().setActionCommand(newValue);
    }

    public void setAlignment(Alignment newValue) {
        this.set(PROPERTY_ALIGNMENT, newValue);
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND_IMAGE, newValue);
    }

    public void setDisabledBorder(Border newValue) {
        this.set(PROPERTY_DISABLED_BORDER, newValue);
    }

    public void setDisabledFont(Font newValue) {
        this.set(PROPERTY_DISABLED_FONT, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.set(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setDisabledIcon(ImageReference newValue) {
        this.set(PROPERTY_DISABLED_ICON, newValue);
    }

    public void setFocusedBackground(Color newValue) {
        this.set(PROPERTY_FOCUSED_BACKGROUND, newValue);
    }

    public void setFocusedBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_FOCUSED_BACKGROUND_IMAGE, newValue);
    }

    public void setFocusedBorder(Border newValue) {
        this.set(PROPERTY_FOCUSED_BORDER, newValue);
    }

    public void setFocusedEnabled(boolean newValue) {
        this.set(PROPERTY_FOCUSED_ENABLED, new Boolean(newValue));
    }

    public void setFocusedFont(Font newValue) {
        this.set(PROPERTY_FOCUSED_FONT, newValue);
    }

    public void setFocusedForeground(Color newValue) {
        this.set(PROPERTY_FOCUSED_FOREGROUND, newValue);
    }

    public void setFocusedIcon(ImageReference newValue) {
        this.set(PROPERTY_FOCUSED_ICON, newValue);
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setIcon(ImageReference newValue) {
        this.set(PROPERTY_ICON, newValue);
    }

    public void setIconTextMargin(Extent newValue) {
        this.set(PROPERTY_ICON_TEXT_MARGIN, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setLineWrap(boolean newValue) {
        this.set(PROPERTY_LINE_WRAP, new Boolean(newValue));
    }

    public void setModel(ButtonModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Model may not be null.");
        }
        ButtonModel oldValue = this.getModel();
        if (oldValue != null) {
            oldValue.removeActionListener(this.actionForwarder);
        }
        newValue.addActionListener(this.actionForwarder);
        this.set(PROPERTY_MODEL, newValue);
    }

    public void setPressedBackground(Color newValue) {
        this.set(PROPERTY_PRESSED_BACKGROUND, newValue);
    }

    public void setPressedBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_PRESSED_BACKGROUND_IMAGE, newValue);
    }

    public void setPressedBorder(Border newValue) {
        this.set(PROPERTY_PRESSED_BORDER, newValue);
    }

    public void setPressedEnabled(boolean newValue) {
        this.set(PROPERTY_PRESSED_ENABLED, new Boolean(newValue));
    }

    public void setPressedFont(Font newValue) {
        this.set(PROPERTY_PRESSED_FONT, newValue);
    }

    public void setPressedForeground(Color newValue) {
        this.set(PROPERTY_PRESSED_FOREGROUND, newValue);
    }

    public void setPressedIcon(ImageReference newValue) {
        this.set(PROPERTY_PRESSED_ICON, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND_IMAGE, newValue);
    }

    public void setRolloverBorder(Border newValue) {
        this.set(PROPERTY_ROLLOVER_BORDER, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setRolloverFont(Font newValue) {
        this.set(PROPERTY_ROLLOVER_FONT, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_FOREGROUND, newValue);
    }

    public void setRolloverIcon(ImageReference newValue) {
        this.set(PROPERTY_ROLLOVER_ICON, newValue);
    }

    public void setText(String newValue) {
        this.set(PROPERTY_TEXT, newValue);
    }

    public void setTextAlignment(Alignment newValue) {
        this.set(PROPERTY_TEXT_ALIGNMENT, newValue);
    }

    public void setTextPosition(Alignment newValue) {
        this.set(PROPERTY_TEXT_POSITION, newValue);
    }

    public void setToolTipText(String newValue) {
        this.set(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }
}

