/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.Extent;

public class DecimalExtent
extends Extent {
    private final double decimalValue;

    public DecimalExtent(double decimalValue) {
        this(decimalValue, 1);
    }

    public DecimalExtent(double decimalValue, int units) {
        super((int)Math.round(decimalValue), units);
        this.decimalValue = decimalValue;
    }

    public double getDecimalValue() {
        return this.decimalValue;
    }

    public int toMm() {
        switch (this.getUnits()) {
            case 16: {
                return (int)this.decimalValue;
            }
            case 8: {
                return (int)(this.decimalValue * 10.0);
            }
            case 32: {
                return (int)(this.decimalValue * 25.4);
            }
            case 4: {
                return (int)(this.decimalValue / 72.0 * 25.4);
            }
            case 256: {
                return (int)(this.decimalValue / 6.0 * 25.4);
            }
        }
        throw new IllegalStateException("Cannot convert to mm.");
    }

    public int toPoint() {
        switch (this.getUnits()) {
            case 4: {
                return (int)this.decimalValue;
            }
            case 256: {
                return (int)(this.decimalValue * 12.0);
            }
            case 32: {
                return (int)(this.decimalValue * 72.0);
            }
            case 16: {
                return (int)(this.decimalValue / 25.4 * 72.0);
            }
            case 8: {
                return (int)(this.decimalValue / 2.54 * 72.0);
            }
        }
        throw new IllegalStateException("Cannot convert to pt.");
    }

    public String toString() {
        return this.decimalValue + DecimalExtent.getUnitsString(this.getUnits());
    }
}

