/*
 * Decompiled with CFR 0.152.
 */
package tucana.echo2.app;

import java.io.IOException;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import pl.com.stream.echo.lib.ui.fileupload.FileNameFilter;
import tucana.echo2.app.fileuploader.UploadCallback;
import tucana.echo2.app.fileuploader.UploadEvent;
import tucana.echo2.app.internal.ClassLoaderImageReference;

public class FileUploadSelector
extends Component {
    private static final long serialVersionUID = -471006672304057870L;
    private static final String TEMPDIR_PATH = System.getProperty("java.io.tmpdir", ".");
    private static final int MB = 0x100000;
    private static final int DEFAULT_UPLOAD_LIMIT = 0x20000000;
    public static final String PROPERTY_BUTTON_TEXT_UPLOAD = "button-text-upload";
    public static final String PROPERTY_BUTTON_TEXT_CANCEL = "button-text-cancel";
    public static final String PROPERTY_BUTTON_TEXT_WAIT = "button-text-wait";
    public static final String PROPERTY_BUTTON_IMAGE_UPLOAD = "button-image-upload";
    public static final String PROPERTY_BUTTON_IMAGE_CANCEL = "button-image-cancel";
    public static final String PROPERTY_BUTTON_IMAGE_WAIT = "button-image-wait";
    public static final String PROPERTY_BUTTON_MODE = "button-mode";
    public static final String PROPERTY_BUTTON_DISPLAY = "button-display";
    public static final String PROPERTY_WIDTH_SIZE = "width-size";
    public static final String PROPERTY_WIDTH_EXTENT = "width-extent";
    public static final String PROPERTY_WIDTH_MODE = "width-mode";
    public static final String PROPERTY_CANCEL_ENABLED = "cancel-enabled";
    public static final String PROPERTY_DESTINATION_DIR = "destination-dir";
    public static final String PROPERTY_MAX_FILE_SIZE = "max-file-size";
    public static final String PROPERTY_FILE_NAME_FILTER = "filename-filter";
    public static final String PROPERTY_COMPRESS_FILE = "compress-file";
    public static final String ACTION_FILE_UPLOADED = "fileUploaded";
    public static final int BUTTON_MODE_TEXT = 0;
    public static final int BUTTON_MODE_IMAGE = 1;
    public static final int BUTTON_DISPLAY_RIGHT = 0;
    public static final int BUTTON_DISPLAY_LEFT = 1;
    public static final int BUTTON_DISPLAY_AUTO = 2;
    public static final int BUTTON_DISPLAY_NONE = 3;
    public static final int WIDTH_MODE_SIZE = 0;
    public static final int WIDTH_MODE_EXTENT = 1;
    private static ImageReference DEFAULT_UPLOAD_IMAGE = new ClassLoaderImageReference(FileUploadSelector.class.getClassLoader(), "/tucana/echo2/app/resource/image/upload.png");
    private static ImageReference DEFAULT_CANCEL_IMAGE = new ClassLoaderImageReference(FileUploadSelector.class.getClassLoader(), "/tucana/echo2/app/resource/image/cancel.png");
    private static ImageReference DEFAULT_WAIT_IMAGE = new ClassLoaderImageReference(FileUploadSelector.class.getClassLoader(), "/tucana/echo2/app/resource/image/wait.png");
    private UploadCallback callback = null;

    public FileUploadSelector() {
        this.setButtonMode(1);
        this.setButtonUploadImage(DEFAULT_UPLOAD_IMAGE);
        this.setButtonCancelImage(DEFAULT_CANCEL_IMAGE);
        this.setButtonWaitImage(DEFAULT_WAIT_IMAGE);
        this.setButtonUploadText("Upload");
        this.setButtonCancelText("Cancel");
        this.setButtonWaitText("Wait...");
        this.setWidthMode(1);
        this.setWidthExtent(new Extent(300));
        this.setCancelEnabled(true);
        this.setDestinationDir(TEMPDIR_PATH);
        this.setMaxFileSize(0x20000000);
    }

    public ImageReference getButtonCancelImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_CANCEL);
    }

    public String getButtonCancelText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_CANCEL);
    }

    public int getButtonDisplayMode() {
        Integer n = (Integer)this.get(PROPERTY_BUTTON_DISPLAY);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int getButtonMode() {
        Integer n = (Integer)this.get(PROPERTY_BUTTON_MODE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public ImageReference getButtonUploadImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_UPLOAD);
    }

    public String getButtonUploadText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_UPLOAD);
    }

    public ImageReference getButtonWaitImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_WAIT);
    }

    public String getButtonWaitText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_WAIT);
    }

    public String getDestinationDir() {
        return (String)this.get(PROPERTY_DESTINATION_DIR);
    }

    public FileNameFilter getFileNameFilter() {
        FileNameFilter fileNameFilter = (FileNameFilter)this.get(PROPERTY_FILE_NAME_FILTER);
        return fileNameFilter;
    }

    public int getMaxFileSize() {
        int n = (Integer)this.get(PROPERTY_MAX_FILE_SIZE);
        return n;
    }

    public UploadCallback getUploadCallback() {
        return this.callback;
    }

    public Extent getWidthExtent() {
        return (Extent)this.get(PROPERTY_WIDTH_EXTENT);
    }

    public int getWidthMode() {
        Integer n = (Integer)this.get(PROPERTY_WIDTH_MODE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int getWidthSize() {
        Integer n = (Integer)this.get(PROPERTY_WIDTH_SIZE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean isCancelEnabled() {
        Boolean bl = (Boolean)this.get(PROPERTY_CANCEL_ENABLED);
        return Boolean.TRUE.equals(bl);
    }

    public boolean isCompressFile() {
        Boolean bl = (Boolean)this.get(PROPERTY_COMPRESS_FILE);
        return Boolean.TRUE.equals(bl);
    }

    public boolean isValidChild(Component component) {
        return false;
    }

    public void processInput(String string, Object object) {
        UploadEvent uploadEvent;
        if (ACTION_FILE_UPLOADED.equals(string) && (uploadEvent = (UploadEvent)object) != null) {
            if (this.callback != null) {
                if (uploadEvent.isEmpty()) {
                    this.callback.uploadFailed(uploadEvent);
                } else {
                    this.callback.uploadSucceeded(uploadEvent);
                }
            } else {
                try {
                    uploadEvent.getStrFileItem().getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void setButtonCancelImage(ImageReference imageReference) {
        this.set(PROPERTY_BUTTON_IMAGE_CANCEL, imageReference);
    }

    public void setButtonCancelText(String string) {
        this.set(PROPERTY_BUTTON_TEXT_CANCEL, string);
    }

    public void setButtonDisplayMode(int n) {
        this.set(PROPERTY_BUTTON_DISPLAY, new Integer(n));
    }

    public void setButtonMode(int n) {
        this.set(PROPERTY_BUTTON_MODE, new Integer(n));
    }

    public void setButtonUploadImage(ImageReference imageReference) {
        this.set(PROPERTY_BUTTON_IMAGE_UPLOAD, imageReference);
    }

    public void setButtonUploadText(String string) {
        this.set(PROPERTY_BUTTON_TEXT_UPLOAD, string);
    }

    public void setButtonWaitImage(ImageReference imageReference) {
        this.set(PROPERTY_BUTTON_IMAGE_WAIT, imageReference);
    }

    public void setButtonWaitText(String string) {
        this.set(PROPERTY_BUTTON_TEXT_WAIT, string);
    }

    public void setCancelEnabled(boolean bl) {
        this.set(PROPERTY_CANCEL_ENABLED, new Boolean(bl));
    }

    public void setCompressFile(boolean bl) {
        this.set(PROPERTY_COMPRESS_FILE, bl);
    }

    public void setDestinationDir(String string) {
        if (string == null) {
            string = TEMPDIR_PATH;
        }
        this.set(PROPERTY_DESTINATION_DIR, string);
    }

    public void setFileNameFilter(FileNameFilter fileNameFilter) {
        this.set(PROPERTY_FILE_NAME_FILTER, fileNameFilter);
    }

    public void setMaxFileSize(int n) {
        this.set(PROPERTY_MAX_FILE_SIZE, n * 0x100000);
    }

    public void setUploadCallback(UploadCallback uploadCallback) {
        this.callback = uploadCallback;
    }

    public void setWidthExtent(Extent extent) {
        this.set(PROPERTY_WIDTH_EXTENT, extent);
    }

    public void setWidthMode(int n) {
        this.set(PROPERTY_WIDTH_MODE, new Integer(n));
    }

    public void setWidthSize(int n) {
        this.set(PROPERTY_WIDTH_SIZE, new Integer(n));
    }
}

