/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util.filter;

import java.util.HashMap;
import java.util.Map;
import pl.com.stream.echo.lib.util.filter.FileNameFilter;

public class FileNameFilterImpl
implements FileNameFilter {
    private int maxFileNameLength;
    private static Map<Character, Character> charMap;

    public FileNameFilterImpl() {
        charMap = new HashMap<Character, Character>();
        charMap.put(Character.valueOf('\u0105'), Character.valueOf('a'));
        charMap.put(Character.valueOf('\u0119'), Character.valueOf('e'));
        charMap.put(Character.valueOf('\u0107'), Character.valueOf('c'));
        charMap.put(Character.valueOf('\u015b'), Character.valueOf('s'));
        charMap.put(Character.valueOf('\u0144'), Character.valueOf('n'));
        charMap.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
        charMap.put(Character.valueOf('\u017a'), Character.valueOf('z'));
        charMap.put(Character.valueOf('\u017c'), Character.valueOf('z'));
        charMap.put(Character.valueOf('\u0142'), Character.valueOf('l'));
        charMap.put(Character.valueOf('\u0104'), Character.valueOf('A'));
        charMap.put(Character.valueOf('\u0118'), Character.valueOf('E'));
        charMap.put(Character.valueOf('\u0106'), Character.valueOf('C'));
        charMap.put(Character.valueOf('\u015a'), Character.valueOf('S'));
        charMap.put(Character.valueOf('\u0143'), Character.valueOf('N'));
        charMap.put(Character.valueOf('\u00d3'), Character.valueOf('O'));
        charMap.put(Character.valueOf('\u0179'), Character.valueOf('Z'));
        charMap.put(Character.valueOf('\u017b'), Character.valueOf('Z'));
        charMap.put(Character.valueOf('\u0141'), Character.valueOf('L'));
    }

    public void setMaxFileNameLength(int n) {
        this.maxFileNameLength = n;
    }

    public String filter(String string) {
        int n;
        CharSequence charSequence;
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        if (string.lastIndexOf("/") != -1) {
            string = string.substring(string.lastIndexOf("/") + 1, string.length());
        }
        if (string.lastIndexOf("\\") != -1) {
            string = string.substring(string.lastIndexOf("\\") + 1, string.length());
        }
        if (this.maxFileNameLength > 0 && string.length() > this.maxFileNameLength) {
            charSequence = this.getExtension(string);
            if (charSequence == null) {
                string = string.substring(0, this.maxFileNameLength);
            } else {
                n = this.maxFileNameLength - ((String)charSequence).length() - 1;
                string = string.substring(0, n) + "." + (String)charSequence;
            }
        }
        charSequence = new StringBuffer(string.replaceAll("\\s", "_"));
        for (n = 0; n < string.length(); ++n) {
            Character c = Character.valueOf(string.charAt(n));
            Character c2 = charMap.get(c);
            if (c2 == null) continue;
            ((StringBuffer)charSequence).setCharAt(n, c2.charValue());
        }
        return ((StringBuffer)charSequence).toString();
    }

    protected String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }
}

