/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util.database;

import java.util.List;
import pl.com.stream.echo.lib.database.criterion.Criterion;
import pl.com.stream.echo.lib.database.criterion.Restrictions;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.TTableColumnList;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.type.sql.TSqlBuilder;
import pl.com.stream.echo.lib.type.sql.TSqlFrom;
import pl.com.stream.echo.lib.type.sql.TSqlOrderBy;
import pl.com.stream.echo.lib.type.sql.TSqlSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinMaker {
    private Criterion additionalFilter;
    private TTableColumnList allVisibleColumnList;
    private Criterion fastSearchFilter;
    private TJoinTable masterTable;
    private boolean masterTableChanged = false;
    private TSelectedTableColumnList selectedColumnList;
    private TSelectedTableColumnOrderList selectedColumnOrderList;
    private TSelectedDetailsColumnList selectedDetailsColumnList;
    private TSqlFrom sqlFrom;
    private TSqlFrom sqlFromForDetails;
    private TSqlSelect sqlSelectForDetails;
    private TSqlSelect sqlSelectForTable;
    private Criterion treeFilter;
    private TTableColumnList visibleDetailsColumnList;
    private TTableColumnList visibleTableColumnList;
    private Criterion whereProg;
    private Criterion windowFilter;

    public String createCountQuery(boolean bl, boolean bl2) {
        return this.createSqlBuilderForCountQuery(bl).getSelectCountQuery(bl2);
    }

    public String createQuery(boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        return this.createSqlBuilderForQuery(bl, bl2, n, n2).getSelectQuery(bl3);
    }

    public String createQueryForSingleRow(int n, boolean bl) {
        return this.createSqlBuilderForSingleRowQuery(n).getSelectQuery(bl);
    }

    public TSqlBuilder createSqlBuilderForCountQuery(boolean bl) {
        TSqlBuilder tSqlBuilder = new TSqlBuilder();
        tSqlBuilder.setDistinctQuery(bl);
        tSqlBuilder.setStronnicowanie(false, 0, 0);
        tSqlBuilder.setSelect(this.getSelectForTable());
        tSqlBuilder.setFrom(this.getFromForTable());
        tSqlBuilder.setProgramFilter(this.getWhereProg());
        tSqlBuilder.setWindowFilter(this.getWhereFilter());
        tSqlBuilder.setFastSearchFilter(this.getFastSearchFilter());
        tSqlBuilder.setTreeFilter(this.getTreeFilter());
        tSqlBuilder.setAdditionalFilter(this.getAdditionalFilter());
        return tSqlBuilder;
    }

    public TSqlBuilder createSqlBuilderForQuery(boolean bl, boolean bl2, int n, int n2) {
        TSqlBuilder tSqlBuilder = new TSqlBuilder();
        tSqlBuilder.setDistinctQuery(bl);
        tSqlBuilder.setStronnicowanie(bl2, n, n2);
        tSqlBuilder.setSelect(this.getSelectForTable());
        tSqlBuilder.setFrom(this.getFromForTable());
        tSqlBuilder.setProgramFilter(this.getWhereProg());
        tSqlBuilder.setWindowFilter(this.getWhereFilter());
        tSqlBuilder.setFastSearchFilter(this.getFastSearchFilter());
        tSqlBuilder.setTreeFilter(this.getTreeFilter());
        tSqlBuilder.setAdditionalFilter(this.getAdditionalFilter());
        tSqlBuilder.setOrderBy(this.getOrderBy());
        return tSqlBuilder;
    }

    public TSqlBuilder createSqlBuilderForSingleRowQuery(int n) {
        TSqlBuilder tSqlBuilder = new TSqlBuilder();
        tSqlBuilder.setDistinctQuery(false);
        tSqlBuilder.setStronnicowanie(false, 0, 0);
        tSqlBuilder.setSelect(this.getSelectForDetails());
        tSqlBuilder.setFrom(this.getFromForDetails());
        tSqlBuilder.setProgramFilter(this.getWhereProg());
        tSqlBuilder.setTreeFilter(this.getTreeFilter());
        tSqlBuilder.setAdditionalFilter(this.getAdditionalFilter());
        tSqlBuilder.setWhereRowId(this.getWhereRowId(n));
        return tSqlBuilder;
    }

    public TTableColumnList getAllVisibleColumnList() {
        if (this.allVisibleColumnList == null || this.isMasterTableChanged()) {
            this.allVisibleColumnList = new TTableColumnList(this.masterTable);
        }
        return this.allVisibleColumnList;
    }

    public String getMasterTableIdColumnName() {
        if (this.masterTable == null) {
            return null;
        }
        return this.masterTable.getJoinColumn();
    }

    public TSelectedTableColumnList getSelectedColumnList() {
        return this.selectedColumnList;
    }

    public TSelectedTableColumnOrderList getSelectedColumnOrderList() {
        return this.selectedColumnOrderList;
    }

    public TSelectedDetailsColumnList getSelectedDetailsColumnList() {
        return this.selectedDetailsColumnList;
    }

    public TSqlSelect getSelectForDetails() {
        if (this.sqlSelectForDetails == null || this.isMasterTableChanged()) {
            this.sqlSelectForDetails = new TSqlSelect(this.masterTable, this.selectedDetailsColumnList);
        }
        return this.sqlSelectForDetails;
    }

    public TSqlSelect getSelectForTable() {
        if (this.sqlSelectForTable == null || this.isMasterTableChanged()) {
            this.sqlSelectForTable = new TSqlSelect(this.masterTable, this.selectedColumnList);
        }
        return this.sqlSelectForTable;
    }

    public TTableColumnList getVisibleDetailsColumnList() {
        if (this.visibleDetailsColumnList == null || this.isMasterTableChanged()) {
            this.visibleDetailsColumnList = new TTableColumnList(this.masterTable, this.selectedDetailsColumnList);
        }
        return this.visibleDetailsColumnList;
    }

    public TTableColumnList getVisibleTableColumnList() {
        if (this.visibleTableColumnList == null || this.isMasterTableChanged()) {
            this.visibleTableColumnList = new TTableColumnList(this.masterTable, this.selectedColumnList);
        }
        return this.visibleTableColumnList;
    }

    public boolean isAdditionalFilterActive() {
        return this.additionalFilter != null;
    }

    public boolean isFaseSearchFilterActive() {
        return this.fastSearchFilter != null;
    }

    public boolean isMasterTableChanged() {
        return this.masterTableChanged;
    }

    public boolean isTreeFilterActive() {
        return this.treeFilter != null;
    }

    public boolean isWhereProgFilterActive() {
        return this.whereProg != null;
    }

    public boolean isWindowFilterActive() {
        return this.windowFilter != null;
    }

    public void setAdditionalFilter(Criterion criterion) {
        this.additionalFilter = criterion;
    }

    public void setFastSearchFilter(Criterion criterion) {
        this.fastSearchFilter = criterion;
    }

    public void setMasterTable(TJoinTable tJoinTable) {
        if (tJoinTable == null) {
            throw new IllegalArgumentException("Master table can not be null.");
        }
        if (!tJoinTable.getJoinType().equals((Object)TJoinTable.JoinTypes.jtMaster)) {
            throw new IllegalArgumentException("The type of table: " + tJoinTable.getTableName() + " must be JoinTypes.jtMaster.");
        }
        this.masterTable = tJoinTable;
        this.setMasterTableChanged(true);
    }

    public void setMasterTableChanged(boolean bl) {
        this.masterTableChanged = bl;
    }

    public void setProgramFilter(Criterion criterion) {
        this.whereProg = criterion;
    }

    public void setSelectedColumnOrderList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.selectedColumnOrderList = tSelectedTableColumnOrderList;
    }

    public void setSelectedDetailsColumnList(TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        this.sqlSelectForDetails = new TSqlSelect(this.masterTable, tSelectedDetailsColumnList);
        this.sqlFromForDetails = new TSqlFrom(this.masterTable, this.sqlSelectForDetails);
        this.selectedDetailsColumnList = tSelectedDetailsColumnList;
        this.visibleDetailsColumnList = new TTableColumnList(this.masterTable, this.selectedDetailsColumnList);
    }

    public void setSelectedDetailsColumnListFromVisibleColumnList(List<?> list) {
        TSelectedDetailsColumnList tSelectedDetailsColumnList = new TSelectedDetailsColumnList();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof ITableColumn)) continue;
            ITableColumn iTableColumn = (ITableColumn)obj;
            tSelectedDetailsColumnList.addColumn(iTableColumn.getTableAlias(), iTableColumn.getName(), i);
        }
        this.setSelectedDetailsColumnList(tSelectedDetailsColumnList);
    }

    public void setSelectedTableColumnList(TSelectedTableColumnList tSelectedTableColumnList) {
        this.sqlSelectForTable = new TSqlSelect(this.masterTable, tSelectedTableColumnList);
        this.sqlFrom = new TSqlFrom(this.masterTable, this.sqlSelectForTable);
        tSelectedTableColumnList.checkForRequiedColumns(this.masterTable);
        this.selectedColumnList = tSelectedTableColumnList;
        this.visibleTableColumnList = new TTableColumnList(this.masterTable, this.selectedColumnList);
    }

    public void setSelectedTableColumnListFromVisibleColumnList(List<?> list) {
        TSelectedTableColumnList tSelectedTableColumnList = new TSelectedTableColumnList();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof ITableColumn)) continue;
            ITableColumn iTableColumn = (ITableColumn)obj;
            tSelectedTableColumnList.addColumn(iTableColumn.getTableAlias(), iTableColumn.getName(), i, iTableColumn.getSize(), iTableColumn.getSizeUnit());
        }
        this.setSelectedTableColumnList(tSelectedTableColumnList);
    }

    public void setTreeFilter(Criterion criterion) {
        this.treeFilter = criterion;
    }

    public void setWindowFilter(Criterion criterion) {
        this.windowFilter = criterion;
    }

    private Criterion getAdditionalFilter() {
        return this.additionalFilter;
    }

    private Criterion getFastSearchFilter() {
        return this.fastSearchFilter;
    }

    private TSqlFrom getFromForDetails() {
        if (this.sqlFromForDetails == null || this.isMasterTableChanged()) {
            this.sqlFromForDetails = new TSqlFrom(this.masterTable, this.getSelectForDetails());
        }
        return this.sqlFromForDetails;
    }

    private TSqlFrom getFromForTable() {
        if (this.sqlFrom == null || this.isMasterTableChanged()) {
            this.sqlFrom = new TSqlFrom(this.masterTable, this.getSelectForTable());
        }
        return this.sqlFrom;
    }

    private TSqlOrderBy getOrderBy() {
        TSqlOrderBy tSqlOrderBy = new TSqlOrderBy(this.getSelectForTable());
        for (TSelectedTableColumnOrder tSelectedTableColumnOrder : this.selectedColumnOrderList) {
            tSqlOrderBy.addOrderColumn(tSelectedTableColumnOrder.getTableAlias(), tSelectedTableColumnOrder.getColumnName(), tSelectedTableColumnOrder.getOrderType());
        }
        return tSqlOrderBy;
    }

    private Criterion getTreeFilter() {
        return this.treeFilter;
    }

    private Criterion getWhereFilter() {
        return this.windowFilter;
    }

    private Criterion getWhereProg() {
        return this.whereProg;
    }

    private Criterion getWhereRowId(int n) {
        Criterion criterion = new Criterion(Restrictions.eq(this.masterTable.getTableName(), this.masterTable.getTableAlias(), this.masterTable.getJoinColumn(), n));
        return criterion;
    }
}

