/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.TDetailsTableObject;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.TTableRowObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.type.sql.TSqlSelect;
import pl.com.stream.echo.lib.type.sql.TSqlSelectObject;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBManager
extends HibernateSessionProvider {
    private static Logger log = Logger.getLogger(DBManager.class);
    private static final long serialVersionUID = -716696287815066260L;
    @ResourceContainer
    private Res res;

    public DBManager() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
    }

    public ArrayList<TDetailsTableObject> getDetailsForSelectedRowFromDB(String string, List<ITableColumn> list, TSqlSelect tSqlSelect) throws MessageException {
        ArrayList<TDetailsTableObject> arrayList = null;
        try {
            long l = System.currentTimeMillis();
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            preparedStatement = connection.prepareStatement(string);
            log.debug((Object)MessageFormat.format(this.res.gettingDataForRow, string));
            resultSet = preparedStatement.executeQuery();
            arrayList = new ArrayList<TDetailsTableObject>();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    Object object;
                    ITableColumn iTableColumn = this.getColumn(list, resultSetMetaData.getColumnName(i));
                    if (iTableColumn == null && (object = tSqlSelect.getSqlSelect(resultSetMetaData.getColumnName(i))) != null) {
                        iTableColumn = this.getColumn(list, ((TSqlSelectObject)object).getOrginalColumnName());
                    }
                    object = null;
                    object = iTableColumn == null ? resultSetMetaData.getColumnLabel(i) : iTableColumn.getLabel();
                    TDetailsTableObject tDetailsTableObject = new TDetailsTableObject((String)object, resultSet.getObject(i), iTableColumn);
                    arrayList.add(tDetailsTableObject);
                }
            }
            resultSet.close();
            preparedStatement.close();
            this.commitTransaction();
            resultSet = null;
            preparedStatement = null;
            connection = null;
            log.debug((Object)("Row details data fetched in: " + (System.currentTimeMillis() - l) + " ms"));
            return arrayList;
        }
        catch (Exception exception) {
            String string2 = MessageFormat.format(this.res.gettingDataForRowFailed, exception.getMessage());
            log.error((Object)string2, (Throwable)exception);
            throw new MessageException(string2, exception);
        }
    }

    public int getRowNumberFromDBForQuery(String string) throws MessageException {
        int n = 0;
        try {
            long l = System.currentTimeMillis();
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            preparedStatement = connection.prepareStatement(string);
            log.debug((Object)MessageFormat.format(this.res.gettingDataCount, string));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            this.commitTransaction();
            resultSet = null;
            preparedStatement = null;
            connection = null;
            log.debug((Object)("Table data count fetched in: " + (System.currentTimeMillis() - l) + " ms"));
            return n;
        }
        catch (Exception exception) {
            String string2 = MessageFormat.format(this.res.gettingDataCountFailed, exception.getMessage());
            log.error((Object)string2, (Throwable)exception);
            throw new MessageException(string2, exception);
        }
    }

    public TTableObject getTableObjectFromDB(String string, String string2, TSqlSelect tSqlSelect) throws MessageException {
        TTableObject tTableObject = null;
        try {
            long l = System.currentTimeMillis();
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            preparedStatement = connection.prepareStatement(string);
            log.debug((Object)MessageFormat.format(this.res.gettingData, string));
            resultSet = preparedStatement.executeQuery();
            tTableObject = new TTableObject();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                TTableRowObject tTableRowObject = new TTableRowObject((Integer)resultSet.getInt(string2));
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    TSqlSelectObject tSqlSelectObject = tSqlSelect.getSqlSelect(resultSetMetaData.getColumnName(i));
                    if (tSqlSelectObject != null) {
                        tTableRowObject.putColumnIdentifier(i - 1, tSqlSelectObject);
                    }
                    tTableRowObject.add(resultSet.getObject(i));
                }
                tTableObject.add(tTableRowObject);
            }
            resultSet.close();
            preparedStatement.close();
            this.commitTransaction();
            resultSet = null;
            preparedStatement = null;
            connection = null;
            log.debug((Object)("Table data fetched in: " + (System.currentTimeMillis() - l) + " ms"));
            return tTableObject;
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(this.res.gettingDataFailed, exception.getMessage());
            log.error((Object)string3, (Throwable)exception);
            throw new MessageException(string3, exception);
        }
    }

    private ITableColumn getColumn(List<ITableColumn> list, String string) {
        if (string == null) {
            return null;
        }
        ITableColumn iTableColumn = null;
        for (ITableColumn iTableColumn2 : list) {
            if (!iTableColumn2.getName().equals(string) && !iTableColumn2.getNameAlias().equals(string)) continue;
            iTableColumn = iTableColumn2;
            break;
        }
        return iTableColumn;
    }

    private class Res {
        private String gettingData;
        private String gettingDataCount;
        private String gettingDataCountFailed;
        private String gettingDataFailed;
        private String gettingDataForRow;
        private String gettingDataForRowFailed;

        private Res() {
        }
    }
}

