/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.database.criterion.Criterion;
import pl.com.stream.echo.lib.event.DetailsTableEvent;
import pl.com.stream.echo.lib.event.DetailsTableListener;
import pl.com.stream.echo.lib.event.PageNavigatorChangeEvent;
import pl.com.stream.echo.lib.event.PageNavigatorChangeListener;
import pl.com.stream.echo.lib.event.SortTableEvent;
import pl.com.stream.echo.lib.event.SortTableListener;
import pl.com.stream.echo.lib.event.StatusEvent;
import pl.com.stream.echo.lib.event.StatusListener;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.TDetailsTableObject;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.TTableColumnList;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.database.DBManager;
import pl.com.stream.echo.lib.util.database.JoinMaker;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataManager
implements Serializable {
    public static final int DEFAULT_MAX_ROWS_PER_PAGE = 100;
    public static final int DEFAULT_MIN_ROWS_PER_PAGE = 10;
    public static final int DEFAULT_ROWS_PER_PAGE = 10;
    private static Logger log = Logger.getLogger(TableDataManager.class);
    private static final long serialVersionUID = -605473065265179874L;
    private final DBManager dbManager;
    private boolean formatSQLQuery;
    private final JoinMaker joinMaker;
    private boolean lockExecuteQuery;
    private Integer maxRowsPerPage;
    private Integer minRowsPerPage;
    private int oldStartRowsFrom;
    private boolean pageCountingEnabled;
    private boolean partialResult;
    private boolean reloadRowsCount;
    @ResourceContainer
    private Res res;
    private int rowsCount = 0;
    private int rowsPerPage;
    private Integer selectedRowId;
    private int startRowsFrom;
    private TTableObject tableObject;
    private EventListenerList listenerList;

    public TableDataManager() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.dbManager = new DBManager();
        this.joinMaker = new JoinMaker();
        this.partialResult = true;
        this.reloadRowsCount = false;
        this.lockExecuteQuery = false;
        this.formatSQLQuery = false;
        this.setPageCountingEnabled(false);
    }

    public void addDetailsTableListener(DetailsTableListener detailsTableListener) {
        this.getEventListenerList().add(DetailsTableListener.class, detailsTableListener);
    }

    public void addPageNavigatorChangeListener(PageNavigatorChangeListener pageNavigatorChangeListener) {
        this.getEventListenerList().add(PageNavigatorChangeListener.class, pageNavigatorChangeListener);
    }

    public void addSortTableListener(SortTableListener sortTableListener) {
        this.getEventListenerList().add(SortTableListener.class, sortTableListener);
    }

    public void addStatusListener(StatusListener statusListener) {
        this.getEventListenerList().add(StatusListener.class, statusListener);
    }

    public void changeCurrentPage(int n) {
        this.oldStartRowsFrom = this.startRowsFrom;
        this.loadTableObject(this.rowsPerPage * n);
    }

    public void changeRowsPerPage(int n) {
        int n2 = this.rowsPerPage;
        this.rowsPerPage = Math.max(this.getMinRowsPerPage(), Math.min(n, this.getMaxRowsPerPage()));
        if (n2 != this.rowsPerPage) {
            this.setReloadRowsCount(true);
            this.loadTableObject(0);
        }
    }

    public void clearSelectedColumnOrderList() {
        this.setSelectedColumnOrderList(new TSelectedTableColumnOrderList());
    }

    public TTableColumnList getAllVisibleColumnList() {
        return this.joinMaker.getAllVisibleColumnList();
    }

    public Integer getMaxRowsPerPage() {
        if (this.maxRowsPerPage == null) {
            this.maxRowsPerPage = 100;
        }
        return this.maxRowsPerPage;
    }

    public Integer getMinRowsPerPage() {
        if (this.minRowsPerPage == null) {
            this.minRowsPerPage = 10;
        }
        return this.minRowsPerPage;
    }

    public int getRowsCount() {
        if (this.isPageCountingEnabled()) {
            if (this.isLockExecuteQuery()) {
                return this.rowsCount;
            }
            if (this.isReloadRowsCount()) {
                try {
                    String string = this.joinMaker.createCountQuery(false, this.formatSQLQuery);
                    this.rowsCount = this.dbManager.getRowNumberFromDBForQuery(string);
                }
                catch (MessageException messageException) {
                    log.error((Object)messageException.getMessage(), (Throwable)messageException);
                }
            }
            return this.rowsCount;
        }
        if (this.tableObject != null) {
            return this.tableObject.size();
        }
        return 0;
    }

    public Integer getRowsPerPage() {
        this.rowsPerPage = Math.max(this.getMinRowsPerPage(), Math.min(this.rowsPerPage, this.getMaxRowsPerPage()));
        return this.rowsPerPage;
    }

    public TSelectedTableColumnOrderList getSelectedColumnOrderList() {
        return this.joinMaker.getSelectedColumnOrderList();
    }

    public TSelectedDetailsColumnList getSelectedDetailsColumnList() {
        return this.joinMaker.getSelectedDetailsColumnList();
    }

    public Integer getSelectedRowId() {
        return this.selectedRowId;
    }

    public TSelectedTableColumnList getSelectedTableColumnList() {
        return this.joinMaker.getSelectedColumnList();
    }

    public TTableColumnList getSortableColumnList() {
        TTableColumnList tTableColumnList = new TTableColumnList();
        TTableColumnList tTableColumnList2 = this.joinMaker.getVisibleTableColumnList();
        for (ITableColumn iTableColumn : tTableColumnList2) {
            if (!iTableColumn.isSortable()) continue;
            tTableColumnList.add(iTableColumn);
        }
        return tTableColumnList;
    }

    public TTableColumnList getVisibleColumnList() {
        return this.joinMaker.getVisibleTableColumnList();
    }

    public TTableColumnList getVisibleDetailsColumnList() {
        return this.joinMaker.getVisibleDetailsColumnList();
    }

    public void initJoinMaker(TJoinTable tJoinTable, TSelectedTableColumnList tSelectedTableColumnList, TSelectedDetailsColumnList tSelectedDetailsColumnList, TSelectedTableColumnOrderList tSelectedTableColumnOrderList, Criterion criterion) {
        this.joinMaker.setMasterTable(tJoinTable);
        this.joinMaker.setSelectedTableColumnList(tSelectedTableColumnList);
        this.joinMaker.setSelectedDetailsColumnList(tSelectedDetailsColumnList);
        this.joinMaker.setSelectedColumnOrderList(tSelectedTableColumnOrderList);
        this.joinMaker.setProgramFilter(criterion);
    }

    public boolean isAdditionalFilterActive() {
        return this.joinMaker.isAdditionalFilterActive();
    }

    public boolean isFaseSearchFilterActive() {
        return this.joinMaker.isFaseSearchFilterActive();
    }

    public boolean isFormatSQLQuery() {
        return this.formatSQLQuery;
    }

    public boolean isLockExecuteQuery() {
        return this.lockExecuteQuery;
    }

    public boolean isPageCountingEnabled() {
        return this.pageCountingEnabled;
    }

    public boolean isPartialResult() {
        return this.partialResult;
    }

    public boolean isReloadRowsCount() {
        return this.reloadRowsCount;
    }

    public boolean isTreeFilterActive() {
        return this.joinMaker.isTreeFilterActive();
    }

    public boolean isWhereProgFilterActive() {
        return this.joinMaker.isWhereProgFilterActive();
    }

    public boolean isWindowFilterActive() {
        return this.joinMaker.isWindowFilterActive();
    }

    public void refresh() {
        this.setReloadRowsCount(true);
        boolean bl = this.isLockExecuteQuery();
        this.setLockExecuteQuery(false);
        this.loadTableObject(0);
        this.setLockExecuteQuery(bl);
    }

    public void refreshCurrentPage() {
        this.setReloadRowsCount(false);
        boolean bl = this.isLockExecuteQuery();
        this.setLockExecuteQuery(false);
        this.loadTableObject(this.startRowsFrom);
        this.setLockExecuteQuery(bl);
    }

    public void removeDetailsTableListener(DetailsTableListener detailsTableListener) {
        this.getEventListenerList().remove(DetailsTableListener.class, detailsTableListener);
    }

    public void removePageNavigatorChangeListener(PageNavigatorChangeListener pageNavigatorChangeListener) {
        this.getEventListenerList().remove(PageNavigatorChangeListener.class, pageNavigatorChangeListener);
    }

    public void removeSortTableListener(SortTableListener sortTableListener) {
        this.getEventListenerList().remove(SortTableListener.class, sortTableListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.getEventListenerList().remove(StatusListener.class, statusListener);
    }

    public void setAdditionalFilter(Criterion criterion) {
        this.setAdditionalFilter(criterion, null);
    }

    public void setAdditionalFilter(Criterion criterion, String string) {
        this.setReloadRowsCount(true);
        this.joinMaker.setAdditionalFilter(criterion);
        this.loadTableObject(0);
        this.setStatus(criterion == null ? null : string, StatusEvent.StatusType.statusUrzadzenia);
    }

    public void setFastSearchFilter(Criterion criterion) {
        this.setFastSearchFilter(criterion, null);
    }

    public void setFastSearchFilter(Criterion criterion, String string) {
        this.setReloadRowsCount(true);
        this.joinMaker.setFastSearchFilter(criterion);
        this.loadTableObject(0);
        this.setStatus(criterion == null ? null : string, StatusEvent.StatusType.statusSzybkiegoFiltru);
    }

    public void setFormatSQLQuery(boolean bl) {
        this.formatSQLQuery = bl;
    }

    public void setLockExecuteQuery(boolean bl) {
        this.lockExecuteQuery = bl;
    }

    public void setMasterTable(TJoinTable tJoinTable) {
        this.joinMaker.setMasterTable(tJoinTable);
        this.setReloadRowsCount(true);
        this.loadTableObject(0);
        this.joinMaker.setMasterTableChanged(false);
    }

    public void setMaxRowsPerPage(Integer n) {
        this.maxRowsPerPage = n;
    }

    public void setMinRowsPerPage(Integer n) {
        this.minRowsPerPage = n;
    }

    public void setPageCountingEnabled(boolean bl) {
        this.pageCountingEnabled = bl;
    }

    public void setPartialResult(boolean bl) {
        this.partialResult = bl;
    }

    public void setProgramFilter(Criterion criterion) {
        this.joinMaker.setProgramFilter(criterion);
    }

    public void setReloadRowsCount(boolean bl) {
        this.reloadRowsCount = bl;
    }

    public void setRowsPerPage(int n) {
        this.rowsPerPage = Math.max(this.getMinRowsPerPage(), Math.min(n, this.getMaxRowsPerPage()));
    }

    public void setSelectedColumnOrderList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.joinMaker.setSelectedColumnOrderList(tSelectedTableColumnOrderList);
        this.fireTableColumnOrderChanged(tSelectedTableColumnOrderList);
        this.loadTableObject(0);
    }

    public void setSelectedDetailsColumnList(TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        this.joinMaker.setSelectedDetailsColumnList(tSelectedDetailsColumnList);
    }

    public void setSelectedRowId(Integer n) {
        this.selectedRowId = n;
        this.putDataInToDetailsTable(this.selectedRowId);
    }

    public void setSelectedTableColumnList(TSelectedTableColumnList tSelectedTableColumnList) {
        this.joinMaker.setSelectedTableColumnList(tSelectedTableColumnList);
    }

    public void setStatus(String string, StatusEvent.StatusType statusType) {
        this.fireStatusChanged(statusType, string);
    }

    public void setTreeFilter(Criterion criterion) {
        this.setTreeFilter(criterion, null);
    }

    public void setTreeFilter(Criterion criterion, String string) {
        this.setReloadRowsCount(true);
        this.joinMaker.setTreeFilter(criterion);
        this.loadTableObject(0);
        this.setStatus(criterion == null ? null : string, StatusEvent.StatusType.statusDrzewa);
    }

    public void setVisibleColumnList(List<?> list) {
        this.joinMaker.setSelectedTableColumnListFromVisibleColumnList(list);
        this.joinMaker.setWindowFilter(null);
        this.joinMaker.setSelectedColumnOrderList(new TSelectedTableColumnOrderList());
        this.fireTableVisibleColumnsChanged(this.getVisibleColumnList());
        this.fireTableColumnOrderChanged(new TSelectedTableColumnOrderList());
        this.loadTableObject(0);
    }

    public void setVisibleColumnListForSingleRow(List<?> list) {
        this.joinMaker.setSelectedDetailsColumnListFromVisibleColumnList(list);
        this.putDataInToDetailsTable(this.selectedRowId);
    }

    public void setWindowFilter(Criterion criterion) {
        this.setWindowFilter(criterion, null);
    }

    public void setWindowFilter(Criterion criterion, String string) {
        this.setReloadRowsCount(true);
        this.joinMaker.setWindowFilter(criterion);
        this.loadTableObject(0);
        if (string == null) {
            string = this.res.activeFilter;
        }
        this.setStatus(criterion == null ? null : string, StatusEvent.StatusType.statusFiltru);
    }

    private void fireDataChanged(TTableObject tTableObject) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(SortTableListener.class);
        SortTableEvent sortTableEvent = null;
        sortTableEvent = new SortTableEvent(this);
        sortTableEvent.setTableObject(tTableObject);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((SortTableListener)eventListenerArray[i]).tableObjectChanged(sortTableEvent);
        }
    }

    private void fireDetailsTableObjectChanged(Integer n, List<TDetailsTableObject> list) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(DetailsTableListener.class);
        DetailsTableEvent detailsTableEvent = null;
        detailsTableEvent = new DetailsTableEvent(this, n, list);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((DetailsTableListener)eventListenerArray[i]).detailsChanged(detailsTableEvent);
        }
    }

    private void fireDetailsTableObjectChanged(List<TDetailsTableObject> list) {
        this.fireDetailsTableObjectChanged(null, list);
    }

    private void firePageNavigatorChanged(int n, int n2, boolean bl, boolean bl2) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(PageNavigatorChangeListener.class);
        PageNavigatorChangeEvent pageNavigatorChangeEvent = new PageNavigatorChangeEvent(this, n, n2, bl, bl2);
        for (EventListener eventListener : eventListenerArray) {
            ((PageNavigatorChangeListener)eventListener).pageIndexChanged(pageNavigatorChangeEvent);
        }
    }

    private void fireStatusChanged(StatusEvent.StatusType statusType, String string) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(StatusListener.class);
        StatusEvent statusEvent = null;
        statusEvent = new StatusEvent(this, string, statusType);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((StatusListener)eventListenerArray[i]).statusChanged(statusEvent);
        }
    }

    private void fireTableColumnOrderChanged(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(SortTableListener.class);
        SortTableEvent sortTableEvent = null;
        sortTableEvent = new SortTableEvent(this);
        sortTableEvent.setColumnOrderList(tSelectedTableColumnOrderList);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((SortTableListener)eventListenerArray[i]).columnOrderChanged(sortTableEvent);
        }
    }

    private void fireTableVisibleColumnsChanged(TTableColumnList tTableColumnList) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(SortTableListener.class);
        SortTableEvent sortTableEvent = null;
        sortTableEvent = new SortTableEvent(this);
        sortTableEvent.setVisibleColumnList(tTableColumnList);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((SortTableListener)eventListenerArray[i]).tableVisibleColumnsChanged(sortTableEvent);
        }
    }

    private int getTotalPages(int n, int n2) {
        int n3 = 1;
        n3 = n <= n2 ? 1 : (n % n2 == 0 ? n / n2 : new BigDecimal(n).divide(new BigDecimal(n2), RoundingMode.UP).intValue());
        return n3;
    }

    private void loadTableObject(int n) {
        if (this.isLockExecuteQuery()) {
            return;
        }
        String string = this.joinMaker.createQuery(false, this.isPartialResult(), this.getRowsPerPage(), n, this.formatSQLQuery);
        TTableObject tTableObject = null;
        try {
            tTableObject = this.dbManager.getTableObjectFromDB(string, this.joinMaker.getMasterTableIdColumnName(), this.joinMaker.getSelectForTable());
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
        if (tTableObject == null) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getRowsPerPage();
        int n5 = 1;
        if (this.isPageCountingEnabled()) {
            this.startRowsFrom = n;
            this.tableObject = tTableObject;
            n3 = this.getRowsCount();
            this.fireDataChanged(tTableObject);
            n5 = this.getTotalPages(n3, n4);
            if (this.startRowsFrom > 0) {
                n2 = new BigDecimal(this.startRowsFrom).divide(new BigDecimal(n4), RoundingMode.HALF_UP).intValue();
            }
            if (n2 >= n5 - 1) {
                bl = false;
            }
        } else {
            n3 = tTableObject.size();
            if (n3 == 0 && n > this.oldStartRowsFrom) {
                this.startRowsFrom = this.oldStartRowsFrom;
                if (this.startRowsFrom > 0) {
                    n2 = new BigDecimal(this.startRowsFrom).divide(new BigDecimal(n4), RoundingMode.HALF_UP).intValue();
                }
                bl = false;
            } else {
                this.startRowsFrom = n;
                this.tableObject = tTableObject;
                this.fireDataChanged(tTableObject);
                if (this.startRowsFrom > 0) {
                    n2 = new BigDecimal(this.startRowsFrom).divide(new BigDecimal(n4), RoundingMode.HALF_UP).intValue();
                }
                if (n3 < n4) {
                    bl = false;
                }
            }
            n5 = n2;
        }
        this.firePageNavigatorChanged(n2, n5, bl, this.isPageCountingEnabled());
        this.setReloadRowsCount(false);
    }

    private void putDataInToDetailsTable(Integer n) {
        if (this.isLockExecuteQuery()) {
            return;
        }
        if (n != null) {
            if (this.getVisibleDetailsColumnList().size() > 0) {
                String string = this.joinMaker.createQueryForSingleRow(n, this.formatSQLQuery);
                ArrayList<TDetailsTableObject> arrayList = null;
                try {
                    arrayList = this.dbManager.getDetailsForSelectedRowFromDB(string, this.getVisibleDetailsColumnList(), this.joinMaker.getSelectForDetails());
                }
                catch (MessageException messageException) {
                    log.error((Object)messageException.getMessage(), (Throwable)messageException);
                }
                this.fireDetailsTableObjectChanged(n, arrayList);
            } else {
                this.fireDetailsTableObjectChanged(null);
            }
        } else {
            this.fireDetailsTableObjectChanged(null);
        }
    }

    protected EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    private class Res {
        private String activeFilter;

        private Res() {
        }
    }
}

