/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.annotanion.LoadProperty;
import pl.com.stream.echo.lib.type.annotanion.SaveProperty;
import pl.com.stream.echo.lib.type.persistance.PersistanceClass;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.PersistanceManager;
import pl.com.stream.echo.lib.util.XmlSource;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyManager
implements Serializable {
    private static Logger log = Logger.getLogger(PropertyManager.class);
    private static final long serialVersionUID = 4045208127053416906L;
    private DocumentBuilder builder;
    @ResourceContainer
    private Res res;
    private XmlSource xmlSource;

    public PropertyManager() {
        this(null);
    }

    public PropertyManager(XmlSource xmlSource) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.initDocumentBuilder();
        this.setXmlSource(xmlSource);
    }

    public XmlSource getXmlSource() {
        return this.xmlSource;
    }

    public void loadProperties(Object object) throws MessageException {
        this.loadProperties(object, null);
    }

    public void loadProperties(Object object, Class<? extends Object> clazz) throws MessageException {
        if (this.xmlSource == null) {
            return;
        }
        if (object == null) {
            return;
        }
        Document document = this.xmlSource.loadDocument(clazz == null ? object.getClass() : clazz);
        this.fillObjectProperties(object, document);
    }

    public void loadProperties(Object object, String string, String string2) throws MessageException {
        if (this.xmlSource == null) {
            return;
        }
        if (object == null) {
            return;
        }
        Document document = null;
        document = string == null || string2 == null ? this.xmlSource.loadDocument(object.getClass()) : this.xmlSource.loadDocument(string, string2);
        this.fillObjectProperties(object, document);
    }

    public void saveProperties(Object object) throws MessageException {
        this.saveProperties(object, null);
    }

    public void saveProperties(Object object, Class<? extends Object> clazz) throws MessageException {
        if (this.xmlSource == null) {
            return;
        }
        if (object == null) {
            return;
        }
        Document document = this.objectToXmlDocument(object);
        this.xmlSource.saveDocument(document, clazz == null ? object.getClass() : clazz);
    }

    public void saveProperties(Object object, String string, String string2) throws MessageException {
        if (this.xmlSource == null) {
            return;
        }
        if (object == null) {
            return;
        }
        Document document = this.objectToXmlDocument(object);
        if (string == null || string2 == null) {
            this.xmlSource.saveDocument(document, object.getClass());
        } else {
            this.xmlSource.saveDocument(document, string, string2);
        }
    }

    public void setXmlSource(XmlSource xmlSource) {
        this.xmlSource = xmlSource;
    }

    private void fillObjectProperties(Object object, Document document) throws MessageException {
        if (document == null) {
            return;
        }
        try {
            Class<?> clazz = object.getClass();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            NodeList nodeList = (NodeList)xPath.evaluate("/" + clazz.getSimpleName() + "-properties/property", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                hashMap.put(element.getAttribute("name"), element);
            }
            if (hashMap.size() <= 0) {
                return;
            }
            for (Method method : clazz.getMethods()) {
                Element element;
                if (!method.isAnnotationPresent(LoadProperty.class) || (element = (Element)hashMap.get(method.getAnnotation(LoadProperty.class).propertyName())) == null) continue;
                Object object2 = new Object();
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new IllegalArgumentException(MessageFormat.format(this.res.onlyOneParameterAllowed, method.getName(), LoadProperty.class.getName()));
                }
                Class<PersistanceClass<?>> clazz2 = PersistanceManager.getPersistanceClass(classArray[0]);
                if (clazz2 == null) {
                    throw new NullPointerException(MessageFormat.format(this.res.persistanceClassNotFound, classArray[0].getName()));
                }
                PersistanceClass<?> persistanceClass = clazz2.newInstance();
                persistanceClass.setDocument(document);
                persistanceClass.setElementName(method.getAnnotation(LoadProperty.class).propertyName());
                object2 = persistanceClass.getPropertiesFromElement(element);
                method.invoke(object, object2);
            }
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
    }

    private void initDocumentBuilder() {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.error((Object)parserConfigurationException);
            }
        }
    }

    private Document objectToXmlDocument(Object object) throws MessageException {
        Class<?> clazz = object.getClass();
        Document document = this.builder.newDocument();
        Element element = document.createElement(clazz.getSimpleName() + "-properties");
        element.setAttribute("version", "0");
        try {
            for (Method method : clazz.getMethods()) {
                Object object2;
                if (!method.isAnnotationPresent(SaveProperty.class) || (object2 = method.invoke(object, (Object[])null)) == null) continue;
                Class<PersistanceClass<?>> clazz2 = PersistanceManager.getPersistanceClass(object2.getClass());
                if (clazz2 == null) {
                    throw new NullPointerException(MessageFormat.format(this.res.persistanceClassNotFound, object2.getClass().getName()));
                }
                PersistanceClass<?> persistanceClass = clazz2.newInstance();
                persistanceClass.setDocument(document);
                persistanceClass.setOwner(object2);
                persistanceClass.setElementName(method.getAnnotation(SaveProperty.class).propertyName());
                Element element2 = persistanceClass.getElement();
                if (element2 == null) continue;
                element.appendChild(element2);
            }
            document.appendChild(element);
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
        return document;
    }

    private class Res {
        private String onlyOneParameterAllowed;
        private String persistanceClassNotFound;

        private Res() {
        }
    }
}

