/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.util;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.XmlSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileXmlSource
implements XmlSource {
    private DocumentBuilder builder;
    private String xmlFolder;
    private static Logger log = Logger.getLogger(FileXmlSource.class);

    public FileXmlSource(String string) {
        this.xmlFolder = string;
        this.initDocumentBuilder();
    }

    @Override
    public Document loadDocument(Class<? extends Object> clazz) throws MessageException {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getPackage().getName();
        String string2 = clazz.getSimpleName();
        return this.loadDocument(string, string2);
    }

    @Override
    public Document loadDocument(String string, String string2) throws MessageException {
        Document document = null;
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        try {
            File file = this.getXmlFile(string, string2);
            if (file.exists()) {
                document = this.builder.parse(file);
            }
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
        return document;
    }

    @Override
    public void saveDocument(Document document, Class<? extends Object> clazz) throws MessageException {
        if (clazz == null) {
            return;
        }
        String string = clazz.getPackage().getName();
        String string2 = clazz.getSimpleName();
        this.saveDocument(document, string, string2);
    }

    @Override
    public void saveDocument(Document document, String string, String string2) throws MessageException {
        if (document == null) {
            return;
        }
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(this.getXmlFile(string, string2)));
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
    }

    public void setXmlFolder(String string) {
        this.xmlFolder = string;
    }

    private File getXmlFile(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        stringBuffer.append(".xml");
        File file = new File(this.getXmlTempFolder(), stringBuffer.toString());
        return file;
    }

    private File getXmlTempFolder() {
        File file = new File(this.xmlFolder);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private void initDocumentBuilder() {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.error((Object)parserConfigurationException);
            }
        }
    }
}

