/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.ui.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.io.IOUtils;
import pl.com.stream.echo.lib.ui.fileupload.DeferredOutputStream;
import pl.com.stream.echo.lib.ui.fileupload.StrFileItem;

public class ZipUploadFileItem
implements StrFileItem {
    private static final long serialVersionUID = 8686541761516076314L;
    public static final String DEFAULT_CHARSET = "ISO-8859-2";
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private long size = -1L;
    private int sizeThreshold;
    private byte[] cachedContent;
    private transient DeferredOutputStream dfos;
    private File storeFile;
    private boolean cleanOnExit = false;
    private ZipEntry zipEntry;

    public ZipUploadFileItem(String string, String string2, boolean bl, String string3, String string4, int n, File file, boolean bl2) {
        this.fieldName = string;
        this.contentType = string2;
        this.isFormField = bl;
        this.fileName = string3;
        this.zipEntry = string4 == null ? null : new ZipEntry(string4);
        this.sizeThreshold = n;
        this.cleanOnExit = bl2;
        this.storeFile = new File(file, string3);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new ZipInputStream(new FileInputStream(this.getStoreLocation()));
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parameterParser = new ParameterParser();
        parameterParser.setLowerCaseNames(true);
        Map map = parameterParser.parse(this.getContentType(), ';');
        return (String)map.get("charset");
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.storeFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        byte[] byArray = new byte[(int)this.getSize()];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.getStoreLocation()));
            byte[] byArray2 = new byte[4096];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry != null && !zipEntry.isDirectory()) {
                int n;
                while ((n = zipInputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            byArray = null;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public String getString(String string) throws UnsupportedEncodingException {
        return new String(this.get(), string);
    }

    public String getString() {
        byte[] byArray = this.get();
        String string = this.getCharSet();
        if (string == null) {
            string = DEFAULT_CHARSET;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.get());
                return;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        File file2 = this.getStoreLocation();
        if (file2 == null) throw new FileUploadException("Cannot write uploaded file to disk!");
        this.size = file2.length();
        FilterOutputStream filterOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getStoreLocation())));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null || zipEntry.isDirectory()) return;
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)filterOutputStream);
            return;
        }
        finally {
            try {
                filterOutputStream.close();
            }
            catch (IOException iOException) {}
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    public void delete() {
        this.cachedContent = null;
        File file = this.getStoreLocation();
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public File getFile() {
        return this.storeFile;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean bl) {
        this.isFormField = bl;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            OutputStream outputStream = null;
            if (this.zipEntry != null) {
                CheckedOutputStream checkedOutputStream = new CheckedOutputStream(new FileOutputStream(this.getStoreLocation()), new Adler32());
                ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(checkedOutputStream));
                zipOutputStream.putNextEntry(this.zipEntry);
                outputStream = zipOutputStream;
            } else {
                outputStream = new FileOutputStream(this.getStoreLocation());
            }
            this.dfos = new DeferredOutputStream(this.sizeThreshold, outputStream);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.storeFile;
    }

    protected void finalize() {
        File file = this.getStoreLocation();
        if (file != null && file.exists() && this.cleanOnExit) {
            file.delete();
        }
    }

    public String toString() {
        return "name=" + this.getName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, " + "isFormField=" + this.isFormField() + ", FieldName=" + this.getFieldName();
    }
}

