/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.ui.fileupload;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class DeferredOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private final OutputStream outputStream;

    public DeferredOutputStream(int n, OutputStream outputStream) {
        super(n);
        this.outputStream = outputStream;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        this.memoryOutputStream.writeTo(this.outputStream);
        this.currentOutputStream = this.outputStream;
        this.memoryOutputStream = null;
    }
}

