/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import pl.com.stream.echo.lib.type.TJoinColumn;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumn;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumn;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.sql.TSqlSelectObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSqlSelect
extends ArrayList<TSqlSelectObject> {
    private static final long serialVersionUID = -649809334798103682L;
    private int nextColumnIndex = -1;

    public TSqlSelect(TJoinTable tJoinTable, TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        if (tSelectedDetailsColumnList != null) {
            this.nextColumnIndex = tSelectedDetailsColumnList.size();
        }
        this.fillSelectList(tJoinTable, tSelectedDetailsColumnList);
        this.sort();
    }

    public TSqlSelect(TJoinTable tJoinTable, TSelectedTableColumnList tSelectedTableColumnList) {
        if (tSelectedTableColumnList != null) {
            this.nextColumnIndex = tSelectedTableColumnList.size();
        }
        this.fillSelectList(tJoinTable, tSelectedTableColumnList);
        this.sort();
    }

    public TSqlSelectObject getSqlSelect(String string) {
        if (string == null) {
            return null;
        }
        for (TSqlSelectObject tSqlSelectObject : this) {
            if (!(tSqlSelectObject.getAsColumnName() != null ? tSqlSelectObject.getAsColumnName().equals(string) : tSqlSelectObject.getOrginalColumnName().equals(string))) continue;
            return tSqlSelectObject;
        }
        return null;
    }

    public String toSqlString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            TSqlSelectObject tSqlSelectObject = (TSqlSelectObject)this.get(i);
            if (bl) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(tSqlSelectObject);
            if (i == this.size() - 1) continue;
            stringBuffer.append(",");
            if (!bl) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            TSqlSelectObject tSqlSelectObject = (TSqlSelectObject)this.get(i);
            stringBuffer.append(tSqlSelectObject);
            if (i == this.size() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void fillSelectList(TJoinTable tJoinTable, TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        if (tJoinTable == null) {
            return;
        }
        if (tJoinTable.getColumns() != null) {
            Enumeration enumeration = tJoinTable.getColumns().elements();
            while (enumeration.hasMoreElements()) {
                Object object = (TJoinColumn)enumeration.nextElement();
                int n = -1;
                n = this.isColumnSelected((TJoinColumn)object, tSelectedDetailsColumnList);
                if (n == -1) continue;
                this.add(new TSqlSelectObject(((TJoinColumn)object).getOwner().getTableAlias(), ((TJoinColumn)object).getOrgNazwaPola(), ((TJoinColumn)object).getNazwaPola(), n));
            }
        }
        if (tJoinTable.getJoinTables() != null) {
            for (Object object : tJoinTable.getJoinTables()) {
                this.fillSelectList((TJoinTable)object, tSelectedDetailsColumnList);
            }
        }
    }

    private void fillSelectList(TJoinTable tJoinTable, TSelectedTableColumnList tSelectedTableColumnList) {
        if (tJoinTable == null) {
            return;
        }
        if (tJoinTable.getJoinType().equals((Object)TJoinTable.JoinTypes.jtMaster)) {
            this.add(new TSqlSelectObject(tJoinTable.getTableAlias(), tJoinTable.getJoinColumn(), null, this.nextColumnIndex++));
        }
        if (tJoinTable.getColumns() != null) {
            Enumeration enumeration = tJoinTable.getColumns().elements();
            while (enumeration.hasMoreElements()) {
                Object object = (TJoinColumn)enumeration.nextElement();
                int n = -1;
                n = this.isColumnSelected((TJoinColumn)object, tSelectedTableColumnList);
                if (n != -1) {
                    this.add(new TSqlSelectObject(((TJoinColumn)object).getOwner().getTableAlias(), ((TJoinColumn)object).getOrgNazwaPola(), ((TJoinColumn)object).getNazwaPola(), n));
                    continue;
                }
                if (!((TJoinColumn)object).isRequired()) continue;
                this.add(new TSqlSelectObject(((TJoinColumn)object).getOwner().getTableAlias(), ((TJoinColumn)object).getOrgNazwaPola(), ((TJoinColumn)object).getNazwaPola(), this.nextColumnIndex++));
            }
        }
        if (tJoinTable.getJoinTables() != null) {
            for (Object object : tJoinTable.getJoinTables()) {
                this.fillSelectList((TJoinTable)object, tSelectedTableColumnList);
            }
        }
    }

    private int isColumnSelected(TJoinColumn tJoinColumn, TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        if (tSelectedDetailsColumnList != null) {
            for (TSelectedDetailsColumn tSelectedDetailsColumn : tSelectedDetailsColumnList) {
                if (!tSelectedDetailsColumn.equals(tJoinColumn)) continue;
                return tSelectedDetailsColumn.getColumnNumber();
            }
        }
        return -1;
    }

    private int isColumnSelected(TJoinColumn tJoinColumn, TSelectedTableColumnList tSelectedTableColumnList) {
        if (tSelectedTableColumnList != null) {
            for (TSelectedTableColumn tSelectedTableColumn : tSelectedTableColumnList) {
                if (!tSelectedTableColumn.equals(tJoinColumn)) continue;
                return tSelectedTableColumn.getColumnNumber();
            }
        }
        return -1;
    }

    private void sort() {
        SelectColumnComparator selectColumnComparator = new SelectColumnComparator();
        Collections.sort(this, selectColumnComparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectColumnComparator
    implements Comparator<TSqlSelectObject> {
        private SelectColumnComparator() {
        }

        @Override
        public int compare(TSqlSelectObject tSqlSelectObject, TSqlSelectObject tSqlSelectObject2) {
            if (tSqlSelectObject.getColumnNumber() == tSqlSelectObject2.getColumnNumber()) {
                return 0;
            }
            if (tSqlSelectObject.getColumnNumber() > tSqlSelectObject2.getColumnNumber()) {
                return 1;
            }
            if (tSqlSelectObject.getColumnNumber() < tSqlSelectObject2.getColumnNumber()) {
                return -1;
            }
            return 0;
        }
    }
}

