/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type.sql;

import pl.com.stream.echo.lib.type.TJoinTable;

public class TSqlFromObject {
    private final TJoinTable.JoinTypes joinType;
    private final String tableAlias;
    private final String tableName;
    private final String tableJoinColumn;
    private String ownerTableAlias;
    private final String ownerTableJoinColumn;
    private final String tableWhere;

    public TSqlFromObject(TJoinTable.JoinTypes joinTypes, String string, String string2, String string3, String string4, String string5, String string6) {
        this.joinType = joinTypes;
        this.tableAlias = string;
        this.tableName = string2;
        this.tableJoinColumn = string3;
        this.ownerTableAlias = string4;
        this.ownerTableJoinColumn = string5;
        this.tableWhere = string6;
    }

    public TSqlFromObject(TJoinTable tJoinTable) {
        this.joinType = tJoinTable.getJoinType();
        this.tableAlias = tJoinTable.getTableAlias();
        this.tableName = tJoinTable.getTableName();
        this.tableJoinColumn = tJoinTable.getJoinColumn();
        if (tJoinTable.getOwner() != null) {
            this.ownerTableAlias = tJoinTable.getOwner().getTableAlias();
        }
        this.ownerTableJoinColumn = tJoinTable.getOwnerJoinColumn();
        this.tableWhere = tJoinTable.getTableWhere();
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableJoinColumn() {
        return this.tableJoinColumn;
    }

    public boolean isMasterTable() {
        return this.joinType.equals((Object)TJoinTable.JoinTypes.jtMaster);
    }

    public String toSqlString(boolean bl) {
        String string = null;
        switch (this.joinType) {
            case jtMaster: {
                string = "";
                break;
            }
            case jtInner: {
                string = "INNER JOIN ";
                break;
            }
            case jtLeftOuter: {
                string = "LEFT OUTER JOIN ";
                break;
            }
            case jtRightOuter: {
                string = "RIGHT OUTER JOIN ";
                break;
            }
            case jtFullOuter: {
                string = "FULL OUTER JOIN ";
                break;
            }
            default: {
                string = "";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.joinType.equals((Object)TJoinTable.JoinTypes.jtMaster)) {
            stringBuffer.append(this.tableName).append(" ");
            stringBuffer.append(this.tableAlias);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(this.tableName).append(" ");
            stringBuffer.append(this.tableAlias).append(" ");
            stringBuffer.append("ON (");
            stringBuffer.append(this.tableAlias);
            stringBuffer.append(".");
            stringBuffer.append(this.tableJoinColumn);
            stringBuffer.append(" = ");
            stringBuffer.append(this.ownerTableAlias);
            stringBuffer.append(".");
            stringBuffer.append(this.ownerTableJoinColumn);
            if (this.tableWhere != null) {
                if (bl) {
                    stringBuffer.append("\n\t\t");
                }
                stringBuffer.append(" AND ");
                stringBuffer.append(this.tableWhere);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = null;
        switch (this.joinType) {
            case jtMaster: {
                string = "";
                break;
            }
            case jtInner: {
                string = "INNER JOIN ";
                break;
            }
            case jtLeftOuter: {
                string = "LEFT OUTER JOIN ";
                break;
            }
            case jtRightOuter: {
                string = "RIGHT OUTER JOIN ";
                break;
            }
            case jtFullOuter: {
                string = "FULL OUTER JOIN ";
                break;
            }
            default: {
                string = "";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.joinType.equals((Object)TJoinTable.JoinTypes.jtMaster)) {
            stringBuffer.append(this.tableName);
            stringBuffer.append(" ");
            stringBuffer.append(this.tableAlias);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(this.tableName);
            stringBuffer.append(" ");
            stringBuffer.append(this.tableAlias);
            stringBuffer.append(" ON (");
            stringBuffer.append(this.tableAlias);
            stringBuffer.append(".");
            stringBuffer.append(this.tableJoinColumn);
            stringBuffer.append(" = ");
            stringBuffer.append(this.ownerTableAlias);
            stringBuffer.append(".");
            stringBuffer.append(this.ownerTableJoinColumn);
            if (this.tableWhere != null) {
                stringBuffer.append(" AND ");
                stringBuffer.append(this.tableWhere);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

