/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type.sql;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import pl.com.stream.echo.lib.type.TJoinColumn;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.sql.TSqlFromObject;
import pl.com.stream.echo.lib.type.sql.TSqlSelect;
import pl.com.stream.echo.lib.type.sql.TSqlSelectObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSqlFrom
extends ArrayList<TSqlFromObject> {
    private static final long serialVersionUID = 1513031597573209277L;
    private final TSqlSelect selectedColumns;

    public TSqlFrom(TJoinTable tJoinTable, TSqlSelect tSqlSelect) {
        this.selectedColumns = tSqlSelect;
        this.fillSqlFromList(tJoinTable);
    }

    public TSqlFromObject getMasterTable() {
        TSqlFromObject tSqlFromObject = null;
        for (int i = 0; i < this.size(); ++i) {
            TSqlFromObject tSqlFromObject2 = (TSqlFromObject)this.get(i);
            if (!tSqlFromObject2.isMasterTable()) continue;
            tSqlFromObject = tSqlFromObject2;
            break;
        }
        return tSqlFromObject;
    }

    public String toSqlString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            TSqlFromObject tSqlFromObject = (TSqlFromObject)this.get(i);
            if (tSqlFromObject.isMasterTable()) {
                stringBuffer.append(bl ? "" : " ");
            } else {
                stringBuffer.append(bl ? "\n\t" : " ");
            }
            stringBuffer.append(tSqlFromObject.toSqlString(bl));
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            TSqlFromObject tSqlFromObject = (TSqlFromObject)this.get(i);
            stringBuffer.append(tSqlFromObject);
            if (i == this.size() - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private boolean childNeedParent(TJoinTable tJoinTable) {
        Iterator iterator;
        TJoinTable tJoinTable2 = tJoinTable.getOwner();
        if (tJoinTable2 == null) {
            return false;
        }
        if (this.isJoinTableIncludeSelectedColumns(tJoinTable, this.selectedColumns)) {
            return true;
        }
        if (tJoinTable.getJoinTables() != null && (iterator = tJoinTable.getJoinTables().iterator()).hasNext()) {
            TJoinTable tJoinTable3 = (TJoinTable)iterator.next();
            return this.childNeedParent(tJoinTable3);
        }
        return false;
    }

    private void fillSqlFromList(TJoinTable tJoinTable) {
        if (tJoinTable != null) {
            if (tJoinTable.getJoinType().equals((Object)TJoinTable.JoinTypes.jtMaster) || this.childNeedParent(tJoinTable) || tJoinTable.isRequired()) {
                this.add(new TSqlFromObject(tJoinTable));
            }
            if (tJoinTable.getJoinTables() != null) {
                for (TJoinTable tJoinTable2 : tJoinTable.getJoinTables()) {
                    this.fillSqlFromList(tJoinTable2);
                }
            }
        }
    }

    private boolean isJoinTableIncludeSelectedColumns(TJoinTable tJoinTable, TSqlSelect tSqlSelect) {
        if (tJoinTable == null) {
            return false;
        }
        if (tJoinTable.getColumns() == null) {
            return false;
        }
        if (tJoinTable.getColumns().size() == 0) {
            return false;
        }
        Enumeration enumeration = tJoinTable.getColumns().elements();
        while (enumeration.hasMoreElements()) {
            TJoinColumn tJoinColumn = (TJoinColumn)enumeration.nextElement();
            for (TSqlSelectObject tSqlSelectObject : tSqlSelect) {
                if (!tSqlSelectObject.equals(tJoinColumn)) continue;
                return true;
            }
        }
        return false;
    }
}

