/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type.dao;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;

public class XmlPropertiesDAO
extends HibernateSessionProvider {
    private static Logger log = Logger.getLogger(XmlPropertiesDAO.class);
    private static final long serialVersionUID = -3132902675517770189L;
    private DocumentBuilder builder;
    @ResourceContainer
    private Res res;

    public XmlPropertiesDAO() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initDocumentBuilder();
    }

    public Document get(Integer n, Integer n2, String string, String string2) throws MessageException {
        Document document = null;
        try {
            String string3 = "SELECT prop.PROPERTIES FROM J_PROPKLASA prop WHERE prop.ID_J_PODMIOT = ? AND prop.ID_J_APLIKACJA = ? AND prop.ID_J_KLASA = (SELECT klas.ID_J_KLASA FROM J_KLASA klas WHERE klas.PAKIET = ? AND klas.KLASA = ?)";
            log.debug((Object)MessageFormat.format(this.res.gettingXmlDocument, n, n2, string, string2));
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(resultSet.getBinaryStream(1));
                document = this.builder.parse(bufferedInputStream);
                resultSet.close();
            }
            preparedStatement.close();
            this.commitTransaction();
            return document;
        }
        catch (Exception exception) {
            String string4 = MessageFormat.format(this.res.gettingXmlDocumentFailed, exception.getMessage());
            log.error((Object)string4, (Throwable)exception);
            this.rollbackTransaction();
            throw new MessageException(string4, exception);
        }
    }

    public void save(Document document, Integer n, Integer n2, String string, String string2) throws MessageException {
        try {
            log.debug((Object)MessageFormat.format(this.res.savingXmlDocument, n, n2, string, string2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            CallableStatement callableStatement = connection.prepareCall("{call J_PROPKLASA_ZAPISZ(?,?,?,?,?)}");
            callableStatement.setInt(1, (int)n);
            callableStatement.setInt(2, (int)n2);
            callableStatement.setString(3, string);
            callableStatement.setString(4, string2);
            callableStatement.setBinaryStream(5, (InputStream)byteArrayInputStream, byArray.length);
            callableStatement.execute();
            callableStatement.close();
            this.commitTransaction();
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(this.res.savingXmlDocumentFailed, exception.getMessage());
            log.error((Object)string3, (Throwable)exception);
            this.rollbackTransaction();
            throw new MessageException(string3, exception);
        }
    }

    private void initDocumentBuilder() {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.error((Object)parserConfigurationException);
            }
        }
    }

    private class Res {
        private String gettingXmlDocument;
        private String gettingXmlDocumentFailed;
        private String savingXmlDocument;
        private String savingXmlDocumentFailed;

        private Res() {
        }
    }
}

