/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type;

import java.util.ArrayList;
import java.util.Collections;
import pl.com.stream.echo.lib.type.TFieldDef;
import pl.com.stream.echo.lib.type.TJoinColumn;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumn;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumn;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.TTableDef;
import pl.com.stream.echo.lib.type.column.DefaultTableColumn;
import pl.com.stream.echo.lib.type.column.ILabeledColumn;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.database.DBStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTableColumnList
extends ArrayList<ITableColumn> {
    private static final long serialVersionUID = 2545941120875827078L;

    public TTableColumnList() {
        this((TJoinTable)null);
    }

    public TTableColumnList(TJoinTable tJoinTable) {
        this(tJoinTable, (TSelectedTableColumnList)null);
    }

    public TTableColumnList(TJoinTable tJoinTable, TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        if (tJoinTable != null && tSelectedDetailsColumnList != null) {
            this.fillVisibleColumnList(tJoinTable, tSelectedDetailsColumnList);
            Collections.sort(this, new ITableColumn.ColumnNumberComparator());
        }
    }

    public TTableColumnList(TJoinTable tJoinTable, TSelectedTableColumnList tSelectedTableColumnList) {
        if (tJoinTable != null) {
            if (tSelectedTableColumnList != null) {
                this.fillVisibleColumnList(tJoinTable, tSelectedTableColumnList);
                Collections.sort(this, new ITableColumn.ColumnNumberComparator());
            } else {
                this.fillVisibleColumnList(tJoinTable);
                Collections.sort(this, new ILabeledColumn.ColumnLabelComparator());
            }
        }
    }

    public void addColumn(ITableColumn iTableColumn) {
        this.add(iTableColumn);
    }

    private void fillVisibleColumnList(TJoinTable tJoinTable) {
        if (tJoinTable == null) {
            return;
        }
        if (tJoinTable.getColumns() != null) {
            TTableDef tTableDef = DBStructure.getTable(tJoinTable.getTableName());
            Object object = tJoinTable.getColumns().elements();
            while (object.hasMoreElements()) {
                TJoinColumn tJoinColumn = (TJoinColumn)object.nextElement();
                TFieldDef tFieldDef = tTableDef.getField(tJoinColumn.getOrgNazwaPola());
                if (!tFieldDef.isVisible()) continue;
                TFieldDef.RodzajWysw rodzajWysw = null;
                rodzajWysw = tJoinColumn.getRodzajWysw() != null ? tJoinColumn.getRodzajWysw() : tFieldDef.getRodzajWysw();
                this.add(new DefaultTableColumn(tJoinTable.getTableAlias(), tJoinTable.getTableName(), tJoinColumn.getOrgNazwaPola(), tJoinColumn.getNazwaPola(), tJoinColumn.getLabelPola(), tJoinColumn.getLabelPolaExt(), tJoinTable.getDisplayName(), tJoinTable.getDisplayName(), rodzajWysw, tFieldDef.getDefaultColumnWidth(), 1, -1, tJoinColumn.isSortable(), tJoinColumn.isSearchable()));
            }
        }
        if (tJoinTable.getJoinTables() != null) {
            for (Object object : tJoinTable.getJoinTables()) {
                this.fillVisibleColumnList((TJoinTable)object);
            }
        }
    }

    private void fillVisibleColumnList(TJoinTable tJoinTable, TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        if (tJoinTable == null) {
            return;
        }
        if (tJoinTable.getColumns() != null) {
            TTableDef tTableDef = DBStructure.getTable(tJoinTable.getTableName());
            Object object = tJoinTable.getColumns().elements();
            while (object.hasMoreElements()) {
                TJoinColumn tJoinColumn = (TJoinColumn)object.nextElement();
                TFieldDef tFieldDef = tTableDef.getField(tJoinColumn.getOrgNazwaPola());
                if (!tFieldDef.isVisible()) continue;
                for (TSelectedDetailsColumn tSelectedDetailsColumn : tSelectedDetailsColumnList) {
                    if (!tSelectedDetailsColumn.equals(tJoinColumn)) continue;
                    TFieldDef.RodzajWysw rodzajWysw = null;
                    rodzajWysw = tJoinColumn.getRodzajWysw() != null ? tJoinColumn.getRodzajWysw() : tFieldDef.getRodzajWysw();
                    this.add(new DefaultTableColumn(tJoinTable.getTableAlias(), tJoinTable.getTableName(), tJoinColumn.getOrgNazwaPola(), tJoinColumn.getNazwaPola(), tJoinColumn.getLabelPola(), tJoinColumn.getLabelPolaExt(), tJoinTable.getDisplayName(), tJoinTable.getDisplayName(), rodzajWysw, tFieldDef.getDefaultColumnWidth(), 1, tSelectedDetailsColumn.getColumnNumber(), tJoinColumn.isSortable(), tJoinColumn.isSearchable()));
                }
            }
        }
        if (tJoinTable.getJoinTables() != null) {
            for (Object object : tJoinTable.getJoinTables()) {
                this.fillVisibleColumnList((TJoinTable)object, tSelectedDetailsColumnList);
            }
        }
    }

    private void fillVisibleColumnList(TJoinTable tJoinTable, TSelectedTableColumnList tSelectedTableColumnList) {
        if (tJoinTable == null) {
            return;
        }
        if (tJoinTable.getColumns() != null) {
            TTableDef tTableDef = DBStructure.getTable(tJoinTable.getTableName());
            Object object = tJoinTable.getColumns().elements();
            while (object.hasMoreElements()) {
                TJoinColumn tJoinColumn = (TJoinColumn)object.nextElement();
                TFieldDef tFieldDef = tTableDef.getField(tJoinColumn.getOrgNazwaPola());
                if (!tFieldDef.isVisible()) continue;
                for (TSelectedTableColumn tSelectedTableColumn : tSelectedTableColumnList) {
                    if (!tSelectedTableColumn.equals(tJoinColumn)) continue;
                    TFieldDef.RodzajWysw rodzajWysw = null;
                    rodzajWysw = tJoinColumn.getRodzajWysw() != null ? tJoinColumn.getRodzajWysw() : tFieldDef.getRodzajWysw();
                    this.add(new DefaultTableColumn(tJoinTable.getTableAlias(), tJoinTable.getTableName(), tJoinColumn.getOrgNazwaPola(), tJoinColumn.getNazwaPola(), tJoinColumn.getLabelPola(), tJoinColumn.getLabelPolaExt(), tJoinTable.getDisplayName(), tJoinTable.getDisplayName(), rodzajWysw, tSelectedTableColumn.getColumnSize(), tSelectedTableColumn.getColumnSizeUnit(), tSelectedTableColumn.getColumnNumber(), tJoinColumn.isSortable(), tJoinColumn.isSearchable()));
                }
            }
        }
        if (tJoinTable.getJoinTables() != null) {
            for (Object object : tJoinTable.getJoinTables()) {
                this.fillVisibleColumnList((TJoinTable)object, tSelectedTableColumnList);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

