/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import pl.com.stream.echo.lib.type.TFieldDef;
import pl.com.stream.echo.lib.type.TJoinColumn;
import pl.com.stream.echo.lib.type.TJoinTableColumns;
import pl.com.stream.echo.lib.type.TTableDef;
import pl.com.stream.echo.lib.util.database.DBStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TJoinTable {
    private TJoinTableColumns columns;
    private String displayName;
    private boolean enabled = true;
    private final String joinColumn;
    private TJoinedTables joinTables;
    private JoinTypes joinType;
    private TJoinTable owner;
    private final String ownerJoinColumn;
    private boolean required;
    private final String tableAlias;
    private final TTableDef tableDef;
    private final String tableName;
    private String tableWhere;

    public TJoinTable(String string, String string2) {
        this(string, string2, null, "ID_" + string, "ID_" + string, JoinTypes.jtInner, false);
    }

    public TJoinTable(String string, String string2, boolean bl) {
        this(string, string2, null, "ID_" + string, "ID_" + string, JoinTypes.jtInner, bl);
    }

    public TJoinTable(String string, String string2, JoinTypes joinTypes) {
        this(string, string2, null, "ID_" + string, "ID_" + string, joinTypes, false);
    }

    public TJoinTable(String string, String string2, JoinTypes joinTypes, boolean bl) {
        this(string, string2, null, "ID_" + string, "ID_" + string, joinTypes, bl);
    }

    public TJoinTable(String string, String string2, String string3, JoinTypes joinTypes) {
        this(string, string2, null, string3, string3, joinTypes, false);
    }

    public TJoinTable(String string, String string2, String string3, JoinTypes joinTypes, boolean bl) {
        this(string, string2, null, string3, string3, joinTypes, bl);
    }

    public TJoinTable(String string, String string2, String string3, String string4, JoinTypes joinTypes) {
        this(string, string2, string3, string4, string4, joinTypes, false);
    }

    public TJoinTable(String string, String string2, String string3, String string4, JoinTypes joinTypes, boolean bl) {
        this(string, string2, string3, string4, string4, joinTypes, bl);
    }

    public TJoinTable(String string, String string2, String string3, String string4, String string5, JoinTypes joinTypes) {
        this(string, string2, string3, string4, string5, joinTypes, false);
    }

    public TJoinTable(String string, String string2, String string3, String string4, String string5, JoinTypes joinTypes, boolean bl) {
        this.tableDef = DBStructure.getTable(string);
        this.tableName = this.tableDef.getName();
        this.tableAlias = string2;
        if (string3 == null) {
            string3 = this.tableDef.getLabel();
        }
        this.displayName = string3;
        this.joinColumn = string4;
        this.ownerJoinColumn = string5;
        this.joinType = joinTypes;
        this.required = bl;
    }

    public void addColumn(String string) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, null, null, null, false, null, null));
    }

    public void addColumn(String string, boolean bl) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, null, null, null, bl, null, null));
    }

    public void addColumn(String string, String string2, boolean bl) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, string2, null, null, bl, null, null));
    }

    public void addColumn(String string, String string2, String string3, boolean bl) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, string2, string3, string3, bl, null, null));
    }

    public void addColumn(String string, String string2, String string3, boolean bl, Boolean bl2, Boolean bl3) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, string2, string3, string3, bl, bl2, bl3));
    }

    public void addColumn(String string, String string2, String string3, boolean bl, Boolean bl2, Boolean bl3, TFieldDef.RodzajWysw rodzajWysw) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, string2, string3, string3, bl, bl2, bl3, rodzajWysw));
    }

    public void addColumn(String string, String string2, String string3, String string4, boolean bl, Boolean bl2, Boolean bl3) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(new TJoinColumn(string, string2, string3, string4, bl, bl2, bl3));
    }

    public void addColumn(TJoinColumn tJoinColumn) {
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        this.columns.addColumn(tJoinColumn);
    }

    public void addColumns(Collection<TJoinColumn> collection) {
        if (collection == null) {
            return;
        }
        if (this.columns == null) {
            this.columns = new TJoinTableColumns(this);
        }
        for (TJoinColumn tJoinColumn : collection) {
            this.columns.addColumn(tJoinColumn);
        }
    }

    public void addTable(TJoinTable tJoinTable) {
        if (this.joinTables == null) {
            this.joinTables = new TJoinedTables(this);
        }
        tJoinTable.owner = this;
        this.joinTables.addTable(tJoinTable);
    }

    public TJoinColumn getColumn(String string) {
        return this.columns.getColumn(string);
    }

    public TJoinTableColumns getColumns() {
        return this.columns;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getJoinColumn() {
        return this.joinColumn;
    }

    public TJoinedTables getJoinTables() {
        return this.joinTables;
    }

    public JoinTypes getJoinType() {
        return this.joinType;
    }

    public TJoinTable getOwner() {
        return this.owner;
    }

    public String getOwnerJoinColumn() {
        return this.ownerJoinColumn;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public TTableDef getTableDef() {
        return this.tableDef;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableWhere() {
        return this.tableWhere;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setJoinType(JoinTypes joinTypes) {
        this.joinType = joinTypes;
    }

    public void setOwner(TJoinTable tJoinTable) {
        this.owner = tJoinTable;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setTableWhere(String string) {
        this.tableWhere = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Nazwa: ");
        stringBuffer.append(this.tableDef.getName());
        stringBuffer.append("\r\nAlias: ");
        stringBuffer.append(this.tableAlias);
        stringBuffer.append("\r\nKolumny tabeli:\r\n");
        if (this.columns != null) {
            Enumeration enumeration = this.columns.elements();
            while (enumeration.hasMoreElements()) {
                Object object = (TJoinColumn)enumeration.nextElement();
                stringBuffer.append(" -  ");
                stringBuffer.append(object);
                stringBuffer.append("\r\n");
            }
        } else {
            stringBuffer.append(" -   Tabela nie posiada zdefiniowanych kolumn\r\n");
        }
        if (this.joinTables != null) {
            stringBuffer.append("Powiazania z tabelami:\r\n");
            for (Object object : this.joinTables) {
                if (((TJoinTable)object).tableName == null) continue;
                stringBuffer.append(" -   ");
                stringBuffer.append(((TJoinTable)object).tableName);
                stringBuffer.append("\r\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TJoinedTables
    extends ArrayList<TJoinTable> {
        private static final long serialVersionUID = 7485076359105852741L;
        private final TJoinTable owner;

        public TJoinedTables(TJoinTable tJoinTable2) {
            this.owner = tJoinTable2;
        }

        public void addTable(TJoinTable tJoinTable) {
            tJoinTable.setOwner(this.owner);
            super.add(tJoinTable);
        }

        public TJoinTable getTable(int n) {
            return (TJoinTable)super.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinTypes {
        jtFullOuter(""),
        jtInner(""),
        jtLeftOuter(""),
        jtMaster(""),
        jtRightOuter("");

        private final String joinText;

        private JoinTypes(String string2) {
            this.joinText = string2;
        }

        public String getJoinText() {
            return this.joinText;
        }
    }
}

