/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListMap<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -2187910957912658566L;
    private Map<String, E> map;

    @Override
    public boolean add(E e) {
        this.putOnMap(e);
        return super.add(e);
    }

    @Override
    public void add(int n, E e) {
        this.putOnMap(e);
        super.add(n, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection != null) {
            for (E e : collection) {
                this.putOnMap(e);
            }
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection != null) {
            for (E e : collection) {
                this.putOnMap(e);
            }
        }
        return super.addAll(n, collection);
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        this.removeFromMap(e);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        this.removeFromMap(object);
        return super.remove(object);
    }

    public void update(E e) {
        this.putOnMap(e);
    }

    private E putOnMap(E e) {
        if (e != null) {
            String string = this.getKey(e);
            return this.getMap().put(string, e);
        }
        return null;
    }

    private E removeFromMap(E e) {
        if (e != null) {
            String string = this.getKey(e);
            return this.getMap().remove(string);
        }
        return null;
    }

    protected E get(String string) {
        return this.getMap().get(string);
    }

    protected String getKey(E e) {
        if (e != null) {
            return e.toString();
        }
        return null;
    }

    protected Map<String, E> getMap() {
        if (this.map == null) {
            this.map = new HashMap<String, E>();
        }
        return this.map;
    }

    @Override
    protected void removeRange(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            Object e = this.get(i);
            this.removeFromMap(e);
        }
        super.removeRange(n, n2);
    }
}

