/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.tomcat.TomcatUser;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatUtil
implements Serializable {
    private static final String CATALINA_HOME = "catalina.home";
    private static Logger log = Logger.getLogger(TomcatUtil.class);
    private static final long serialVersionUID = 5826306852172702301L;
    private static final String TOMCAT_USERS_XML_FILE = "conf/tomcat-users.xml";
    private DocumentBuilder builder;
    @ResourceContainer
    private Res res;
    private final File tomcatDir;

    public TomcatUtil() throws MessageException {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.tomcatDir = this.getDefaultTomcatDir();
        this.initDocumentBuilder();
    }

    public TomcatUtil(File file) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.tomcatDir = file;
        this.initDocumentBuilder();
    }

    public void createTomcatContextDocument(String string, String string2) throws MessageException {
        this.createTomcatContextDocument(string, string2, new File(this.getTomcatDir(), "conf/Catalina/localhost/"));
    }

    public void createTomcatContextDocument(String string, String string2, File file) throws MessageException {
        String string3 = string + ".xml";
        log.debug((Object)MessageFormat.format(this.res.creatingContextFile, string3, file.getAbsolutePath()));
        try {
            Document document = this.builder.newDocument();
            Element element = document.createElement("Context");
            element.setAttribute("docBase", string2);
            document.appendChild(element);
            if (file == null || !file.isDirectory()) {
                return;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(new File(file, string3)));
        }
        catch (TransformerException transformerException) {
            String string4 = MessageFormat.format(this.res.creatingContextFileFailed, transformerException.getMessage());
            log.error((Object)string4, (Throwable)transformerException);
            throw new MessageException(string4, transformerException);
        }
    }

    public File getDefaultTomcatDir() throws MessageException {
        log.debug((Object)this.res.gettingCatalinaHome);
        String string = System.getProperty(CATALINA_HOME);
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                log.debug((Object)MessageFormat.format(this.res.catalinaHomeFound, file.getAbsolutePath()));
                return file;
            }
            throw new MessageException(this.res.informationTitle, MessageFormat.format(this.res.wrongCatalinaHomePath, file.getAbsolutePath()));
        }
        log.warn((Object)this.res.catalinaHomeNotFound);
        throw new MessageException(this.res.informationTitle, this.res.catalinaHomeNotFound);
    }

    public TomcatUser getDefaultTomcatUserWithManagerRole() throws MessageException {
        return this.getTomcatUserWithRole(null, null, "manager");
    }

    public File getTomcatDir() {
        return this.tomcatDir;
    }

    public Collection<TomcatUser> getTomcatUsers() throws MessageException {
        return this.getTomcatUsers(new File(this.getTomcatDir(), TOMCAT_USERS_XML_FILE));
    }

    public Collection<TomcatUser> getTomcatUsers(File file) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.gettingUserListFromFile, file.getAbsolutePath()));
        if (!file.isFile()) {
            throw new MessageException(this.res.informationTitle, MessageFormat.format(this.res.usersFileNotFound, file.getAbsolutePath()));
        }
        try {
            Document document = this.builder.parse(file);
            if (document == null) {
                return null;
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/tomcat-users/user", document, XPathConstants.NODESET);
            LinkedList<TomcatUser> linkedList = new LinkedList<TomcatUser>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                String string = element.getAttribute("username");
                if ("".equals(string)) {
                    string = element.getAttribute("name");
                }
                String string2 = element.getAttribute("password");
                String string3 = element.getAttribute("roles");
                linkedList.add(new TomcatUser(string, string2, string3));
            }
            return linkedList;
        }
        catch (SAXException sAXException) {
            throw new MessageException(sAXException);
        }
        catch (IOException iOException) {
            throw new MessageException(iOException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new MessageException(xPathExpressionException);
        }
    }

    public Collection<TomcatUser> getTomcatUsersWithRole(File file, String string) throws MessageException {
        Collection<TomcatUser> collection = this.getTomcatUsers(file);
        LinkedList<TomcatUser> linkedList = null;
        if (collection == null) {
            return null;
        }
        for (TomcatUser tomcatUser : collection) {
            if (!tomcatUser.hasRole(string)) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<TomcatUser>();
            }
            linkedList.add(tomcatUser);
        }
        return linkedList;
    }

    public Collection<TomcatUser> getTomcatUsersWithRole(String string) throws MessageException {
        return this.getTomcatUsersWithRole(new File(this.getTomcatDir(), TOMCAT_USERS_XML_FILE), string);
    }

    public TomcatUser getTomcatUserWithRole(String string, String string2, String string3) throws MessageException {
        TomcatUser tomcatUser = null;
        Collection<TomcatUser> collection = this.getTomcatUsersWithRole(string3);
        if (collection == null) {
            throw new MessageException(this.res.informationTitle, MessageFormat.format(this.res.userWithRoleNotDefined, string3));
        }
        for (TomcatUser tomcatUser2 : collection) {
            if (!tomcatUser2.getUserName().equals(string) || !tomcatUser2.getPassword().equals(string2)) continue;
            tomcatUser = tomcatUser2;
            break;
        }
        if (tomcatUser == null) {
            tomcatUser = collection.iterator().next();
        }
        return tomcatUser;
    }

    private void initDocumentBuilder() {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.error((Object)parserConfigurationException);
            }
        }
    }

    private class Res {
        private String catalinaHomeFound;
        private String catalinaHomeNotFound;
        private String creatingContextFile;
        private String creatingContextFileFailed;
        private String gettingCatalinaHome;
        private String gettingUserListFromFile;
        private String informationTitle;
        private String usersFileNotFound;
        private String userWithRoleNotDefined;
        private String wrongCatalinaHomePath;

        private Res() {
        }
    }
}

