/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.tomcat;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import org.apache.catalina.ant.AbstractCatalinaTask;
import org.apache.catalina.ant.DeployTask;
import org.apache.catalina.ant.ReloadTask;
import org.apache.catalina.ant.ServerinfoTask;
import org.apache.catalina.ant.StartTask;
import org.apache.catalina.ant.StopTask;
import org.apache.catalina.ant.UndeployTask;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.tomcat.TomcatUser;
import pl.com.stream.echo.lib.tomcat.event.TomcatManagerEvent;
import pl.com.stream.echo.lib.tomcat.event.TomcatManagerListener;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class TomcatManager
implements Serializable {
    private static Logger log = Logger.getLogger(TomcatManager.class);
    private static final long serialVersionUID = -3652286516237425833L;
    private EventListenerList eventListeners;
    private String password;
    private Project project;
    @ResourceContainer
    private Res res;
    private String url;
    private String user;

    public TomcatManager(String string, String string2, String string3) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.user = string;
        this.password = string2;
        this.url = string3;
        this.init();
    }

    public TomcatManager(TomcatUser tomcatUser, String string) {
        this(tomcatUser.getUserName(), tomcatUser.getPassword(), string);
    }

    public void addTomcatManagerListener(TomcatManagerListener tomcatManagerListener) {
        this.getEventListeners().add(TomcatManagerListener.class, tomcatManagerListener);
    }

    public void deploy(String string, File file) throws MessageException {
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        this.deploy(string, file.getAbsolutePath());
    }

    public void deploy(String string, String string2) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.deployingApplication, string, string2));
        if (string2 == null) {
            return;
        }
        if (string == null) {
            return;
        }
        DeployTask deployTask = new DeployTask();
        deployTask.setFailonerror(false);
        deployTask.setProject(this.project);
        deployTask.setTaskName("deploy");
        deployTask.setAlwaysLog(false);
        deployTask.setUsername(this.user);
        deployTask.setPassword(this.password);
        deployTask.setUrl(this.url);
        deployTask.setPath(string.startsWith("/") ? string : "/" + string);
        deployTask.setWar(string2);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("deploy");
        target.addTask((Task)deployTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string3 = MessageFormat.format(this.res.deployingApplicationFailed, buildException.getMessage());
            log.error((Object)string3, (Throwable)buildException);
            throw new MessageException(string3, buildException);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void reload(String string) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.restartingApplication, string));
        ReloadTask reloadTask = new ReloadTask();
        reloadTask.setFailonerror(false);
        reloadTask.setProject(this.project);
        reloadTask.setTaskName("reload");
        reloadTask.setAlwaysLog(false);
        reloadTask.setUsername(this.user);
        reloadTask.setPassword(this.password);
        reloadTask.setUrl(this.url);
        reloadTask.setPath(string.startsWith("/") ? string : "/" + string);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("reload");
        target.addTask((Task)reloadTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string2 = MessageFormat.format(this.res.restartingApplicationFailed, buildException.getMessage());
            log.error((Object)string2, (Throwable)buildException);
            throw new MessageException(string2, buildException);
        }
    }

    public void removeTomcatManagerListener(TomcatManagerListener tomcatManagerListener) {
        this.getEventListeners().remove(TomcatManagerListener.class, tomcatManagerListener);
    }

    public void serverInfo() throws MessageException {
        log.debug((Object)this.res.readingServerInfo);
        ServerinfoTask serverinfoTask = new ServerinfoTask();
        serverinfoTask.setFailonerror(false);
        serverinfoTask.setProject(this.project);
        serverinfoTask.setTaskName("info");
        serverinfoTask.setAlwaysLog(false);
        serverinfoTask.setUsername(this.user);
        serverinfoTask.setPassword(this.password);
        serverinfoTask.setUrl(this.url);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("info");
        target.addTask((Task)serverinfoTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string = MessageFormat.format(this.res.readingServerInfoFailed, buildException.getMessage());
            log.error((Object)string, (Throwable)buildException);
            throw new MessageException(string, buildException);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void start(String string) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.startingApplication, string));
        StartTask startTask = new StartTask();
        startTask.setFailonerror(false);
        startTask.setProject(this.project);
        startTask.setTaskName("start");
        startTask.setAlwaysLog(false);
        startTask.setUsername(this.user);
        startTask.setPassword(this.password);
        startTask.setUrl(this.url);
        startTask.setPath(string.startsWith("/") ? string : "/" + string);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("start");
        target.addTask((Task)startTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string2 = MessageFormat.format(this.res.startingApplicationFailed, string);
            log.error((Object)string2, (Throwable)buildException);
            throw new MessageException(string2, buildException);
        }
    }

    public void stop(String string) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.stopingApplication, string));
        StopTask stopTask = new StopTask();
        stopTask.setFailonerror(false);
        stopTask.setProject(this.project);
        stopTask.setTaskName("stop");
        stopTask.setAlwaysLog(false);
        stopTask.setUsername(this.user);
        stopTask.setPassword(this.password);
        stopTask.setUrl(this.url);
        stopTask.setPath(string.startsWith("/") ? string : "/" + string);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("stop");
        target.addTask((Task)stopTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string2 = MessageFormat.format(this.res.stopingApplicationFailed, buildException.getMessage());
            log.error((Object)string2, (Throwable)buildException);
            throw new MessageException(string2, buildException);
        }
    }

    public void undeploy(String string) throws MessageException {
        log.debug((Object)MessageFormat.format(this.res.undeployingApplication, string));
        UndeployTask undeployTask = new UndeployTask();
        undeployTask.setFailonerror(false);
        undeployTask.setProject(this.project);
        undeployTask.setTaskName("undeploy");
        undeployTask.setAlwaysLog(false);
        undeployTask.setUsername(this.user);
        undeployTask.setPassword(this.password);
        undeployTask.setUrl(this.url);
        undeployTask.setPath(string.startsWith("/") ? string : "/" + string);
        Target target = new Target();
        target.setProject(this.project);
        target.setName("undeploy");
        target.addTask((Task)undeployTask);
        try {
            target.performTasks();
        }
        catch (BuildException buildException) {
            String string2 = MessageFormat.format(this.res.undeployingApplicationFailed, buildException.getMessage());
            throw new MessageException(string2, buildException);
        }
    }

    private void fireTomcatManagerEvent(TomcatManagerEvent tomcatManagerEvent) {
        TomcatManagerListener[] tomcatManagerListenerArray;
        for (TomcatManagerListener tomcatManagerListener : tomcatManagerListenerArray = (TomcatManagerListener[])this.getEventListeners().getListeners(TomcatManagerListener.class)) {
            tomcatManagerListener.answerMessage(tomcatManagerEvent);
        }
    }

    private EventListenerList getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = new EventListenerList();
        }
        return this.eventListeners;
    }

    private void init() {
        this.project = new Project();
        this.project.setName("esklepupdate");
        this.project.addBuildListener(new BuildListener(){

            public void buildFinished(BuildEvent buildEvent) {
            }

            public void buildStarted(BuildEvent buildEvent) {
            }

            public void messageLogged(BuildEvent buildEvent) {
                if (buildEvent.getSource() instanceof AbstractCatalinaTask) {
                    AbstractCatalinaTask abstractCatalinaTask = (AbstractCatalinaTask)buildEvent.getSource();
                    TomcatManager.this.fireTomcatManagerEvent(new TomcatManagerEvent(TomcatManager.this, buildEvent.getMessage(), abstractCatalinaTask, buildEvent.getException()));
                }
            }

            public void targetFinished(BuildEvent buildEvent) {
            }

            public void targetStarted(BuildEvent buildEvent) {
            }

            public void taskFinished(BuildEvent buildEvent) {
            }

            public void taskStarted(BuildEvent buildEvent) {
            }
        });
    }

    private class Res {
        private String deployingApplication;
        private String deployingApplicationFailed;
        private String readingServerInfo;
        private String readingServerInfoFailed;
        private String restartingApplication;
        private String restartingApplicationFailed;
        private String startingApplication;
        private String startingApplicationFailed;
        private String stopingApplication;
        private String stopingApplicationFailed;
        private String undeployingApplication;
        private String undeployingApplicationFailed;

        private Res() {
        }
    }
}

