/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.resource.styles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import nextapp.echo.app.StyleSheet;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.StyleSheetLoader;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetMap {
    private static StyleSheetMap _instance;
    private static final String DEFAULT_STYLE_PATH = "/resource/stylesheet/";
    private static final Logger log;
    private static final long serialVersionUID = 8787504763044580514L;
    private static HashMap<String, StyleSheet> stylesMap;

    public static String getDefaultStyleSheetName() {
        return Res.windowsXpSilver;
    }

    public static StyleSheetMap getInstance() {
        if (_instance == null) {
            _instance = new StyleSheetMap();
        }
        return _instance;
    }

    private StyleSheetMap() {
    }

    public StyleSheet getStyleSheet(String string) {
        if (string == null) {
            return null;
        }
        this.checkIfNeedInit();
        return stylesMap.get(string);
    }

    public Set<String> getStyleSheetKeys() {
        this.checkIfNeedInit();
        return stylesMap.keySet();
    }

    public Collection<StyleSheet> getStyleSheets() {
        this.checkIfNeedInit();
        return stylesMap.values();
    }

    public void registerStyleSheet(String string, String string2) {
        this.registerStyleSheet(string, DEFAULT_STYLE_PATH, string2);
    }

    public void registerStyleSheet(String string, String string2, String string3) {
        this.checkIfNeedInit();
        try {
            StyleSheet styleSheet = StyleSheetLoader.load((String)(DEFAULT_STYLE_PATH + string3), (ClassLoader)Thread.currentThread().getContextClassLoader());
            stylesMap.put(string, styleSheet);
        }
        catch (SerialException serialException) {
            log.error((Object)serialException);
        }
    }

    private void checkIfNeedInit() {
        if (stylesMap == null) {
            stylesMap = new HashMap();
            this.registerStyleSheet(Res.windowsXpBlue, "XpBlueTheme.stylesheet");
            this.registerStyleSheet(Res.windowsXpGreen, "XpGreenTheme.stylesheet");
            this.registerStyleSheet(Res.windowsXpSilver, "XpSilverTheme.stylesheet");
        }
    }

    static {
        log = Logger.getLogger(StyleSheetMap.class);
        ResourceManager.bind(StyleSheetMap.class);
    }

    @ResourceContainer
    private static class Res {
        private static String windowsXpBlue;
        private static String windowsXpGreen;
        private static String windowsXpSilver;

        private Res() {
        }
    }
}

