/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.graphic.BorderImageReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowBorderManager {
    private static final Logger log = Logger.getLogger(WindowBorderManager.class);
    private BufferedImage border;
    private Insets borderContentInsets;
    private HashMap<BorderType, FillImage> borderImages;
    private Insets borderInsets;
    private String borderResource;
    private int cutLineH1 = 29;
    private int cutLineH2 = 53;
    private int cutLineHStart = 0;
    private int cutLineHStop = 72;
    private int cutLineV1 = 19;
    private int cutLineV2 = 38;
    private int cutLineVStart = 0;
    private int cutLineVStop = 57;
    private boolean load = true;
    private int titleHeight = 27;

    public boolean canRenderBorderImages() {
        return this.borderResource != null && this.borderInsets != null && this.borderContentInsets != null;
    }

    public Insets getBorderContentInsets() {
        return this.borderContentInsets;
    }

    public synchronized FillImage getBorderImage(BorderType borderType) {
        if (borderType == null) {
            throw new IllegalArgumentException("border type can not be null!");
        }
        if (this.load) {
            this.fillBorderImages();
        }
        return this.getBorderImages().get((Object)borderType);
    }

    public HashMap<BorderType, FillImage> getBorderImages() {
        if (this.borderImages == null) {
            this.borderImages = new HashMap();
        }
        return this.borderImages;
    }

    public Insets getBorderInsets() {
        return this.borderInsets;
    }

    public void setBorderContentInsets(Insets insets) {
        this.borderContentInsets = insets;
    }

    public void setBorderInsets(Insets insets) {
        this.borderInsets = insets;
        if (insets != null) {
            int n = insets.getLeft().getValue();
            int n2 = insets.getRight().getValue();
            int n3 = insets.getTop().getValue();
            int n4 = insets.getBottom().getValue();
            this.cutLineV1 = n;
            this.cutLineV2 = this.cutLineVStop - n2;
            this.cutLineH1 = n3;
            this.cutLineH2 = this.cutLineHStop - n4;
        }
    }

    public void setBorderResource(String string) {
        if (this.borderResource != null) {
            String string2 = this.borderResource;
            if (!string2.equals(string)) {
                this.borderResource = string;
                this.load = true;
            } else {
                this.load = false;
            }
        } else {
            this.borderResource = string;
            this.load = true;
        }
    }

    public void setTitleHeight(int n) {
        this.titleHeight = n;
    }

    private FillImage createFillImage(BorderType borderType, int n) {
        BorderImageParameters borderImageParameters = this.getBorderImageSize(borderType);
        BufferedImage bufferedImage = new BufferedImage(borderImageParameters.getWidth(), borderImageParameters.getHeight(), 2);
        int[] nArray = new int[this.getBorderImage().getWidth() * this.getBorderImage().getHeight()];
        this.getBorderImage().getRGB(borderImageParameters.getPosX(), borderImageParameters.getPosY(), borderImageParameters.getWidth(), borderImageParameters.getHeight(), nArray, 0, borderImageParameters.getWidth());
        bufferedImage.setRGB(0, 0, borderImageParameters.getWidth(), borderImageParameters.getHeight(), nArray, 0, borderImageParameters.getWidth());
        BorderImageReference borderImageReference = new BorderImageReference(bufferedImage);
        FillImage fillImage = new FillImage((ImageReference)borderImageReference, null, null, n);
        return fillImage;
    }

    private void fillBorderImages() {
        if (this.loadImageFromResource(this.borderResource)) {
            this.getBorderImages().clear();
            this.getBorderImages().put(BorderType.TOP_LEFT, this.createFillImage(BorderType.TOP_LEFT, 0));
            this.getBorderImages().put(BorderType.TOP, this.createFillImage(BorderType.TOP, 1));
            this.getBorderImages().put(BorderType.TOP_RIGHT, this.createFillImage(BorderType.TOP_RIGHT, 0));
            this.getBorderImages().put(BorderType.LEFT, this.createFillImage(BorderType.LEFT, 2));
            this.getBorderImages().put(BorderType.RIGHT, this.createFillImage(BorderType.RIGHT, 2));
            this.getBorderImages().put(BorderType.BOTTOM_LEFT, this.createFillImage(BorderType.BOTTOM_LEFT, 0));
            this.getBorderImages().put(BorderType.BOTTOM, this.createFillImage(BorderType.BOTTOM, 1));
            this.getBorderImages().put(BorderType.BOTTOM_RIGHT, this.createFillImage(BorderType.BOTTOM_RIGHT, 0));
            this.getBorderImages().put(BorderType.TITLE_BAR, this.createFillImage(BorderType.TITLE_BAR, 1));
        }
        this.load = false;
    }

    private BufferedImage getBorderImage() {
        return this.border;
    }

    private BorderImageParameters getBorderImageSize(BorderType borderType) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.titleHeight;
        switch (borderType) {
            case TOP_LEFT: {
                n = this.cutLineVStart;
                n2 = this.cutLineHStart;
                n3 = this.cutLineV1;
                n4 = this.cutLineH1;
                break;
            }
            case TOP: {
                n = this.cutLineV1;
                n2 = this.cutLineHStart;
                n3 = n5;
                n4 = 2;
                break;
            }
            case TOP_RIGHT: {
                n = this.cutLineV2;
                n2 = this.cutLineHStart;
                n3 = this.cutLineVStop - this.cutLineV2;
                n4 = this.cutLineH1;
                break;
            }
            case LEFT: {
                n = this.cutLineVStart;
                n2 = this.cutLineH1;
                n3 = this.cutLineV1;
                n4 = this.cutLineH2 - this.cutLineH1;
                break;
            }
            case RIGHT: {
                n = this.cutLineV2;
                n2 = this.cutLineH1;
                n3 = this.cutLineVStop - this.cutLineV2;
                n4 = this.cutLineH2 - this.cutLineH1;
                break;
            }
            case BOTTOM_LEFT: {
                n = this.cutLineVStart;
                n2 = this.cutLineH2;
                n3 = this.cutLineV1;
                n4 = this.cutLineHStop - this.cutLineH2;
                break;
            }
            case BOTTOM: {
                n = this.cutLineV1 + 2;
                n2 = this.cutLineH2;
                n3 = n5;
                n4 = this.cutLineHStop - this.cutLineH2;
                break;
            }
            case BOTTOM_RIGHT: {
                n = this.cutLineV2;
                n2 = this.cutLineH2;
                n3 = this.cutLineVStop - this.cutLineV2;
                n4 = this.cutLineHStop - this.cutLineH2;
                break;
            }
            case TITLE_BAR: {
                n = this.cutLineV1 + 2;
                n2 = this.cutLineHStart + 2;
                n3 = n5;
                n4 = this.titleHeight;
            }
        }
        BorderImageParameters borderImageParameters = new BorderImageParameters(n, n2, n3, n4);
        return borderImageParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadImageFromResource(String string) {
        if (string == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource: " + string + " not found.");
            }
            this.border = ImageIO.read(inputStream);
            if (this.border != null) {
                this.cutLineHStart = 0;
                this.cutLineVStart = 0;
                this.cutLineHStop = this.border.getHeight();
                this.cutLineVStop = this.border.getWidth();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private class BorderImageParameters {
        private final int height;
        private final int posX;
        private final int posY;
        private final int width;

        public BorderImageParameters(int n, int n2, int n3, int n4) {
            this.posX = n;
            this.posY = n2;
            this.width = n3;
            this.height = n4;
        }

        public int getHeight() {
            return this.height;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return "x: " + this.posX + ", y: " + this.posY + ", w: " + this.width + ", h: " + this.height;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderType {
        BOTTOM("b", "borderBottom"),
        BOTTOM_LEFT("bl", "borderBottomLeft"),
        BOTTOM_RIGHT("br", "borderBottomRight"),
        LEFT("l", "borderLeft"),
        RIGHT("r", "borderRight"),
        TITLE_BAR(null, "titleBackground"),
        TOP("t", "borderTop"),
        TOP_LEFT("tl", "borderTopLeft"),
        TOP_RIGHT("tr", "borderTopRight");

        private String cssId;
        private String name;

        private BorderType(String string2, String string3) {
            this.name = string2;
            this.cssId = string3;
        }

        public String getCssId() {
            return this.cssId;
        }

        public String getName() {
            return this.name;
        }
    }
}

